/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.bgfx.BGFXAllocatorInterface;
import org.lwjgl.bgfx.BGFXCallbackInterface;
import org.lwjgl.bgfx.BGFXCaps;
import org.lwjgl.bgfx.BGFXHmd;
import org.lwjgl.bgfx.BGFXInstanceDataBuffer;
import org.lwjgl.bgfx.BGFXMemory;
import org.lwjgl.bgfx.BGFXReleaseFunctionCallbackI;
import org.lwjgl.bgfx.BGFXStats;
import org.lwjgl.bgfx.BGFXTextureInfo;
import org.lwjgl.bgfx.BGFXTransform;
import org.lwjgl.bgfx.BGFXTransientIndexBuffer;
import org.lwjgl.bgfx.BGFXTransientVertexBuffer;
import org.lwjgl.bgfx.BGFXUniformInfo;
import org.lwjgl.bgfx.BGFXVertexDecl;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class BGFX {
    public static final int BGFX_API_VERSION = 41;
    public static final short BGFX_INVALID_HANDLE = -1;
    public static final long BGFX_STATE_RGB_WRITE = 1L;
    public static final long BGFX_STATE_ALPHA_WRITE = 2L;
    public static final long BGFX_STATE_DEPTH_WRITE = 4L;
    public static final long BGFX_STATE_DEPTH_TEST_LESS = 16L;
    public static final long BGFX_STATE_DEPTH_TEST_LEQUAL = 32L;
    public static final long BGFX_STATE_DEPTH_TEST_EQUAL = 48L;
    public static final long BGFX_STATE_DEPTH_TEST_GEQUAL = 64L;
    public static final long BGFX_STATE_DEPTH_TEST_GREATER = 80L;
    public static final long BGFX_STATE_DEPTH_TEST_NOTEQUAL = 96L;
    public static final long BGFX_STATE_DEPTH_TEST_NEVER = 112L;
    public static final long BGFX_STATE_DEPTH_TEST_ALWAYS = 128L;
    public static final long BGFX_STATE_BLEND_ZERO = 4096L;
    public static final long BGFX_STATE_BLEND_ONE = 8192L;
    public static final long BGFX_STATE_BLEND_SRC_COLOR = 12288L;
    public static final long BGFX_STATE_BLEND_INV_SRC_COLOR = 16384L;
    public static final long BGFX_STATE_BLEND_SRC_ALPHA = 20480L;
    public static final long BGFX_STATE_BLEND_INV_SRC_ALPHA = 24576L;
    public static final long BGFX_STATE_BLEND_DST_ALPHA = 28672L;
    public static final long BGFX_STATE_BLEND_INV_DST_ALPHA = 32768L;
    public static final long BGFX_STATE_BLEND_DST_COLOR = 36864L;
    public static final long BGFX_STATE_BLEND_INV_DST_COLOR = 40960L;
    public static final long BGFX_STATE_BLEND_SRC_ALPHA_SAT = 45056L;
    public static final long BGFX_STATE_BLEND_FACTOR = 49152L;
    public static final long BGFX_STATE_BLEND_INV_FACTOR = 53248L;
    public static final long BGFX_STATE_BLEND_EQUATION_ADD = 0L;
    public static final long BGFX_STATE_BLEND_EQUATION_SUB = 0x10000000L;
    public static final long BGFX_STATE_BLEND_EQUATION_REVSUB = 0x20000000L;
    public static final long BGFX_STATE_BLEND_EQUATION_MIN = 0x30000000L;
    public static final long BGFX_STATE_BLEND_EQUATION_MAX = 0x40000000L;
    public static final long BGFX_STATE_BLEND_INDEPENDENT = 0x400000000L;
    public static final long BGFX_STATE_BLEND_ALPHA_TO_COVERAGE = 0x800000000L;
    public static final long BGFX_STATE_CULL_CW = 0x1000000000L;
    public static final long BGFX_STATE_CULL_CCW = 0x2000000000L;
    public static final long BGFX_STATE_PT_TRISTRIP = 0x1000000000000L;
    public static final long BGFX_STATE_PT_LINES = 0x2000000000000L;
    public static final long BGFX_STATE_PT_LINESTRIP = 0x3000000000000L;
    public static final long BGFX_STATE_PT_POINTS = 0x4000000000000L;
    public static final long BGFX_STATE_MSAA = 0x100000000000000L;
    public static final long BGFX_STATE_LINEAA = 0x200000000000000L;
    public static final long BGFX_STATE_CONSERVATIVE_RASTER = 0x400000000000000L;
    public static final long BGFX_STATE_NONE = 0L;
    public static final long BGFX_STATE_DEFAULT = 0x100001000000017L;
    public static final long BGFX_STATE_DEPTH_TEST_MASK = 240L;
    public static final long BGFX_STATE_BLEND_MASK = 0xFFFF000L;
    public static final long BGFX_STATE_BLEND_EQUATION_MASK = 0x3F0000000L;
    public static final long BGFX_STATE_CULL_MASK = 0x3000000000L;
    public static final long BGFX_STATE_ALPHA_REF_MASK = 0xFF0000000000L;
    public static final long BGFX_STATE_PT_MASK = 0x7000000000000L;
    public static final long BGFX_STATE_POINT_SIZE_MASK = 0xF0000000000000L;
    public static final long BGFX_STATE_RESERVED_MASK = -2305843009213693952L;
    public static final long BGFX_STATE_MASK = -1L;
    public static final int BGFX_STATE_DEPTH_TEST_SHIFT = 4;
    public static final int BGFX_STATE_BLEND_SHIFT = 12;
    public static final int BGFX_STATE_BLEND_EQUATION_SHIFT = 28;
    public static final int BGFX_STATE_CULL_SHIFT = 36;
    public static final int BGFX_STATE_ALPHA_REF_SHIFT = 40;
    public static final int BGFX_STATE_PT_SHIFT = 48;
    public static final int BGFX_STATE_POINT_SIZE_SHIFT = 52;
    public static final int BGFX_STATE_RESERVED_SHIFT = 61;
    public static final int BGFX_STENCIL_TEST_LESS = 65536;
    public static final int BGFX_STENCIL_TEST_LEQUAL = 131072;
    public static final int BGFX_STENCIL_TEST_EQUAL = 196608;
    public static final int BGFX_STENCIL_TEST_GEQUAL = 262144;
    public static final int BGFX_STENCIL_TEST_GREATER = 327680;
    public static final int BGFX_STENCIL_TEST_NOTEQUAL = 393216;
    public static final int BGFX_STENCIL_TEST_NEVER = 458752;
    public static final int BGFX_STENCIL_TEST_ALWAYS = 524288;
    public static final int BGFX_STENCIL_OP_FAIL_S_ZERO = 0;
    public static final int BGFX_STENCIL_OP_FAIL_S_KEEP = 0x100000;
    public static final int BGFX_STENCIL_OP_FAIL_S_REPLACE = 0x200000;
    public static final int BGFX_STENCIL_OP_FAIL_S_INCR = 0x300000;
    public static final int BGFX_STENCIL_OP_FAIL_S_INCRSAT = 0x400000;
    public static final int BGFX_STENCIL_OP_FAIL_S_DECR = 0x500000;
    public static final int BGFX_STENCIL_OP_FAIL_S_DECRSAT = 0x600000;
    public static final int BGFX_STENCIL_OP_FAIL_S_INVERT = 0x700000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_ZERO = 0;
    public static final int BGFX_STENCIL_OP_FAIL_Z_KEEP = 0x1000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_REPLACE = 0x2000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_INCR = 0x3000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_INCRSAT = 0x4000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_DECR = 0x5000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_DECRSAT = 0x6000000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_INVERT = 0x7000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_ZERO = 0;
    public static final int BGFX_STENCIL_OP_PASS_Z_KEEP = 0x10000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_REPLACE = 0x20000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_INCR = 0x30000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_INCRSAT = 0x40000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_DECR = 0x50000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_DECRSAT = 0x60000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_INVERT = 0x70000000;
    public static final int BGFX_STENCIL_NONE = 0;
    public static final int BGFX_STENCIL_DEFAULT = 0;
    public static final int BGFX_STENCIL_FUNC_REF_SHIFT = 0;
    public static final int BGFX_STENCIL_FUNC_REF_MASK = 255;
    public static final int BGFX_STENCIL_FUNC_RMASK_SHIFT = 8;
    public static final int BGFX_STENCIL_FUNC_RMASK_MASK = 65280;
    public static final int BGFX_STENCIL_TEST_SHIFT = 16;
    public static final int BGFX_STENCIL_TEST_MASK = 983040;
    public static final int BGFX_STENCIL_OP_FAIL_S_SHIFT = 20;
    public static final int BGFX_STENCIL_OP_FAIL_S_MASK = 0xF00000;
    public static final int BGFX_STENCIL_OP_FAIL_Z_SHIFT = 24;
    public static final int BGFX_STENCIL_OP_FAIL_Z_MASK = 0xF000000;
    public static final int BGFX_STENCIL_OP_PASS_Z_SHIFT = 28;
    public static final int BGFX_STENCIL_OP_PASS_Z_MASK = -268435456;
    public static final int BGFX_STENCIL_MASK = -1;
    public static final short BGFX_CLEAR_NONE = 0;
    public static final short BGFX_CLEAR_COLOR = 1;
    public static final short BGFX_CLEAR_DEPTH = 2;
    public static final short BGFX_CLEAR_STENCIL = 4;
    public static final short BGFX_CLEAR_DISCARD_COLOR_0 = 8;
    public static final short BGFX_CLEAR_DISCARD_COLOR_1 = 16;
    public static final short BGFX_CLEAR_DISCARD_COLOR_2 = 32;
    public static final short BGFX_CLEAR_DISCARD_COLOR_3 = 64;
    public static final short BGFX_CLEAR_DISCARD_COLOR_4 = 128;
    public static final short BGFX_CLEAR_DISCARD_COLOR_5 = 256;
    public static final short BGFX_CLEAR_DISCARD_COLOR_6 = 512;
    public static final short BGFX_CLEAR_DISCARD_COLOR_7 = 1024;
    public static final short BGFX_CLEAR_DISCARD_DEPTH = 2048;
    public static final short BGFX_CLEAR_DISCARD_STENCIL = 4096;
    public static final short BGFX_CLEAR_DISCARD_COLOR_MASK = 2040;
    public static final short BGFX_CLEAR_DISCARD_MASK = 8184;
    public static final int BGFX_DEBUG_NONE = 0;
    public static final int BGFX_DEBUG_WIREFRAME = 1;
    public static final int BGFX_DEBUG_IFH = 2;
    public static final int BGFX_DEBUG_STATS = 4;
    public static final int BGFX_DEBUG_TEXT = 8;
    public static final short BGFX_BUFFER_NONE = 0;
    public static final short BGFX_BUFFER_COMPUTE_READ = 256;
    public static final short BGFX_BUFFER_COMPUTE_WRITE = 512;
    public static final short BGFX_BUFFER_DRAW_INDIRECT = 1024;
    public static final short BGFX_BUFFER_ALLOW_RESIZE = 2048;
    public static final short BGFX_BUFFER_INDEX32 = 4096;
    public static final short BGFX_BUFFER_COMPUTE_READ_WRITE = 768;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_8x1 = 1;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_8x2 = 2;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_8x4 = 3;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_16x1 = 4;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_16x2 = 5;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_16x4 = 6;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_32x1 = 7;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_32x2 = 8;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_32x4 = 9;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_SHIFT = 0;
    public static final short BGFX_BUFFER_COMPUTE_FORMAT_MASK = 15;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_UINT = 16;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_INT = 32;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_FLOAT = 48;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_SHIFT = 4;
    public static final short BGFX_BUFFER_COMPUTE_TYPE_MASK = 48;
    public static final int BGFX_TEXTURE_NONE = 0;
    public static final int BGFX_TEXTURE_U_MIRROR = 1;
    public static final int BGFX_TEXTURE_U_CLAMP = 2;
    public static final int BGFX_TEXTURE_U_BORDER = 3;
    public static final int BGFX_TEXTURE_V_MIRROR = 4;
    public static final int BGFX_TEXTURE_V_CLAMP = 8;
    public static final int BGFX_TEXTURE_V_BORDER = 12;
    public static final int BGFX_TEXTURE_W_MIRROR = 16;
    public static final int BGFX_TEXTURE_W_CLAMP = 32;
    public static final int BGFX_TEXTURE_W_BORDER = 48;
    public static final int BGFX_TEXTURE_MIN_POINT = 64;
    public static final int BGFX_TEXTURE_MIN_ANISOTROPIC = 128;
    public static final int BGFX_TEXTURE_MAG_POINT = 256;
    public static final int BGFX_TEXTURE_MAG_ANISOTROPIC = 512;
    public static final int BGFX_TEXTURE_MIP_POINT = 1024;
    public static final int BGFX_TEXTURE_MSAA_SAMPLE = 2048;
    public static final int BGFX_TEXTURE_RT = 4096;
    public static final int BGFX_TEXTURE_RT_MSAA_X2 = 8192;
    public static final int BGFX_TEXTURE_RT_MSAA_X4 = 12288;
    public static final int BGFX_TEXTURE_RT_MSAA_X8 = 16384;
    public static final int BGFX_TEXTURE_RT_MSAA_X16 = 20480;
    public static final int BGFX_TEXTURE_RT_WRITE_ONLY = 32768;
    public static final int BGFX_TEXTURE_COMPARE_LESS = 65536;
    public static final int BGFX_TEXTURE_COMPARE_LEQUAL = 131072;
    public static final int BGFX_TEXTURE_COMPARE_EQUAL = 196608;
    public static final int BGFX_TEXTURE_COMPARE_GEQUAL = 262144;
    public static final int BGFX_TEXTURE_COMPARE_GREATER = 327680;
    public static final int BGFX_TEXTURE_COMPARE_NOTEQUAL = 393216;
    public static final int BGFX_TEXTURE_COMPARE_NEVER = 458752;
    public static final int BGFX_TEXTURE_COMPARE_ALWAYS = 524288;
    public static final int BGFX_TEXTURE_COMPUTE_WRITE = 0x100000;
    public static final int BGFX_TEXTURE_SRGB = 0x200000;
    public static final int BGFX_TEXTURE_BLIT_DST = 0x400000;
    public static final int BGFX_TEXTURE_READ_BACK = 0x800000;
    public static final int BGFX_TEXTURE_U_SHIFT = 0;
    public static final int BGFX_TEXTURE_U_MASK = 3;
    public static final int BGFX_TEXTURE_V_SHIFT = 2;
    public static final int BGFX_TEXTURE_V_MASK = 12;
    public static final int BGFX_TEXTURE_W_SHIFT = 4;
    public static final int BGFX_TEXTURE_W_MASK = 48;
    public static final int BGFX_TEXTURE_MIN_SHIFT = 6;
    public static final int BGFX_TEXTURE_MIN_MASK = 192;
    public static final int BGFX_TEXTURE_MAG_SHIFT = 8;
    public static final int BGFX_TEXTURE_MAG_MASK = 768;
    public static final int BGFX_TEXTURE_MIP_SHIFT = 10;
    public static final int BGFX_TEXTURE_MIP_MASK = 1024;
    public static final int BGFX_TEXTURE_RT_MSAA_SHIFT = 12;
    public static final int BGFX_TEXTURE_RT_MSAA_MASK = 28672;
    public static final int BGFX_TEXTURE_RT_MASK = 61440;
    public static final int BGFX_TEXTURE_COMPARE_SHIFT = 16;
    public static final int BGFX_TEXTURE_COMPARE_MASK = 983040;
    public static final int BGFX_TEXTURE_BORDER_COLOR_SHIFT = 24;
    public static final int BGFX_TEXTURE_BORDER_COLOR_MASK = 0xF000000;
    public static final int BGFX_TEXTURE_RESERVED_SHIFT = 28;
    public static final int BGFX_TEXTURE_RESERVED_MASK = -268435456;
    public static final int BGFX_TEXTURE_SAMPLER_BITS_MASK = 985087;
    public static final int BGFX_RESET_NONE = 0;
    public static final int BGFX_RESET_FULLSCREEN = 1;
    public static final int BGFX_RESET_FULLSCREEN_SHIFT = 0;
    public static final int BGFX_RESET_FULLSCREEN_MASK = 1;
    public static final int BGFX_RESET_MSAA_X2 = 16;
    public static final int BGFX_RESET_MSAA_X4 = 32;
    public static final int BGFX_RESET_MSAA_X8 = 48;
    public static final int BGFX_RESET_MSAA_X16 = 64;
    public static final int BGFX_RESET_MSAA_SHIFT = 4;
    public static final int BGFX_RESET_MSAA_MASK = 112;
    public static final int BGFX_RESET_VSYNC = 128;
    public static final int BGFX_RESET_MAXANISOTROPY = 256;
    public static final int BGFX_RESET_CAPTURE = 512;
    public static final int BGFX_RESET_HMD = 1024;
    public static final int BGFX_RESET_HMD_DEBUG = 2048;
    public static final int BGFX_RESET_HMD_RECENTER = 4096;
    public static final int BGFX_RESET_FLUSH_AFTER_RENDER = 8192;
    public static final int BGFX_RESET_FLIP_AFTER_RENDER = 16384;
    public static final int BGFX_RESET_SRGB_BACKBUFFER = 32768;
    public static final int BGFX_RESET_HIDPI = 65536;
    public static final int BGFX_RESET_DEPTH_CLAMP = 131072;
    public static final int BGFX_RESET_SUSPEND = 262144;
    public static final int BGFX_RESET_RESERVED_SHIFT = 31;
    public static final int BGFX_RESET_RESERVED_MASK = Integer.MIN_VALUE;
    public static final long BGFX_CAPS_ALPHA_TO_COVERAGE = 1L;
    public static final long BGFX_CAPS_BLEND_INDEPENDENT = 2L;
    public static final long BGFX_CAPS_COMPUTE = 4L;
    public static final long BGFX_CAPS_CONSERVATIVE_RASTER = 8L;
    public static final long BGFX_CAPS_DRAW_INDIRECT = 16L;
    public static final long BGFX_CAPS_FRAGMENT_DEPTH = 32L;
    public static final long BGFX_CAPS_FRAGMENT_ORDERING = 64L;
    public static final long BGFX_CAPS_GRAPHICS_DEBUGGER = 128L;
    public static final long BGFX_CAPS_HIDPI = 256L;
    public static final long BGFX_CAPS_HMD = 512L;
    public static final long BGFX_CAPS_INDEX32 = 1024L;
    public static final long BGFX_CAPS_INSTANCING = 2048L;
    public static final long BGFX_CAPS_OCCLUSION_QUERY = 4096L;
    public static final long BGFX_CAPS_RENDERER_MULTITHREADED = 8192L;
    public static final long BGFX_CAPS_SWAP_CHAIN = 16384L;
    public static final long BGFX_CAPS_TEXTURE_2D_ARRAY = 32768L;
    public static final long BGFX_CAPS_TEXTURE_3D = 65536L;
    public static final long BGFX_CAPS_TEXTURE_BLIT = 131072L;
    public static final long BGFX_CAPS_TEXTURE_COMPARE_ALL = 786432L;
    public static final long BGFX_CAPS_TEXTURE_COMPARE_LEQUAL = 524288L;
    public static final long BGFX_CAPS_TEXTURE_CUBE_ARRAY = 0x100000L;
    public static final long BGFX_CAPS_TEXTURE_READ_BACK = 0x200000L;
    public static final long BGFX_CAPS_VERTEX_ATTRIB_HALF = 0x400000L;
    public static final long BGFX_CAPS_VERTEX_ATTRIB_UINT10 = 0x800000L;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_NONE = 0;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_2D = 1;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_2D_SRGB = 2;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_2D_EMULATED = 4;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_3D = 8;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_3D_SRGB = 16;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_3D_EMULATED = 32;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_CUBE = 64;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_CUBE_SRGB = 128;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_CUBE_EMULATED = 256;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_VERTEX = 512;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_IMAGE = 1024;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_FRAMEBUFFER = 2048;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_FRAMEBUFFER_MSAA = 4096;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_MSAA = 8192;
    public static final short BGFX_CAPS_FORMAT_TEXTURE_MIP_AUTOGEN = 16384;
    public static final byte BGFX_VIEW_NONE = 0;
    public static final byte BGFX_VIEW_STEREO = 1;
    public static final byte BGFX_SUBMIT_EYE_LEFT = 1;
    public static final byte BGFX_SUBMIT_EYE_RIGHT = 2;
    public static final byte BGFX_SUBMIT_EYE_FIRST = 1;
    public static final byte BGFX_SUBMIT_EYE_MASK = 3;
    public static final byte BGFX_SUBMIT_RESERVED_SHIFT = 7;
    public static final byte BGFX_SUBMIT_RESERVED_MASK = -128;
    public static final short BGFX_PCI_ID_NONE = 0;
    public static final short BGFX_PCI_ID_SOFTWARE_RASTERIZER = 1;
    public static final short BGFX_PCI_ID_AMD = 4098;
    public static final short BGFX_PCI_ID_INTEL = -32634;
    public static final short BGFX_PCI_ID_NVIDIA = 4318;
    public static final byte BGFX_HMD_NONE = 0;
    public static final byte BGFX_HMD_DEVICE_RESOLUTION = 1;
    public static final byte BGFX_HMD_RENDERING = 2;
    public static final byte BGFX_CUBE_MAP_POSITIVE_X = 0;
    public static final byte BGFX_CUBE_MAP_NEGATIVE_X = 1;
    public static final byte BGFX_CUBE_MAP_POSITIVE_Y = 2;
    public static final byte BGFX_CUBE_MAP_NEGATIVE_Y = 3;
    public static final byte BGFX_CUBE_MAP_POSITIVE_Z = 4;
    public static final byte BGFX_CUBE_MAP_NEGATIVE_Z = 5;
    public static final int BGFX_RENDERER_TYPE_NOOP = 0;
    public static final int BGFX_RENDERER_TYPE_DIRECT3D9 = 1;
    public static final int BGFX_RENDERER_TYPE_DIRECT3D11 = 2;
    public static final int BGFX_RENDERER_TYPE_DIRECT3D12 = 3;
    public static final int BGFX_RENDERER_TYPE_GNM = 4;
    public static final int BGFX_RENDERER_TYPE_METAL = 5;
    public static final int BGFX_RENDERER_TYPE_OPENGLES = 6;
    public static final int BGFX_RENDERER_TYPE_OPENGL = 7;
    public static final int BGFX_RENDERER_TYPE_VULKAN = 8;
    public static final int BGFX_RENDERER_TYPE_COUNT = 9;
    public static final int BGFX_ACCESS_READ = 0;
    public static final int BGFX_ACCESS_WRITE = 1;
    public static final int BGFX_ACCESS_READWRITE = 2;
    public static final int BGFX_ACCESS_COUNT = 3;
    public static final int BGFX_ATTRIB_POSITION = 0;
    public static final int BGFX_ATTRIB_NORMAL = 1;
    public static final int BGFX_ATTRIB_TANGENT = 2;
    public static final int BGFX_ATTRIB_BITANGENT = 3;
    public static final int BGFX_ATTRIB_COLOR0 = 4;
    public static final int BGFX_ATTRIB_COLOR1 = 5;
    public static final int BGFX_ATTRIB_INDICES = 6;
    public static final int BGFX_ATTRIB_WEIGHT = 7;
    public static final int BGFX_ATTRIB_TEXCOORD0 = 8;
    public static final int BGFX_ATTRIB_TEXCOORD1 = 9;
    public static final int BGFX_ATTRIB_TEXCOORD2 = 10;
    public static final int BGFX_ATTRIB_TEXCOORD3 = 11;
    public static final int BGFX_ATTRIB_TEXCOORD4 = 12;
    public static final int BGFX_ATTRIB_TEXCOORD5 = 13;
    public static final int BGFX_ATTRIB_TEXCOORD6 = 14;
    public static final int BGFX_ATTRIB_TEXCOORD7 = 15;
    public static final int BGFX_ATTRIB_COUNT = 16;
    public static final int BGFX_ATTRIB_TYPE_UINT8 = 0;
    public static final int BGFX_ATTRIB_TYPE_UINT10 = 1;
    public static final int BGFX_ATTRIB_TYPE_INT16 = 2;
    public static final int BGFX_ATTRIB_TYPE_HALF = 3;
    public static final int BGFX_ATTRIB_TYPE_FLOAT = 4;
    public static final int BGFX_ATTRIB_TYPE_COUNT = 5;
    public static final int BGFX_TEXTURE_FORMAT_BC1 = 0;
    public static final int BGFX_TEXTURE_FORMAT_BC2 = 1;
    public static final int BGFX_TEXTURE_FORMAT_BC3 = 2;
    public static final int BGFX_TEXTURE_FORMAT_BC4 = 3;
    public static final int BGFX_TEXTURE_FORMAT_BC5 = 4;
    public static final int BGFX_TEXTURE_FORMAT_BC6H = 5;
    public static final int BGFX_TEXTURE_FORMAT_BC7 = 6;
    public static final int BGFX_TEXTURE_FORMAT_ETC1 = 7;
    public static final int BGFX_TEXTURE_FORMAT_ETC2 = 8;
    public static final int BGFX_TEXTURE_FORMAT_ETC2A = 9;
    public static final int BGFX_TEXTURE_FORMAT_ETC2A1 = 10;
    public static final int BGFX_TEXTURE_FORMAT_PTC12 = 11;
    public static final int BGFX_TEXTURE_FORMAT_PTC14 = 12;
    public static final int BGFX_TEXTURE_FORMAT_PTC12A = 13;
    public static final int BGFX_TEXTURE_FORMAT_PTC14A = 14;
    public static final int BGFX_TEXTURE_FORMAT_PTC22 = 15;
    public static final int BGFX_TEXTURE_FORMAT_PTC24 = 16;
    public static final int BGFX_TEXTURE_FORMAT_UNKNOWN = 17;
    public static final int BGFX_TEXTURE_FORMAT_R1 = 18;
    public static final int BGFX_TEXTURE_FORMAT_A8 = 19;
    public static final int BGFX_TEXTURE_FORMAT_R8 = 20;
    public static final int BGFX_TEXTURE_FORMAT_R8I = 21;
    public static final int BGFX_TEXTURE_FORMAT_R8U = 22;
    public static final int BGFX_TEXTURE_FORMAT_R8S = 23;
    public static final int BGFX_TEXTURE_FORMAT_R16 = 24;
    public static final int BGFX_TEXTURE_FORMAT_R16I = 25;
    public static final int BGFX_TEXTURE_FORMAT_R16U = 26;
    public static final int BGFX_TEXTURE_FORMAT_R16F = 27;
    public static final int BGFX_TEXTURE_FORMAT_R16S = 28;
    public static final int BGFX_TEXTURE_FORMAT_R32I = 29;
    public static final int BGFX_TEXTURE_FORMAT_R32U = 30;
    public static final int BGFX_TEXTURE_FORMAT_R32F = 31;
    public static final int BGFX_TEXTURE_FORMAT_RG8 = 32;
    public static final int BGFX_TEXTURE_FORMAT_RG8I = 33;
    public static final int BGFX_TEXTURE_FORMAT_RG8U = 34;
    public static final int BGFX_TEXTURE_FORMAT_RG8S = 35;
    public static final int BGFX_TEXTURE_FORMAT_RG16 = 36;
    public static final int BGFX_TEXTURE_FORMAT_RG16I = 37;
    public static final int BGFX_TEXTURE_FORMAT_RG16U = 38;
    public static final int BGFX_TEXTURE_FORMAT_RG16F = 39;
    public static final int BGFX_TEXTURE_FORMAT_RG16S = 40;
    public static final int BGFX_TEXTURE_FORMAT_RG32I = 41;
    public static final int BGFX_TEXTURE_FORMAT_RG32U = 42;
    public static final int BGFX_TEXTURE_FORMAT_RG32F = 43;
    public static final int BGFX_TEXTURE_FORMAT_RGB8 = 44;
    public static final int BGFX_TEXTURE_FORMAT_RGB8I = 45;
    public static final int BGFX_TEXTURE_FORMAT_RGB8U = 46;
    public static final int BGFX_TEXTURE_FORMAT_RGB8S = 47;
    public static final int BGFX_TEXTURE_FORMAT_RGB9E5F = 48;
    public static final int BGFX_TEXTURE_FORMAT_BGRA8 = 49;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8 = 50;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8I = 51;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8U = 52;
    public static final int BGFX_TEXTURE_FORMAT_RGBA8S = 53;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16 = 54;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16I = 55;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16U = 56;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16F = 57;
    public static final int BGFX_TEXTURE_FORMAT_RGBA16S = 58;
    public static final int BGFX_TEXTURE_FORMAT_RGBA32I = 59;
    public static final int BGFX_TEXTURE_FORMAT_RGBA32U = 60;
    public static final int BGFX_TEXTURE_FORMAT_RGBA32F = 61;
    public static final int BGFX_TEXTURE_FORMAT_R5G6B5 = 62;
    public static final int BGFX_TEXTURE_FORMAT_RGBA4 = 63;
    public static final int BGFX_TEXTURE_FORMAT_RGB5A1 = 64;
    public static final int BGFX_TEXTURE_FORMAT_RGB10A2 = 65;
    public static final int BGFX_TEXTURE_FORMAT_RG11B10F = 66;
    public static final int BGFX_TEXTURE_FORMAT_UNKNOWN_DEPTH = 67;
    public static final int BGFX_TEXTURE_FORMAT_D16 = 68;
    public static final int BGFX_TEXTURE_FORMAT_D24 = 69;
    public static final int BGFX_TEXTURE_FORMAT_D24S8 = 70;
    public static final int BGFX_TEXTURE_FORMAT_D32 = 71;
    public static final int BGFX_TEXTURE_FORMAT_D16F = 72;
    public static final int BGFX_TEXTURE_FORMAT_D24F = 73;
    public static final int BGFX_TEXTURE_FORMAT_D32F = 74;
    public static final int BGFX_TEXTURE_FORMAT_D0S8 = 75;
    public static final int BGFX_TEXTURE_FORMAT_COUNT = 76;
    public static final int BGFX_UNIFORM_TYPE_INT1 = 0;
    public static final int BGFX_UNIFORM_TYPE_END = 1;
    public static final int BGFX_UNIFORM_TYPE_VEC4 = 2;
    public static final int BGFX_UNIFORM_TYPE_MAT3 = 3;
    public static final int BGFX_UNIFORM_TYPE_MAT4 = 4;
    public static final int BGFX_UNIFORM_TYPE_COUNT = 5;
    public static final int BGFX_BACKBUFFER_RATIO_EQUAL = 0;
    public static final int BGFX_BACKBUFFER_RATIO_HALF = 1;
    public static final int BGFX_BACKBUFFER_RATIO_QUARTER = 2;
    public static final int BGFX_BACKBUFFER_RATIO_EIGHTH = 3;
    public static final int BGFX_BACKBUFFER_RATIO_SIXTEENTH = 4;
    public static final int BGFX_BACKBUFFER_RATIO_DOUBLE = 5;
    public static final int BGFX_BACKBUFFER_RATIO_COUNT = 6;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_INVISIBLE = 0;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_VISIBLE = 1;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_NORESULT = 2;
    public static final int BGFX_OCCLUSION_QUERY_RESULT_COUNT = 3;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_LIST_FLIP_WINDING = 0;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_LIST_TO_LINE_LIST = 1;
    public static final int BGFX_TOPOLOGY_CONVERT_TRI_STRIP_TO_TRI_LIST = 2;
    public static final int BGFX_TOPOLOGY_CONVERT_LINE_STRIP_TO_LINE_LIST = 3;
    public static final int BGFX_TOPOLOGY_CONVERT_COUNT = 4;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_FRONT_TO_BACK_MIN = 0;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_FRONT_TO_BACK_AVG = 1;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_FRONT_TO_BACK_MAX = 2;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_BACK_TO_FRONT_MIN = 3;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_BACK_TO_FRONT_AVG = 4;
    public static final int BGFX_TOPOLOGY_SORT_DIRECTION_BACK_TO_FRONT_MAX = 5;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_FRONT_TO_BACK_MIN = 6;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_FRONT_TO_BACK_AVG = 7;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_FRONT_TO_BACK_MAX = 8;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_BACK_TO_FRONT_MIN = 9;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_BACK_TO_FRONT_AVG = 10;
    public static final int BGFX_TOPOLOGY_SORT_DISTANCE_BACK_TO_FRONT_MAX = 11;
    public static final int BGFX_TOPOLOGY_SORT_COUNT = 12;
    public static final int BGFX_FATAL_DEBUG_CHECK = 0;
    public static final int BGFX_FATAL_INVALID_SHADER = 1;
    public static final int BGFX_FATAL_UNABLE_TO_INITIALIZE = 2;
    public static final int BGFX_FATAL_UNABLE_TO_CREATE_TEXTURE = 3;
    public static final int BGFX_FATAL_DEVICE_LOST = 4;
    public static final int BGFX_FATAL_COUNT = 5;
    public static final long BGFX_STATE_BLEND_ADD = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 8192L);
    public static final long BGFX_STATE_BLEND_ALPHA = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(20480L, 24576L);
    public static final long BGFX_STATE_BLEND_DARKEN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 8192L) | org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION(0x30000000L);
    public static final long BGFX_STATE_BLEND_LIGHTEN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 8192L) | org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION(0x40000000L);
    public static final long BGFX_STATE_BLEND_MULTIPLY = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(36864L, 4096L);
    public static final long BGFX_STATE_BLEND_NORMAL = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 24576L);
    public static final long BGFX_STATE_BLEND_SCREEN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(8192L, 16384L);
    public static final long BGFX_STATE_BLEND_LINEAR_BURN = org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC(36864L, 40960L) | org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION(0x10000000L);
    private static final SharedLibrary BGFX = Library.loadNative(BGFX.class, Configuration.BGFX_LIBRARY_NAME.get(Platform.mapLibraryNameBundled("bgfx")), true);

    protected BGFX() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return BGFX;
    }

    public static void nbgfx_vertex_decl_begin(long _decl, int _renderer) {
        long __functionAddress = Functions.vertex_decl_begin;
        JNI.invokePV(__functionAddress, _decl, _renderer);
    }

    public static void bgfx_vertex_decl_begin(BGFXVertexDecl _decl, int _renderer) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_decl_begin(_decl.address(), _renderer);
    }

    public static void nbgfx_vertex_decl_add(long _decl, int _attrib, byte _num, int _type, boolean _normalized, boolean _asInt) {
        long __functionAddress = Functions.vertex_decl_add;
        JNI.invokePV(__functionAddress, _decl, _attrib, _num, _type, _normalized, _asInt);
    }

    public static void bgfx_vertex_decl_add(BGFXVertexDecl _decl, int _attrib, int _num, int _type, boolean _normalized, boolean _asInt) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_decl_add(_decl.address(), _attrib, (byte)_num, _type, _normalized, _asInt);
    }

    public static void nbgfx_vertex_decl_skip(long _decl, byte _num) {
        long __functionAddress = Functions.vertex_decl_skip;
        JNI.invokePV(__functionAddress, _decl, _num);
    }

    public static void bgfx_vertex_decl_skip(BGFXVertexDecl _decl, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_decl_skip(_decl.address(), (byte)_num);
    }

    public static void nbgfx_vertex_decl_end(long _decl) {
        long __functionAddress = Functions.vertex_decl_end;
        JNI.invokePV(__functionAddress, _decl);
    }

    public static void bgfx_vertex_decl_end(BGFXVertexDecl _decl) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_decl_end(_decl.address());
    }

    public static void nbgfx_vertex_pack(long _input, boolean _inputNormalized, int _attr, long _decl, long _data, int _index) {
        long __functionAddress = Functions.vertex_pack;
        JNI.invokePPPV(__functionAddress, _input, _inputNormalized, _attr, _decl, _data, _index);
    }

    public static void bgfx_vertex_pack(FloatBuffer _input, boolean _inputNormalized, int _attr, BGFXVertexDecl _decl, ByteBuffer _data, int _index) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_input, 4);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_pack(MemoryUtil.memAddress(_input), _inputNormalized, _attr, _decl.address(), MemoryUtil.memAddress(_data), _index);
    }

    public static void nbgfx_vertex_unpack(long _output, int _attr, long _decl, long _data, int _index) {
        long __functionAddress = Functions.vertex_unpack;
        JNI.invokePPPV(__functionAddress, _output, _attr, _decl, _data, _index);
    }

    public static void bgfx_vertex_unpack(FloatBuffer _output, int _attr, BGFXVertexDecl _decl, ByteBuffer _data, int _index) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_output, 4);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_unpack(MemoryUtil.memAddress(_output), _attr, _decl.address(), MemoryUtil.memAddress(_data), _index);
    }

    public static void nbgfx_vertex_convert(long _destDecl, long _destData, long _srcDecl, long _srcData, int _num) {
        long __functionAddress = Functions.vertex_convert;
        JNI.invokePPPPV(__functionAddress, _destDecl, _destData, _srcDecl, _srcData, _num);
    }

    public static void bgfx_vertex_convert(BGFXVertexDecl _destDecl, ByteBuffer _destData, BGFXVertexDecl _srcDecl, ByteBuffer _srcData, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_vertex_convert(_destDecl.address(), MemoryUtil.memAddress(_destData), _srcDecl.address(), MemoryUtil.memAddress(_srcData), _num);
    }

    public static short nbgfx_weld_vertices(long _output, long _decl, long _data, short _num, float _epsilon) {
        long __functionAddress = Functions.weld_vertices;
        return JNI.invokePPPS(__functionAddress, _output, _decl, _data, _num, _epsilon);
    }

    public static short bgfx_weld_vertices(ShortBuffer _output, BGFXVertexDecl _decl, ByteBuffer _data, float _epsilon) {
        return org.lwjgl.bgfx.BGFX.nbgfx_weld_vertices(MemoryUtil.memAddress(_output), _decl.address(), MemoryUtil.memAddress(_data), (short)_output.remaining(), _epsilon);
    }

    public static int nbgfx_topology_convert(int _conversion, long _dst, int _dstSize, long _indices, int _numIndices, boolean _index32) {
        long __functionAddress = Functions.topology_convert;
        return JNI.invokePPI(__functionAddress, _conversion, _dst, _dstSize, _indices, _numIndices, _index32);
    }

    public static int bgfx_topology_convert(int _conversion, ByteBuffer _dst, ByteBuffer _indices, boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_topology_convert(_conversion, MemoryUtil.memAddressSafe(_dst), Checks.remainingSafe(_dst), MemoryUtil.memAddress(_indices), _indices.remaining() >> (_index32 ? 2 : 1), _index32);
    }

    public static int bgfx_topology_convert(int _conversion, ShortBuffer _dst, ShortBuffer _indices, boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_topology_convert(_conversion, MemoryUtil.memAddressSafe(_dst), Checks.remainingSafe(_dst) << 1, MemoryUtil.memAddress(_indices), _indices.remaining(), _index32);
    }

    public static int bgfx_topology_convert(int _conversion, IntBuffer _dst, IntBuffer _indices, boolean _index32) {
        return org.lwjgl.bgfx.BGFX.nbgfx_topology_convert(_conversion, MemoryUtil.memAddressSafe(_dst), Checks.remainingSafe(_dst) << 2, MemoryUtil.memAddress(_indices), _indices.remaining(), _index32);
    }

    public static void nbgfx_topology_sort_tri_list(int _sort, long _dst, int _dstSize, long _dir, long _pos, long _vertices, int _stride, long _indices, int _numIndices, boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        JNI.invokePPPPPV(__functionAddress, _sort, _dst, _dstSize, _dir, _pos, _vertices, _stride, _indices, _numIndices, _index32);
    }

    public static void bgfx_topology_sort_tri_list(int _sort, ByteBuffer _dst, FloatBuffer _dir, FloatBuffer _pos, ByteBuffer _vertices, int _stride, ByteBuffer _indices, boolean _index32) {
        int _numIndices = _indices.remaining() >> (_index32 ? 2 : 1);
        if (Checks.CHECKS) {
            Checks.check((Buffer)_dir, 3);
            Checks.check((Buffer)_pos, 3);
            Checks.check((Buffer)_vertices, _numIndices * _stride);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_topology_sort_tri_list(_sort, MemoryUtil.memAddress(_dst), _dst.remaining(), MemoryUtil.memAddress(_dir), MemoryUtil.memAddress(_pos), MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), _numIndices, _index32);
    }

    public static void bgfx_topology_sort_tri_list(int _sort, ShortBuffer _dst, FloatBuffer _dir, FloatBuffer _pos, ByteBuffer _vertices, int _stride, ShortBuffer _indices, boolean _index32) {
        int _numIndices = _indices.remaining();
        if (Checks.CHECKS) {
            Checks.check((Buffer)_dir, 3);
            Checks.check((Buffer)_pos, 3);
            Checks.check((Buffer)_vertices, _numIndices * _stride);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_topology_sort_tri_list(_sort, MemoryUtil.memAddress(_dst), _dst.remaining() << 1, MemoryUtil.memAddress(_dir), MemoryUtil.memAddress(_pos), MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), _numIndices, _index32);
    }

    public static void bgfx_topology_sort_tri_list(int _sort, IntBuffer _dst, FloatBuffer _dir, FloatBuffer _pos, ByteBuffer _vertices, int _stride, IntBuffer _indices, boolean _index32) {
        int _numIndices = _indices.remaining();
        if (Checks.CHECKS) {
            Checks.check((Buffer)_dir, 3);
            Checks.check((Buffer)_pos, 3);
            Checks.check((Buffer)_vertices, _numIndices * _stride);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_topology_sort_tri_list(_sort, MemoryUtil.memAddress(_dst), _dst.remaining() << 2, MemoryUtil.memAddress(_dir), MemoryUtil.memAddress(_pos), MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), _numIndices, _index32);
    }

    public static byte nbgfx_get_supported_renderers(byte _max, long _enum) {
        long __functionAddress = Functions.get_supported_renderers;
        return JNI.invokePB(__functionAddress, _max, _enum);
    }

    public static byte bgfx_get_supported_renderers(IntBuffer _enum) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_supported_renderers((byte)_enum.remaining(), MemoryUtil.memAddress(_enum));
    }

    public static long nbgfx_get_renderer_name(int _type) {
        long __functionAddress = Functions.get_renderer_name;
        return JNI.invokeP(__functionAddress, _type);
    }

    public static String bgfx_get_renderer_name(int _type) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_renderer_name(_type);
        return MemoryUtil.memASCII(__result);
    }

    public static boolean nbgfx_init(int _type, short _vendorId, short _deviceId, long _callback, long _allocator) {
        long __functionAddress = Functions.init;
        return JNI.invokePPZ(__functionAddress, _type, _vendorId, _deviceId, _callback, _allocator);
    }

    public static boolean bgfx_init(int _type, int _vendorId, int _deviceId, BGFXCallbackInterface _callback, BGFXAllocatorInterface _allocator) {
        return org.lwjgl.bgfx.BGFX.nbgfx_init(_type, (short)_vendorId, (short)_deviceId, MemoryUtil.memAddressSafe(_callback), MemoryUtil.memAddressSafe(_allocator));
    }

    public static void bgfx_shutdown() {
        long __functionAddress = Functions.shutdown;
        JNI.invokeV(__functionAddress);
    }

    public static void bgfx_reset(int _width, int _height, int _flags) {
        long __functionAddress = Functions.reset;
        JNI.invokeV(__functionAddress, _width, _height, _flags);
    }

    public static int bgfx_frame(boolean _capture) {
        long __functionAddress = Functions.frame;
        return JNI.invokeI(__functionAddress, _capture);
    }

    public static int bgfx_get_renderer_type() {
        long __functionAddress = Functions.get_renderer_type;
        return JNI.invokeI(__functionAddress);
    }

    public static long nbgfx_get_caps() {
        long __functionAddress = Functions.get_caps;
        return JNI.invokeP(__functionAddress);
    }

    public static BGFXCaps bgfx_get_caps() {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_caps();
        return BGFXCaps.create(__result);
    }

    public static long nbgfx_get_hmd() {
        long __functionAddress = Functions.get_hmd;
        return JNI.invokeP(__functionAddress);
    }

    public static BGFXHmd bgfx_get_hmd() {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_hmd();
        return BGFXHmd.create(__result);
    }

    public static long nbgfx_get_stats() {
        long __functionAddress = Functions.get_stats;
        return JNI.invokeP(__functionAddress);
    }

    public static BGFXStats bgfx_get_stats() {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_get_stats();
        return BGFXStats.create(__result);
    }

    public static long nbgfx_alloc(int _size) {
        long __functionAddress = Functions.alloc;
        return JNI.invokeP(__functionAddress, _size);
    }

    public static BGFXMemory bgfx_alloc(int _size) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_alloc(_size);
        return BGFXMemory.create(__result);
    }

    public static long nbgfx_copy(long _data, int _size) {
        long __functionAddress = Functions.copy;
        return JNI.invokePP(__functionAddress, _data, _size);
    }

    public static BGFXMemory bgfx_copy(ByteBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining());
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(ShortBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 1);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(IntBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(LongBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(FloatBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(DoubleBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(PointerBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_copy(MemoryUtil.memAddress(_data), _data.remaining() << Pointer.POINTER_SHIFT);
        return BGFXMemory.create(__result);
    }

    public static long nbgfx_make_ref(long _data, int _size) {
        long __functionAddress = Functions.make_ref;
        return JNI.invokePP(__functionAddress, _data, _size);
    }

    public static BGFXMemory bgfx_make_ref(ByteBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining());
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref(ShortBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 1);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref(IntBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref(LongBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref(FloatBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 2);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref(DoubleBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << 3);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref(PointerBuffer _data) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref(MemoryUtil.memAddress(_data), _data.remaining() << Pointer.POINTER_SHIFT);
        return BGFXMemory.create(__result);
    }

    public static long nbgfx_make_ref_release(long _data, int _size, long _releaseFn, long _userData) {
        long __functionAddress = Functions.make_ref_release;
        return JNI.invokePPPP(__functionAddress, _data, _size, _releaseFn, _userData);
    }

    public static BGFXMemory bgfx_make_ref_release(ByteBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining(), MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref_release(ShortBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 1, MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref_release(IntBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 2, MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref_release(LongBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 3, MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref_release(FloatBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 2, MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref_release(DoubleBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << 3, MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_make_ref_release(PointerBuffer _data, BGFXReleaseFunctionCallbackI _releaseFn, long _userData) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_make_ref_release(MemoryUtil.memAddress(_data), _data.remaining() << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(_releaseFn), _userData);
        return BGFXMemory.create(__result);
    }

    public static void bgfx_set_debug(int _debug) {
        long __functionAddress = Functions.set_debug;
        JNI.invokeV(__functionAddress, _debug);
    }

    public static void nbgfx_dbg_text_clear(byte _attr, boolean _small) {
        long __functionAddress = Functions.dbg_text_clear;
        JNI.invokeV(__functionAddress, _attr, _small);
    }

    public static void bgfx_dbg_text_clear(int _attr, boolean _small) {
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_clear((byte)_attr, _small);
    }

    public static void nbgfx_dbg_text_printf(short _x, short _y, byte _attr, long _format) {
        long __functionAddress = Functions.dbg_text_printf;
        JNI.invokePV(__functionAddress, _x, _y, _attr, _format);
    }

    public static void bgfx_dbg_text_printf(int _x, int _y, int _attr, ByteBuffer _format) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_format);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_printf((short)_x, (short)_y, (byte)_attr, MemoryUtil.memAddress(_format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_dbg_text_printf(int _x, int _y, int _attr, CharSequence _format) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer _formatEncoded = stack.ASCII(_format);
            org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_printf((short)_x, (short)_y, (byte)_attr, MemoryUtil.memAddress(_formatEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_dbg_text_vprintf(short _x, short _y, byte _attr, long _format, long _argList) {
        long __functionAddress = Functions.dbg_text_vprintf;
        if (Checks.CHECKS) {
            Checks.check(_argList);
        }
        JNI.invokePPV(__functionAddress, _x, _y, _attr, _format, _argList);
    }

    public static void bgfx_dbg_text_vprintf(int _x, int _y, int _attr, ByteBuffer _format, long _argList) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_format);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_vprintf((short)_x, (short)_y, (byte)_attr, MemoryUtil.memAddress(_format), _argList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_dbg_text_vprintf(int _x, int _y, int _attr, CharSequence _format, long _argList) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer _formatEncoded = stack.ASCII(_format);
            org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_vprintf((short)_x, (short)_y, (byte)_attr, MemoryUtil.memAddress(_formatEncoded), _argList);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_dbg_text_image(short _x, short _y, short _width, short _height, long _data, short _pitch) {
        long __functionAddress = Functions.dbg_text_image;
        JNI.invokePV(__functionAddress, _x, _y, _width, _height, _data, _pitch);
    }

    public static void bgfx_dbg_text_image(int _x, int _y, int _width, int _height, ByteBuffer _data, int _pitch) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_data, _height * _pitch);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_dbg_text_image((short)_x, (short)_y, (short)_width, (short)_height, MemoryUtil.memAddress(_data), (short)_pitch);
    }

    public static short nbgfx_create_index_buffer(long _mem, short _flags) {
        long __functionAddress = Functions.create_index_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(__functionAddress, _mem, _flags);
    }

    public static short bgfx_create_index_buffer(BGFXMemory _mem, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_index_buffer(_mem.address(), (short)_flags);
    }

    public static void bgfx_destroy_index_buffer(short _handle) {
        long __functionAddress = Functions.destroy_index_buffer;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short nbgfx_create_vertex_buffer(long _mem, long _decl, short _flags) {
        long __functionAddress = Functions.create_vertex_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePPS(__functionAddress, _mem, _decl, _flags);
    }

    public static short bgfx_create_vertex_buffer(BGFXMemory _mem, BGFXVertexDecl _decl, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_vertex_buffer(_mem.address(), _decl.address(), (short)_flags);
    }

    public static void bgfx_destroy_vertex_buffer(short _handle) {
        long __functionAddress = Functions.destroy_vertex_buffer;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short nbgfx_create_dynamic_index_buffer(int _num, short _flags) {
        long __functionAddress = Functions.create_dynamic_index_buffer;
        return JNI.invokeS(__functionAddress, _num, _flags);
    }

    public static short bgfx_create_dynamic_index_buffer(int _num, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_index_buffer(_num, (short)_flags);
    }

    public static short nbgfx_create_dynamic_index_buffer_mem(long _mem, short _flags) {
        long __functionAddress = Functions.create_dynamic_index_buffer_mem;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(__functionAddress, _mem, _flags);
    }

    public static short bgfx_create_dynamic_index_buffer_mem(BGFXMemory _mem, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_index_buffer_mem(_mem.address(), (short)_flags);
    }

    public static void nbgfx_update_dynamic_index_buffer(short _handle, int _startIndex, long _mem) {
        long __functionAddress = Functions.update_dynamic_index_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(__functionAddress, _handle, _startIndex, _mem);
    }

    public static void bgfx_update_dynamic_index_buffer(short _handle, int _startIndex, BGFXMemory _mem) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_dynamic_index_buffer(_handle, _startIndex, _mem.address());
    }

    public static void bgfx_destroy_dynamic_index_buffer(short _handle) {
        long __functionAddress = Functions.destroy_dynamic_index_buffer;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short nbgfx_create_dynamic_vertex_buffer(int _num, long _decl, short _flags) {
        long __functionAddress = Functions.create_dynamic_vertex_buffer;
        return JNI.invokePS(__functionAddress, _num, _decl, _flags);
    }

    public static short bgfx_create_dynamic_vertex_buffer(int _num, BGFXVertexDecl _decl, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_vertex_buffer(_num, _decl.address(), (short)_flags);
    }

    public static short nbgfx_create_dynamic_vertex_buffer_mem(long _mem, long _decl, short _flags) {
        long __functionAddress = Functions.create_dynamic_vertex_buffer_mem;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePPS(__functionAddress, _mem, _decl, _flags);
    }

    public static short bgfx_create_dynamic_vertex_buffer_mem(BGFXMemory _mem, BGFXVertexDecl _decl, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_dynamic_vertex_buffer_mem(_mem.address(), _decl.address(), (short)_flags);
    }

    public static void nbgfx_update_dynamic_vertex_buffer(short _handle, int _startVertex, long _mem) {
        long __functionAddress = Functions.update_dynamic_vertex_buffer;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(__functionAddress, _handle, _startVertex, _mem);
    }

    public static void bgfx_update_dynamic_vertex_buffer(short _handle, int _startVertex, BGFXMemory _mem) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_dynamic_vertex_buffer(_handle, _startVertex, _mem.address());
    }

    public static void bgfx_destroy_dynamic_vertex_buffer(short _handle) {
        long __functionAddress = Functions.destroy_dynamic_vertex_buffer;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static int bgfx_get_avail_transient_index_buffer(int _num) {
        long __functionAddress = Functions.get_avail_transient_index_buffer;
        return JNI.invokeI(__functionAddress, _num);
    }

    public static int nbgfx_get_avail_transient_vertex_buffer(int _num, long _decl) {
        long __functionAddress = Functions.get_avail_transient_vertex_buffer;
        return JNI.invokePI(__functionAddress, _num, _decl);
    }

    public static int bgfx_get_avail_transient_vertex_buffer(int _num, BGFXVertexDecl _decl) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_avail_transient_vertex_buffer(_num, _decl.address());
    }

    public static int nbgfx_get_avail_instance_data_buffer(int _num, short _stride) {
        long __functionAddress = Functions.get_avail_instance_data_buffer;
        return JNI.invokeI(__functionAddress, _num, _stride);
    }

    public static int bgfx_get_avail_instance_data_buffer(int _num, int _stride) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_avail_instance_data_buffer(_num, (short)_stride);
    }

    public static void nbgfx_alloc_transient_index_buffer(long _tib, int _num) {
        long __functionAddress = Functions.alloc_transient_index_buffer;
        JNI.invokePV(__functionAddress, _tib, _num);
    }

    public static void bgfx_alloc_transient_index_buffer(BGFXTransientIndexBuffer _tib, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_alloc_transient_index_buffer(_tib.address(), _num);
    }

    public static void nbgfx_alloc_transient_vertex_buffer(long _tvb, int _num, long _decl) {
        long __functionAddress = Functions.alloc_transient_vertex_buffer;
        JNI.invokePPV(__functionAddress, _tvb, _num, _decl);
    }

    public static void bgfx_alloc_transient_vertex_buffer(BGFXTransientVertexBuffer _tvb, int _num, BGFXVertexDecl _decl) {
        org.lwjgl.bgfx.BGFX.nbgfx_alloc_transient_vertex_buffer(_tvb.address(), _num, _decl.address());
    }

    public static boolean nbgfx_alloc_transient_buffers(long _tvb, long _decl, int _numVertices, long _tib, int _numIndices) {
        long __functionAddress = Functions.alloc_transient_buffers;
        return JNI.invokePPPZ(__functionAddress, _tvb, _decl, _numVertices, _tib, _numIndices);
    }

    public static boolean bgfx_alloc_transient_buffers(BGFXTransientVertexBuffer _tvb, BGFXVertexDecl _decl, int _numVertices, BGFXTransientIndexBuffer _tib, int _numIndices) {
        return org.lwjgl.bgfx.BGFX.nbgfx_alloc_transient_buffers(_tvb.address(), _decl.address(), _numVertices, _tib.address(), _numIndices);
    }

    public static long nbgfx_alloc_instance_data_buffer(int _num, short _stride) {
        long __functionAddress = Functions.alloc_instance_data_buffer;
        return JNI.invokeP(__functionAddress, _num, _stride);
    }

    public static BGFXInstanceDataBuffer bgfx_alloc_instance_data_buffer(int _num, int _stride) {
        long __result = org.lwjgl.bgfx.BGFX.nbgfx_alloc_instance_data_buffer(_num, (short)_stride);
        return BGFXInstanceDataBuffer.create(__result);
    }

    public static short bgfx_create_indirect_buffer(int _num) {
        long __functionAddress = Functions.create_indirect_buffer;
        return JNI.invokeS(__functionAddress, _num);
    }

    public static void bgfx_destroy_indirect_buffer(short _handle) {
        long __functionAddress = Functions.destroy_indirect_buffer;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short nbgfx_create_shader(long _mem) {
        long __functionAddress = Functions.create_shader;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(__functionAddress, _mem);
    }

    public static short bgfx_create_shader(BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_shader(_mem.address());
    }

    public static short nbgfx_get_shader_uniforms(short _handle, long _uniforms, short _max) {
        long __functionAddress = Functions.get_shader_uniforms;
        return JNI.invokePS(__functionAddress, _handle, _uniforms, _max);
    }

    public static short bgfx_get_shader_uniforms(short _handle, ShortBuffer _uniforms) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_shader_uniforms(_handle, MemoryUtil.memAddress(_uniforms), (short)_uniforms.remaining());
    }

    public static void bgfx_destroy_shader(short _handle) {
        long __functionAddress = Functions.destroy_shader;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short bgfx_create_program(short _vsh, short _fsh, boolean _destroyShaders) {
        long __functionAddress = Functions.create_program;
        return JNI.invokeS(__functionAddress, _vsh, _fsh, _destroyShaders);
    }

    public static short bgfx_create_compute_program(short _csh, boolean _destroyShaders) {
        long __functionAddress = Functions.create_compute_program;
        return JNI.invokeS(__functionAddress, _csh, _destroyShaders);
    }

    public static void bgfx_destroy_program(short _handle) {
        long __functionAddress = Functions.destroy_program;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static boolean nbgfx_is_texture_valid(short _depth, boolean _cubeMap, short _numLayers, int _format, int _flags) {
        long __functionAddress = Functions.is_texture_valid;
        return JNI.invokeZ(__functionAddress, _depth, _cubeMap, _numLayers, _format, _flags);
    }

    public static boolean bgfx_is_texture_valid(int _depth, boolean _cubeMap, int _numLayers, int _format, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_is_texture_valid((short)_depth, _cubeMap, (short)_numLayers, _format, _flags);
    }

    public static void nbgfx_calc_texture_size(long _info, short _width, short _height, short _depth, boolean _cubeMap, boolean _hasMips, short _numLayers, int _format) {
        long __functionAddress = Functions.calc_texture_size;
        JNI.invokePV(__functionAddress, _info, _width, _height, _depth, _cubeMap, _hasMips, _numLayers, _format);
    }

    public static void bgfx_calc_texture_size(BGFXTextureInfo _info, int _width, int _height, int _depth, boolean _cubeMap, boolean _hasMips, int _numLayers, int _format) {
        org.lwjgl.bgfx.BGFX.nbgfx_calc_texture_size(_info.address(), (short)_width, (short)_height, (short)_depth, _cubeMap, _hasMips, (short)_numLayers, _format);
    }

    public static short nbgfx_create_texture(long _mem, int _flags, byte _skip, long _info) {
        long __functionAddress = Functions.create_texture;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePPS(__functionAddress, _mem, _flags, _skip, _info);
    }

    public static short bgfx_create_texture(BGFXMemory _mem, int _flags, int _skip, BGFXTextureInfo _info) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture(_mem.address(), _flags, (byte)_skip, MemoryUtil.memAddressSafe(_info));
    }

    public static short nbgfx_create_texture_2d(short _width, short _height, boolean _hasMips, short _numLayers, int _format, int _flags, long _mem) {
        long __functionAddress = Functions.create_texture_2d;
        if (Checks.CHECKS && _mem != 0L) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(__functionAddress, _width, _height, _hasMips, _numLayers, _format, _flags, _mem);
    }

    public static short bgfx_create_texture_2d(int _width, int _height, boolean _hasMips, int _numLayers, int _format, int _flags, BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_2d((short)_width, (short)_height, _hasMips, (short)_numLayers, _format, _flags, MemoryUtil.memAddressSafe(_mem));
    }

    public static short nbgfx_create_texture_2d_scaled(int _ratio, boolean _hasMips, short _numLayers, int _format, int _flags) {
        long __functionAddress = Functions.create_texture_2d_scaled;
        return JNI.invokeS(__functionAddress, _ratio, _hasMips, _numLayers, _format, _flags);
    }

    public static short bgfx_create_texture_2d_scaled(int _ratio, boolean _hasMips, int _numLayers, int _format, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_2d_scaled(_ratio, _hasMips, (short)_numLayers, _format, _flags);
    }

    public static short nbgfx_create_texture_3d(short _width, short _height, short _depth, boolean _hasMips, int _format, int _flags, long _mem) {
        long __functionAddress = Functions.create_texture_3d;
        if (Checks.CHECKS && _mem != 0L) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(__functionAddress, _width, _height, _depth, _hasMips, _format, _flags, _mem);
    }

    public static short bgfx_create_texture_3d(int _width, int _height, int _depth, boolean _hasMips, int _format, int _flags, BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_3d((short)_width, (short)_height, (short)_depth, _hasMips, _format, _flags, MemoryUtil.memAddressSafe(_mem));
    }

    public static short nbgfx_create_texture_cube(short _size, boolean _hasMips, short _numLayers, int _format, int _flags, long _mem) {
        long __functionAddress = Functions.create_texture_cube;
        if (Checks.CHECKS && _mem != 0L) {
            BGFXMemory.validate(_mem);
        }
        return JNI.invokePS(__functionAddress, _size, _hasMips, _numLayers, _format, _flags, _mem);
    }

    public static short bgfx_create_texture_cube(int _size, boolean _hasMips, int _numLayers, int _format, int _flags, BGFXMemory _mem) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_texture_cube((short)_size, _hasMips, (short)_numLayers, _format, _flags, MemoryUtil.memAddressSafe(_mem));
    }

    public static void nbgfx_update_texture_2d(short _handle, short _layer, byte _mip, short _x, short _y, short _width, short _height, long _mem, short _pitch) {
        long __functionAddress = Functions.update_texture_2d;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(__functionAddress, _handle, _layer, _mip, _x, _y, _width, _height, _mem, _pitch);
    }

    public static void bgfx_update_texture_2d(short _handle, int _layer, int _mip, int _x, int _y, int _width, int _height, BGFXMemory _mem, int _pitch) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_texture_2d(_handle, (short)_layer, (byte)_mip, (short)_x, (short)_y, (short)_width, (short)_height, _mem.address(), (short)_pitch);
    }

    public static void nbgfx_update_texture_3d(short _handle, byte _mip, short _x, short _y, short _z, short _width, short _height, short _depth, long _mem) {
        long __functionAddress = Functions.update_texture_3d;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(__functionAddress, _handle, _mip, _x, _y, _z, _width, _height, _depth, _mem);
    }

    public static void bgfx_update_texture_3d(short _handle, int _mip, int _x, int _y, int _z, int _width, int _height, int _depth, BGFXMemory _mem) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_texture_3d(_handle, (byte)_mip, (short)_x, (short)_y, (short)_z, (short)_width, (short)_height, (short)_depth, _mem.address());
    }

    public static void nbgfx_update_texture_cube(short _handle, short _layer, byte _side, byte _mip, short _x, short _y, short _width, short _height, long _mem, short _pitch) {
        long __functionAddress = Functions.update_texture_cube;
        if (Checks.CHECKS) {
            BGFXMemory.validate(_mem);
        }
        JNI.invokePV(__functionAddress, _handle, _layer, _side, _mip, _x, _y, _width, _height, _mem, _pitch);
    }

    public static void bgfx_update_texture_cube(short _handle, int _layer, int _side, int _mip, int _x, int _y, int _width, int _height, BGFXMemory _mem, int _pitch) {
        org.lwjgl.bgfx.BGFX.nbgfx_update_texture_cube(_handle, (short)_layer, (byte)_side, (byte)_mip, (short)_x, (short)_y, (short)_width, (short)_height, _mem.address(), (short)_pitch);
    }

    public static int nbgfx_read_texture(short _handle, long _data, byte _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(__functionAddress, _handle, _data, _mip);
    }

    public static int bgfx_read_texture(short _handle, ByteBuffer _data, int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    public static int bgfx_read_texture(short _handle, ShortBuffer _data, int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    public static int bgfx_read_texture(short _handle, IntBuffer _data, int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    public static int bgfx_read_texture(short _handle, FloatBuffer _data, int _mip) {
        return org.lwjgl.bgfx.BGFX.nbgfx_read_texture(_handle, MemoryUtil.memAddress(_data), (byte)_mip);
    }

    public static void bgfx_destroy_texture(short _handle) {
        long __functionAddress = Functions.destroy_texture;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short nbgfx_create_frame_buffer(short _width, short _height, int _format, int _textureFlags) {
        long __functionAddress = Functions.create_frame_buffer;
        return JNI.invokeS(__functionAddress, _width, _height, _format, _textureFlags);
    }

    public static short bgfx_create_frame_buffer(int _width, int _height, int _format, int _textureFlags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer((short)_width, (short)_height, _format, _textureFlags);
    }

    public static short bgfx_create_frame_buffer_scaled(int _ratio, int _format, int _textureFlags) {
        long __functionAddress = Functions.create_frame_buffer_scaled;
        return JNI.invokeS(__functionAddress, _ratio, _format, _textureFlags);
    }

    public static short nbgfx_create_frame_buffer_from_handles(byte _num, long _handles, boolean _destroyTextures) {
        long __functionAddress = Functions.create_frame_buffer_from_handles;
        return JNI.invokePS(__functionAddress, _num, _handles, _destroyTextures);
    }

    public static short bgfx_create_frame_buffer_from_handles(ShortBuffer _handles, boolean _destroyTextures) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer_from_handles((byte)_handles.remaining(), MemoryUtil.memAddress(_handles), _destroyTextures);
    }

    public static short nbgfx_create_frame_buffer_from_attachment(byte _num, long _attachment, boolean _destroyTextures) {
        long __functionAddress = Functions.create_frame_buffer_from_attachment;
        return JNI.invokePS(__functionAddress, _num, _attachment, _destroyTextures);
    }

    public static short bgfx_create_frame_buffer_from_attachment(PointerBuffer _attachment, boolean _destroyTextures) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer_from_attachment((byte)_attachment.remaining(), MemoryUtil.memAddress(_attachment), _destroyTextures);
    }

    public static short nbgfx_create_frame_buffer_from_nwh(long _nwh, short _width, short _height, int _depthFormat) {
        long __functionAddress = Functions.create_frame_buffer_from_nwh;
        if (Checks.CHECKS) {
            Checks.check(_nwh);
        }
        return JNI.invokePS(__functionAddress, _nwh, _width, _height, _depthFormat);
    }

    public static short bgfx_create_frame_buffer_from_nwh(long _nwh, int _width, int _height, int _depthFormat) {
        return org.lwjgl.bgfx.BGFX.nbgfx_create_frame_buffer_from_nwh(_nwh, (short)_width, (short)_height, _depthFormat);
    }

    public static short nbgfx_get_texture(short _handle, byte _attachment) {
        long __functionAddress = Functions.get_texture;
        return JNI.invokeS(__functionAddress, _handle, _attachment);
    }

    public static short bgfx_get_texture(short _handle, int _attachment) {
        return org.lwjgl.bgfx.BGFX.nbgfx_get_texture(_handle, (byte)_attachment);
    }

    public static void bgfx_destroy_frame_buffer(short _handle) {
        long __functionAddress = Functions.destroy_frame_buffer;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short nbgfx_create_uniform(long _name, int _type, short _num) {
        long __functionAddress = Functions.create_uniform;
        return JNI.invokePS(__functionAddress, _name, _type, _num);
    }

    public static short bgfx_create_uniform(ByteBuffer _name, int _type, int _num) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_name);
        }
        return org.lwjgl.bgfx.BGFX.nbgfx_create_uniform(MemoryUtil.memAddress(_name), _type, (short)_num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short bgfx_create_uniform(CharSequence _name, int _type, int _num) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer _nameEncoded = stack.ASCII(_name);
            short s = org.lwjgl.bgfx.BGFX.nbgfx_create_uniform(MemoryUtil.memAddress(_nameEncoded), _type, (short)_num);
            return s;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_get_uniform_info(short _handle, long _info) {
        long __functionAddress = Functions.get_uniform_info;
        JNI.invokePV(__functionAddress, _handle, _info);
    }

    public static void bgfx_get_uniform_info(short _handle, BGFXUniformInfo _info) {
        org.lwjgl.bgfx.BGFX.nbgfx_get_uniform_info(_handle, _info.address());
    }

    public static void bgfx_destroy_uniform(short _handle) {
        long __functionAddress = Functions.destroy_uniform;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static short bgfx_create_occlusion_query() {
        long __functionAddress = Functions.create_occlusion_query;
        return JNI.invokeS(__functionAddress);
    }

    public static int nbgfx_get_result(short _handle, long _result) {
        long __functionAddress = Functions.get_result;
        return JNI.invokePI(__functionAddress, _handle, _result);
    }

    public static int bgfx_get_result(short _handle, IntBuffer _result) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_result, 1);
        }
        return org.lwjgl.bgfx.BGFX.nbgfx_get_result(_handle, MemoryUtil.memAddressSafe(_result));
    }

    public static void bgfx_destroy_occlusion_query(short _handle) {
        long __functionAddress = Functions.destroy_occlusion_query;
        JNI.invokeV(__functionAddress, _handle);
    }

    public static void nbgfx_set_palette_color(byte _index, long _rgba) {
        long __functionAddress = Functions.set_palette_color;
        JNI.invokePV(__functionAddress, _index, _rgba);
    }

    public static void bgfx_set_palette_color(int _index, FloatBuffer _rgba) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)_rgba, 4);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_palette_color((byte)_index, MemoryUtil.memAddress(_rgba));
    }

    public static void nbgfx_set_view_name(byte _id, long _name) {
        long __functionAddress = Functions.set_view_name;
        JNI.invokePV(__functionAddress, _id, _name);
    }

    public static void bgfx_set_view_name(int _id, ByteBuffer _name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_name);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_name((byte)_id, MemoryUtil.memAddress(_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_view_name(int _id, CharSequence _name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer _nameEncoded = stack.ASCII(_name);
            org.lwjgl.bgfx.BGFX.nbgfx_set_view_name((byte)_id, MemoryUtil.memAddress(_nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nbgfx_set_view_rect(byte _id, short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.set_view_rect;
        JNI.invokeV(__functionAddress, _id, _x, _y, _width, _height);
    }

    public static void bgfx_set_view_rect(int _id, int _x, int _y, int _width, int _height) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_rect((byte)_id, (short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_set_view_rect_auto(byte _id, short _x, short _y, int _ratio) {
        long __functionAddress = Functions.set_view_rect_auto;
        JNI.invokeV(__functionAddress, _id, _x, _y, _ratio);
    }

    public static void bgfx_set_view_rect_auto(int _id, int _x, int _y, int _ratio) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_rect_auto((byte)_id, (short)_x, (short)_y, _ratio);
    }

    public static void nbgfx_set_view_scissor(byte _id, short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.set_view_scissor;
        JNI.invokeV(__functionAddress, _id, _x, _y, _width, _height);
    }

    public static void bgfx_set_view_scissor(int _id, int _x, int _y, int _width, int _height) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_scissor((byte)_id, (short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_set_view_clear(byte _id, short _flags, int _rgba, float _depth, byte _stencil) {
        long __functionAddress = Functions.set_view_clear;
        JNI.invokeV(__functionAddress, _id, _flags, _rgba, _depth, _stencil);
    }

    public static void bgfx_set_view_clear(int _id, int _flags, int _rgba, float _depth, int _stencil) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_clear((byte)_id, (short)_flags, _rgba, _depth, (byte)_stencil);
    }

    public static void nbgfx_set_view_clear_mrt(byte _id, short _flags, float _depth, byte _stencil, byte _0, byte _1, byte _2, byte _3, byte _4, byte _5, byte _6, byte _7) {
        long __functionAddress = Functions.set_view_clear_mrt;
        JNI.invokeV(__functionAddress, _id, _flags, _depth, _stencil, _0, _1, _2, _3, _4, _5, _6, _7);
    }

    public static void bgfx_set_view_clear_mrt(int _id, int _flags, float _depth, int _stencil, byte _0, byte _1, byte _2, byte _3, byte _4, byte _5, byte _6, byte _7) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_clear_mrt((byte)_id, (short)_flags, _depth, (byte)_stencil, _0, _1, _2, _3, _4, _5, _6, _7);
    }

    public static void nbgfx_set_view_seq(byte _id, boolean _enabled) {
        long __functionAddress = Functions.set_view_seq;
        JNI.invokeV(__functionAddress, _id, _enabled);
    }

    public static void bgfx_set_view_seq(int _id, boolean _enabled) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_seq((byte)_id, _enabled);
    }

    public static void nbgfx_set_view_frame_buffer(byte _id, short _handle) {
        long __functionAddress = Functions.set_view_frame_buffer;
        JNI.invokeV(__functionAddress, _id, _handle);
    }

    public static void bgfx_set_view_frame_buffer(int _id, short _handle) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_frame_buffer((byte)_id, _handle);
    }

    public static void nbgfx_set_view_transform(byte _id, long _view, long _proj) {
        long __functionAddress = Functions.set_view_transform;
        JNI.invokePPV(__functionAddress, _id, _view, _proj);
    }

    public static void bgfx_set_view_transform(int _id, ByteBuffer _view, ByteBuffer _proj) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_view, 64);
            Checks.checkSafe((Buffer)_proj, 64);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_transform((byte)_id, MemoryUtil.memAddressSafe(_view), MemoryUtil.memAddressSafe(_proj));
    }

    public static void bgfx_set_view_transform(int _id, FloatBuffer _view, FloatBuffer _proj) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_view, 16);
            Checks.checkSafe((Buffer)_proj, 16);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_transform((byte)_id, MemoryUtil.memAddressSafe(_view), MemoryUtil.memAddressSafe(_proj));
    }

    public static void nbgfx_set_view_transform_stereo(byte _id, long _view, long _projL, byte _flags, long _projR) {
        long __functionAddress = Functions.set_view_transform_stereo;
        JNI.invokePPPV(__functionAddress, _id, _view, _projL, _flags, _projR);
    }

    public static void bgfx_set_view_transform_stereo(int _id, ByteBuffer _view, ByteBuffer _projL, int _flags, ByteBuffer _projR) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_view, 64);
            Checks.checkSafe((Buffer)_projL, 64);
            Checks.checkSafe((Buffer)_projR, 64);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_transform_stereo((byte)_id, MemoryUtil.memAddressSafe(_view), MemoryUtil.memAddressSafe(_projL), (byte)_flags, MemoryUtil.memAddressSafe(_projR));
    }

    public static void bgfx_set_view_transform_stereo(int _id, FloatBuffer _view, FloatBuffer _projL, int _flags, FloatBuffer _projR) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_view, 16);
            Checks.checkSafe((Buffer)_projL, 16);
            Checks.checkSafe((Buffer)_projR, 16);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_transform_stereo((byte)_id, MemoryUtil.memAddressSafe(_view), MemoryUtil.memAddressSafe(_projL), (byte)_flags, MemoryUtil.memAddressSafe(_projR));
    }

    public static void nbgfx_set_view_order(byte _id, byte _num, long _order) {
        long __functionAddress = Functions.set_view_order;
        JNI.invokePV(__functionAddress, _id, _num, _order);
    }

    public static void bgfx_set_view_order(int _id, int _num, ByteBuffer _order) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)_order, _num);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_view_order((byte)_id, (byte)_num, MemoryUtil.memAddressSafe(_order));
    }

    public static void nbgfx_reset_view(byte _id) {
        long __functionAddress = Functions.reset_view;
        JNI.invokeV(__functionAddress, _id);
    }

    public static void bgfx_reset_view(int _id) {
        org.lwjgl.bgfx.BGFX.nbgfx_reset_view((byte)_id);
    }

    public static void nbgfx_set_marker(long _marker) {
        long __functionAddress = Functions.set_marker;
        JNI.invokePV(__functionAddress, _marker);
    }

    public static void bgfx_set_marker(ByteBuffer _marker) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_marker);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_set_marker(MemoryUtil.memAddress(_marker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_set_marker(CharSequence _marker) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer _markerEncoded = stack.ASCII(_marker);
            org.lwjgl.bgfx.BGFX.nbgfx_set_marker(MemoryUtil.memAddress(_markerEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void bgfx_set_state(long _state, int _rgba) {
        long __functionAddress = Functions.set_state;
        JNI.invokeJV(__functionAddress, _state, _rgba);
    }

    public static void bgfx_set_condition(short _handle, boolean _visible) {
        long __functionAddress = Functions.set_condition;
        JNI.invokeV(__functionAddress, _handle, _visible);
    }

    public static void bgfx_set_stencil(int _fstencil, int _bstencil) {
        long __functionAddress = Functions.set_stencil;
        JNI.invokeV(__functionAddress, _fstencil, _bstencil);
    }

    public static short nbgfx_set_scissor(short _x, short _y, short _width, short _height) {
        long __functionAddress = Functions.set_scissor;
        return JNI.invokeS(__functionAddress, _x, _y, _width, _height);
    }

    public static short bgfx_set_scissor(int _x, int _y, int _width, int _height) {
        return org.lwjgl.bgfx.BGFX.nbgfx_set_scissor((short)_x, (short)_y, (short)_width, (short)_height);
    }

    public static void nbgfx_set_scissor_cached(short _cache) {
        long __functionAddress = Functions.set_scissor_cached;
        JNI.invokeV(__functionAddress, _cache);
    }

    public static void bgfx_set_scissor_cached(int _cache) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_scissor_cached((short)_cache);
    }

    public static int nbgfx_set_transform(long _mtx, short _num) {
        long __functionAddress = Functions.set_transform;
        return JNI.invokePI(__functionAddress, _mtx, _num);
    }

    public static int bgfx_set_transform(ByteBuffer _mtx) {
        return org.lwjgl.bgfx.BGFX.nbgfx_set_transform(MemoryUtil.memAddress(_mtx), (short)(_mtx.remaining() >> 6));
    }

    public static int bgfx_set_transform(FloatBuffer _mtx) {
        return org.lwjgl.bgfx.BGFX.nbgfx_set_transform(MemoryUtil.memAddress(_mtx), (short)(_mtx.remaining() >> 4));
    }

    public static int nbgfx_alloc_transform(long _transform, short _num) {
        long __functionAddress = Functions.alloc_transform;
        return JNI.invokePI(__functionAddress, _transform, _num);
    }

    public static int bgfx_alloc_transform(BGFXTransform _transform, int _num) {
        return org.lwjgl.bgfx.BGFX.nbgfx_alloc_transform(_transform.address(), (short)_num);
    }

    public static void nbgfx_set_transform_cached(int _cache, short _num) {
        long __functionAddress = Functions.set_transform_cached;
        JNI.invokeV(__functionAddress, _cache, _num);
    }

    public static void bgfx_set_transform_cached(int _cache, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transform_cached(_cache, (short)_num);
    }

    public static void nbgfx_set_uniform(short _handle, long _value, short _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(__functionAddress, _handle, _value, _num);
    }

    public static void bgfx_set_uniform(short _handle, ByteBuffer _value, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, ShortBuffer _value, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, IntBuffer _value, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, LongBuffer _value, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, FloatBuffer _value, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, DoubleBuffer _value, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_uniform(_handle, MemoryUtil.memAddress(_value), (short)_num);
    }

    public static void bgfx_set_index_buffer(short _handle, int _firstIndex, int _numIndices) {
        long __functionAddress = Functions.set_index_buffer;
        JNI.invokeV(__functionAddress, _handle, _firstIndex, _numIndices);
    }

    public static void bgfx_set_dynamic_index_buffer(short _handle, int _firstIndex, int _numIndices) {
        long __functionAddress = Functions.set_dynamic_index_buffer;
        JNI.invokeV(__functionAddress, _handle, _firstIndex, _numIndices);
    }

    public static void nbgfx_set_transient_index_buffer(long _tib, int _firstIndex, int _numIndices) {
        long __functionAddress = Functions.set_transient_index_buffer;
        if (Checks.CHECKS) {
            BGFXTransientIndexBuffer.validate(_tib);
        }
        JNI.invokePV(__functionAddress, _tib, _firstIndex, _numIndices);
    }

    public static void bgfx_set_transient_index_buffer(BGFXTransientIndexBuffer _tib, int _firstIndex, int _numIndices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transient_index_buffer(_tib.address(), _firstIndex, _numIndices);
    }

    public static void nbgfx_set_vertex_buffer(byte _stream, short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_vertex_buffer;
        JNI.invokeV(__functionAddress, _stream, _handle, _startVertex, _numVertices);
    }

    public static void bgfx_set_vertex_buffer(int _stream, short _handle, int _startVertex, int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_vertex_buffer((byte)_stream, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_set_dynamic_vertex_buffer(byte _stream, short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_dynamic_vertex_buffer;
        JNI.invokeV(__functionAddress, _stream, _handle, _startVertex, _numVertices);
    }

    public static void bgfx_set_dynamic_vertex_buffer(int _stream, short _handle, int _startVertex, int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_dynamic_vertex_buffer((byte)_stream, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_set_transient_vertex_buffer(byte _stream, long _tvb, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_transient_vertex_buffer;
        if (Checks.CHECKS) {
            BGFXTransientVertexBuffer.validate(_tvb);
        }
        JNI.invokePV(__functionAddress, _stream, _tvb, _startVertex, _numVertices);
    }

    public static void bgfx_set_transient_vertex_buffer(int _stream, BGFXTransientVertexBuffer _tvb, int _startVertex, int _numVertices) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_transient_vertex_buffer((byte)_stream, _tvb.address(), _startVertex, _numVertices);
    }

    public static void nbgfx_set_instance_data_buffer(long _idb, int _num) {
        long __functionAddress = Functions.set_instance_data_buffer;
        if (Checks.CHECKS) {
            BGFXInstanceDataBuffer.validate(_idb);
        }
        JNI.invokePV(__functionAddress, _idb, _num);
    }

    public static void bgfx_set_instance_data_buffer(BGFXInstanceDataBuffer _idb, int _num) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_instance_data_buffer(_idb.address(), _num);
    }

    public static void bgfx_set_instance_data_from_vertex_buffer(short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_instance_data_from_vertex_buffer;
        JNI.invokeV(__functionAddress, _handle, _startVertex, _numVertices);
    }

    public static void bgfx_set_instance_data_from_dynamic_vertex_buffer(short _handle, int _startVertex, int _numVertices) {
        long __functionAddress = Functions.set_instance_data_from_dynamic_vertex_buffer;
        JNI.invokeV(__functionAddress, _handle, _startVertex, _numVertices);
    }

    public static void nbgfx_set_texture(byte _stage, short _sampler, short _handle, int _flags) {
        long __functionAddress = Functions.set_texture;
        JNI.invokeV(__functionAddress, _stage, _sampler, _handle, _flags);
    }

    public static void bgfx_set_texture(int _stage, short _sampler, short _handle, int _flags) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_texture((byte)_stage, _sampler, _handle, _flags);
    }

    public static int nbgfx_touch(byte _id) {
        long __functionAddress = Functions.touch;
        return JNI.invokeI(__functionAddress, _id);
    }

    public static int bgfx_touch(int _id) {
        return org.lwjgl.bgfx.BGFX.nbgfx_touch((byte)_id);
    }

    public static int nbgfx_submit(byte _id, short _handle, int _depth, boolean _preserveState) {
        long __functionAddress = Functions.submit;
        return JNI.invokeI(__functionAddress, _id, _handle, _depth, _preserveState);
    }

    public static int bgfx_submit(int _id, short _handle, int _depth, boolean _preserveState) {
        return org.lwjgl.bgfx.BGFX.nbgfx_submit((byte)_id, _handle, _depth, _preserveState);
    }

    public static int nbgfx_submit_occlusion_query(byte _id, short _program, short _occlusionQuery, int _depth, boolean _preserveState) {
        long __functionAddress = Functions.submit_occlusion_query;
        return JNI.invokeI(__functionAddress, _id, _program, _occlusionQuery, _depth, _preserveState);
    }

    public static int bgfx_submit_occlusion_query(int _id, short _program, short _occlusionQuery, int _depth, boolean _preserveState) {
        return org.lwjgl.bgfx.BGFX.nbgfx_submit_occlusion_query((byte)_id, _program, _occlusionQuery, _depth, _preserveState);
    }

    public static int nbgfx_submit_indirect(byte _id, short _handle, short _indirectHandle, short _start, short _num, int _depth, boolean _preserveState) {
        long __functionAddress = Functions.submit_indirect;
        return JNI.invokeI(__functionAddress, _id, _handle, _indirectHandle, _start, _num, _depth, _preserveState);
    }

    public static int bgfx_submit_indirect(int _id, short _handle, short _indirectHandle, int _start, int _num, int _depth, boolean _preserveState) {
        return org.lwjgl.bgfx.BGFX.nbgfx_submit_indirect((byte)_id, _handle, _indirectHandle, (short)_start, (short)_num, _depth, _preserveState);
    }

    public static void nbgfx_set_image(byte _stage, short _sampler, short _handle, byte _mip, int _access, int _format) {
        long __functionAddress = Functions.set_image;
        JNI.invokeV(__functionAddress, _stage, _sampler, _handle, _mip, _access, _format);
    }

    public static void bgfx_set_image(int _stage, short _sampler, short _handle, int _mip, int _access, int _format) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_image((byte)_stage, _sampler, _handle, (byte)_mip, _access, _format);
    }

    public static void nbgfx_set_compute_index_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_index_buffer;
        JNI.invokeV(__functionAddress, _stage, _handle, _access);
    }

    public static void bgfx_set_compute_index_buffer(int _stage, short _handle, int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_index_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_vertex_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_vertex_buffer;
        JNI.invokeV(__functionAddress, _stage, _handle, _access);
    }

    public static void bgfx_set_compute_vertex_buffer(int _stage, short _handle, int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_vertex_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_dynamic_index_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_dynamic_index_buffer;
        JNI.invokeV(__functionAddress, _stage, _handle, _access);
    }

    public static void bgfx_set_compute_dynamic_index_buffer(int _stage, short _handle, int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_dynamic_index_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_dynamic_vertex_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_dynamic_vertex_buffer;
        JNI.invokeV(__functionAddress, _stage, _handle, _access);
    }

    public static void bgfx_set_compute_dynamic_vertex_buffer(int _stage, short _handle, int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_dynamic_vertex_buffer((byte)_stage, _handle, _access);
    }

    public static void nbgfx_set_compute_indirect_buffer(byte _stage, short _handle, int _access) {
        long __functionAddress = Functions.set_compute_indirect_buffer;
        JNI.invokeV(__functionAddress, _stage, _handle, _access);
    }

    public static void bgfx_set_compute_indirect_buffer(int _stage, short _handle, int _access) {
        org.lwjgl.bgfx.BGFX.nbgfx_set_compute_indirect_buffer((byte)_stage, _handle, _access);
    }

    public static int nbgfx_dispatch(byte _id, short _handle, short _numX, short _numY, short _numZ, byte _flags) {
        long __functionAddress = Functions.dispatch;
        return JNI.invokeI(__functionAddress, _id, _handle, _numX, _numY, _numZ, _flags);
    }

    public static int bgfx_dispatch(int _id, short _handle, int _numX, int _numY, int _numZ, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_dispatch((byte)_id, _handle, (short)_numX, (short)_numY, (short)_numZ, (byte)_flags);
    }

    public static int nbgfx_dispatch_indirect(byte _id, short _handle, short _indirectHandle, short _start, short _num, byte _flags) {
        long __functionAddress = Functions.dispatch_indirect;
        return JNI.invokeI(__functionAddress, _id, _handle, _indirectHandle, _start, _num, _flags);
    }

    public static int bgfx_dispatch_indirect(int _id, short _handle, short _indirectHandle, int _start, int _num, int _flags) {
        return org.lwjgl.bgfx.BGFX.nbgfx_dispatch_indirect((byte)_id, _handle, _indirectHandle, (short)_start, (short)_num, (byte)_flags);
    }

    public static void bgfx_discard() {
        long __functionAddress = Functions.discard;
        JNI.invokeV(__functionAddress);
    }

    public static void nbgfx_blit(byte _id, short _dst, byte _dstMip, short _dstX, short _dstY, short _dstZ, short _src, byte _srcMip, short _srcX, short _srcY, short _srcZ, short _width, short _height, short _depth) {
        long __functionAddress = Functions.blit;
        JNI.invokeV(__functionAddress, _id, _dst, _dstMip, _dstX, _dstY, _dstZ, _src, _srcMip, _srcX, _srcY, _srcZ, _width, _height, _depth);
    }

    public static void bgfx_blit(int _id, short _dst, int _dstMip, int _dstX, int _dstY, int _dstZ, short _src, int _srcMip, int _srcX, int _srcY, int _srcZ, int _width, int _height, int _depth) {
        org.lwjgl.bgfx.BGFX.nbgfx_blit((byte)_id, _dst, (byte)_dstMip, (short)_dstX, (short)_dstY, (short)_dstZ, _src, (byte)_srcMip, (short)_srcX, (short)_srcY, (short)_srcZ, (short)_width, (short)_height, (short)_depth);
    }

    public static void nbgfx_request_screen_shot(short _handle, long _filePath) {
        long __functionAddress = Functions.request_screen_shot;
        JNI.invokePV(__functionAddress, _handle, _filePath);
    }

    public static void bgfx_request_screen_shot(short _handle, ByteBuffer _filePath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(_filePath);
        }
        org.lwjgl.bgfx.BGFX.nbgfx_request_screen_shot(_handle, MemoryUtil.memAddress(_filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bgfx_request_screen_shot(short _handle, CharSequence _filePath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer _filePathEncoded = stack.ASCII(_filePath);
            org.lwjgl.bgfx.BGFX.nbgfx_request_screen_shot(_handle, MemoryUtil.memAddress(_filePathEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long BGFX_STATE_ALPHA_REF(long _ref) {
        return _ref << 40 & 0xFF0000000000L;
    }

    public static long BGFX_STATE_POINT_SIZE(long _size) {
        return _size << 52 & 0xF0000000000000L;
    }

    public static long BGFX_STATE_BLEND_FUNC_SEPARATE(long _srcRGB, long _dstRGB, long _srcA, long _dstA) {
        return _srcRGB | _dstRGB << 4 | (_srcA | _dstA << 4) << 8;
    }

    public static long BGFX_STATE_BLEND_EQUATION_SEPARATE(long _rgb, long _a) {
        return _rgb | _a << 3;
    }

    public static long BGFX_STATE_BLEND_FUNC(long _src, long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_SEPARATE(_src, _dst, _src, _dst);
    }

    public static long BGFX_STATE_BLEND_EQUATION(long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_EQUATION_SEPARATE(_equation, _equation);
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_x(long _src, long _dst) {
        return _src >> 12 | _dst >> 12 << 4;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_xE(long _src, long _dst, long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) | _equation >> 28 << 8;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_1(long _src, long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 0;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_2(long _src, long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 11;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_3(long _src, long _dst) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_x(_src, _dst) << 22;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_1E(long _src, long _dst, long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 0;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_2E(long _src, long _dst, long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 11;
    }

    public static long BGFX_STATE_BLEND_FUNC_RT_3E(long _src, long _dst, long _equation) {
        return org.lwjgl.bgfx.BGFX.BGFX_STATE_BLEND_FUNC_RT_xE(_src, _dst, _equation) << 22;
    }

    public static int BGFX_STENCIL_FUNC_REF(int _ref) {
        return _ref << 0 & 0xFF;
    }

    public static int BGFX_STENCIL_FUNC_RMASK(int _mask) {
        return _mask << 8 & 0xFF00;
    }

    public static int BGFX_TEXTURE_BORDER_COLOR(int _index) {
        return _index << 24 & 0xF000000;
    }

    public static void bgfx_vertex_pack(float[] _input, boolean _inputNormalized, int _attr, BGFXVertexDecl _decl, ByteBuffer _data, int _index) {
        long __functionAddress = Functions.vertex_pack;
        if (Checks.CHECKS) {
            Checks.check(_input, 4);
        }
        JNI.invokePPPV(__functionAddress, _input, _inputNormalized, _attr, _decl.address(), MemoryUtil.memAddress(_data), _index);
    }

    public static void bgfx_vertex_unpack(float[] _output, int _attr, BGFXVertexDecl _decl, ByteBuffer _data, int _index) {
        long __functionAddress = Functions.vertex_unpack;
        if (Checks.CHECKS) {
            Checks.check(_output, 4);
        }
        JNI.invokePPPV(__functionAddress, _output, _attr, _decl.address(), MemoryUtil.memAddress(_data), _index);
    }

    public static short bgfx_weld_vertices(short[] _output, BGFXVertexDecl _decl, ByteBuffer _data, float _epsilon) {
        long __functionAddress = Functions.weld_vertices;
        return JNI.invokePPPS(__functionAddress, _output, _decl.address(), MemoryUtil.memAddress(_data), (short)_output.length, _epsilon);
    }

    public static int bgfx_topology_convert(int _conversion, short[] _dst, short[] _indices, boolean _index32) {
        long __functionAddress = Functions.topology_convert;
        return JNI.invokePPI(__functionAddress, _conversion, _dst, Checks.lengthSafe(_dst) << 1, _indices, _indices.length, _index32);
    }

    public static int bgfx_topology_convert(int _conversion, int[] _dst, int[] _indices, boolean _index32) {
        long __functionAddress = Functions.topology_convert;
        return JNI.invokePPI(__functionAddress, _conversion, _dst, Checks.lengthSafe(_dst) << 2, _indices, _indices.length, _index32);
    }

    public static void bgfx_topology_sort_tri_list(int _sort, ByteBuffer _dst, float[] _dir, float[] _pos, ByteBuffer _vertices, int _stride, ByteBuffer _indices, boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        int _numIndices = _indices.remaining() >> (_index32 ? 2 : 1);
        if (Checks.CHECKS) {
            Checks.check(_dir, 3);
            Checks.check(_pos, 3);
            Checks.check((Buffer)_vertices, _numIndices * _stride);
        }
        JNI.invokePPPPPV(__functionAddress, _sort, MemoryUtil.memAddress(_dst), _dst.remaining(), _dir, _pos, MemoryUtil.memAddress(_vertices), _stride, MemoryUtil.memAddress(_indices), _numIndices, _index32);
    }

    public static void bgfx_topology_sort_tri_list(int _sort, short[] _dst, float[] _dir, float[] _pos, ByteBuffer _vertices, int _stride, short[] _indices, boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        int _numIndices = _indices.length;
        if (Checks.CHECKS) {
            Checks.check(_dir, 3);
            Checks.check(_pos, 3);
            Checks.check((Buffer)_vertices, _numIndices * _stride);
        }
        JNI.invokePPPPPV(__functionAddress, _sort, _dst, _dst.length << 1, _dir, _pos, MemoryUtil.memAddress(_vertices), _stride, _indices, _numIndices, _index32);
    }

    public static void bgfx_topology_sort_tri_list(int _sort, int[] _dst, float[] _dir, float[] _pos, ByteBuffer _vertices, int _stride, int[] _indices, boolean _index32) {
        long __functionAddress = Functions.topology_sort_tri_list;
        int _numIndices = _indices.length;
        if (Checks.CHECKS) {
            Checks.check(_dir, 3);
            Checks.check(_pos, 3);
            Checks.check((Buffer)_vertices, _numIndices * _stride);
        }
        JNI.invokePPPPPV(__functionAddress, _sort, _dst, _dst.length << 2, _dir, _pos, MemoryUtil.memAddress(_vertices), _stride, _indices, _numIndices, _index32);
    }

    public static byte bgfx_get_supported_renderers(int[] _enum) {
        long __functionAddress = Functions.get_supported_renderers;
        return JNI.invokePB(__functionAddress, (byte)_enum.length, _enum);
    }

    public static BGFXMemory bgfx_copy(short[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(__functionAddress, _data, _data.length << 1);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(int[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(__functionAddress, _data, _data.length << 2);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(long[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(__functionAddress, _data, _data.length << 3);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(float[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(__functionAddress, _data, _data.length << 2);
        return BGFXMemory.create(__result);
    }

    public static BGFXMemory bgfx_copy(double[] _data) {
        long __functionAddress = Functions.copy;
        long __result = JNI.invokePP(__functionAddress, _data, _data.length << 3);
        return BGFXMemory.create(__result);
    }

    public static short bgfx_get_shader_uniforms(short _handle, short[] _uniforms) {
        long __functionAddress = Functions.get_shader_uniforms;
        return JNI.invokePS(__functionAddress, _handle, _uniforms, (short)_uniforms.length);
    }

    public static int bgfx_read_texture(short _handle, short[] _data, int _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(__functionAddress, _handle, _data, (byte)_mip);
    }

    public static int bgfx_read_texture(short _handle, int[] _data, int _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(__functionAddress, _handle, _data, (byte)_mip);
    }

    public static int bgfx_read_texture(short _handle, float[] _data, int _mip) {
        long __functionAddress = Functions.read_texture;
        return JNI.invokePI(__functionAddress, _handle, _data, (byte)_mip);
    }

    public static short bgfx_create_frame_buffer_from_handles(short[] _handles, boolean _destroyTextures) {
        long __functionAddress = Functions.create_frame_buffer_from_handles;
        return JNI.invokePS(__functionAddress, (byte)_handles.length, _handles, _destroyTextures);
    }

    public static int bgfx_get_result(short _handle, int[] _result) {
        long __functionAddress = Functions.get_result;
        if (Checks.CHECKS) {
            Checks.checkSafe(_result, 1);
        }
        return JNI.invokePI(__functionAddress, _handle, _result);
    }

    public static void bgfx_set_palette_color(int _index, float[] _rgba) {
        long __functionAddress = Functions.set_palette_color;
        if (Checks.CHECKS) {
            Checks.check(_rgba, 4);
        }
        JNI.invokePV(__functionAddress, (byte)_index, _rgba);
    }

    public static void bgfx_set_view_transform(int _id, float[] _view, float[] _proj) {
        long __functionAddress = Functions.set_view_transform;
        if (Checks.CHECKS) {
            Checks.checkSafe(_view, 16);
            Checks.checkSafe(_proj, 16);
        }
        JNI.invokePPV(__functionAddress, (byte)_id, _view, _proj);
    }

    public static void bgfx_set_view_transform_stereo(int _id, float[] _view, float[] _projL, int _flags, float[] _projR) {
        long __functionAddress = Functions.set_view_transform_stereo;
        if (Checks.CHECKS) {
            Checks.checkSafe(_view, 16);
            Checks.checkSafe(_projL, 16);
            Checks.checkSafe(_projR, 16);
        }
        JNI.invokePPPV(__functionAddress, (byte)_id, _view, _projL, (byte)_flags, _projR);
    }

    public static int bgfx_set_transform(float[] _mtx) {
        long __functionAddress = Functions.set_transform;
        return JNI.invokePI(__functionAddress, _mtx, (short)(_mtx.length >> 4));
    }

    public static void bgfx_set_uniform(short _handle, short[] _value, int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(__functionAddress, _handle, _value, (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, int[] _value, int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(__functionAddress, _handle, _value, (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, long[] _value, int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(__functionAddress, _handle, _value, (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, float[] _value, int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(__functionAddress, _handle, _value, (short)_num);
    }

    public static void bgfx_set_uniform(short _handle, double[] _value, int _num) {
        long __functionAddress = Functions.set_uniform;
        JNI.invokePV(__functionAddress, _handle, _value, (short)_num);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return BGFX;
    }

    public static final class Functions {
        public static final long vertex_decl_begin = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_decl_begin");
        public static final long vertex_decl_add = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_decl_add");
        public static final long vertex_decl_skip = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_decl_skip");
        public static final long vertex_decl_end = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_decl_end");
        public static final long vertex_pack = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_pack");
        public static final long vertex_unpack = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_unpack");
        public static final long vertex_convert = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_vertex_convert");
        public static final long weld_vertices = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_weld_vertices");
        public static final long topology_convert = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_topology_convert");
        public static final long topology_sort_tri_list = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_topology_sort_tri_list");
        public static final long get_supported_renderers = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_supported_renderers");
        public static final long get_renderer_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_renderer_name");
        public static final long init = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_init");
        public static final long shutdown = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_shutdown");
        public static final long reset = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_reset");
        public static final long frame = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_frame");
        public static final long get_renderer_type = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_renderer_type");
        public static final long get_caps = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_caps");
        public static final long get_hmd = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_hmd");
        public static final long get_stats = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_stats");
        public static final long alloc = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc");
        public static final long copy = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_copy");
        public static final long make_ref = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_make_ref");
        public static final long make_ref_release = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_make_ref_release");
        public static final long set_debug = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_debug");
        public static final long dbg_text_clear = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_clear");
        public static final long dbg_text_printf = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_printf");
        public static final long dbg_text_vprintf = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_vprintf");
        public static final long dbg_text_image = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dbg_text_image");
        public static final long create_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_index_buffer");
        public static final long destroy_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_index_buffer");
        public static final long create_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_vertex_buffer");
        public static final long destroy_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_vertex_buffer");
        public static final long create_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_index_buffer");
        public static final long create_dynamic_index_buffer_mem = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_index_buffer_mem");
        public static final long update_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_dynamic_index_buffer");
        public static final long destroy_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_dynamic_index_buffer");
        public static final long create_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_vertex_buffer");
        public static final long create_dynamic_vertex_buffer_mem = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_dynamic_vertex_buffer_mem");
        public static final long update_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_dynamic_vertex_buffer");
        public static final long destroy_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_dynamic_vertex_buffer");
        public static final long get_avail_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_avail_transient_index_buffer");
        public static final long get_avail_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_avail_transient_vertex_buffer");
        public static final long get_avail_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_avail_instance_data_buffer");
        public static final long alloc_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transient_index_buffer");
        public static final long alloc_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transient_vertex_buffer");
        public static final long alloc_transient_buffers = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transient_buffers");
        public static final long alloc_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_instance_data_buffer");
        public static final long create_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_indirect_buffer");
        public static final long destroy_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_indirect_buffer");
        public static final long create_shader = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_shader");
        public static final long get_shader_uniforms = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_shader_uniforms");
        public static final long destroy_shader = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_shader");
        public static final long create_program = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_program");
        public static final long create_compute_program = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_compute_program");
        public static final long destroy_program = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_program");
        public static final long is_texture_valid = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_is_texture_valid");
        public static final long calc_texture_size = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_calc_texture_size");
        public static final long create_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture");
        public static final long create_texture_2d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_2d");
        public static final long create_texture_2d_scaled = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_2d_scaled");
        public static final long create_texture_3d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_3d");
        public static final long create_texture_cube = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_texture_cube");
        public static final long update_texture_2d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_texture_2d");
        public static final long update_texture_3d = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_texture_3d");
        public static final long update_texture_cube = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_update_texture_cube");
        public static final long read_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_read_texture");
        public static final long destroy_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_texture");
        public static final long create_frame_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer");
        public static final long create_frame_buffer_scaled = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_scaled");
        public static final long create_frame_buffer_from_handles = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_from_handles");
        public static final long create_frame_buffer_from_attachment = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_from_attachment");
        public static final long create_frame_buffer_from_nwh = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_frame_buffer_from_nwh");
        public static final long get_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_texture");
        public static final long destroy_frame_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_frame_buffer");
        public static final long create_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_uniform");
        public static final long get_uniform_info = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_uniform_info");
        public static final long destroy_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_uniform");
        public static final long create_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_create_occlusion_query");
        public static final long get_result = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_get_result");
        public static final long destroy_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_destroy_occlusion_query");
        public static final long set_palette_color = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_palette_color");
        public static final long set_view_name = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_name");
        public static final long set_view_rect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_rect");
        public static final long set_view_rect_auto = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_rect_auto");
        public static final long set_view_scissor = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_scissor");
        public static final long set_view_clear = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_clear");
        public static final long set_view_clear_mrt = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_clear_mrt");
        public static final long set_view_seq = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_seq");
        public static final long set_view_frame_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_frame_buffer");
        public static final long set_view_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_transform");
        public static final long set_view_transform_stereo = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_transform_stereo");
        public static final long set_view_order = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_view_order");
        public static final long reset_view = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_reset_view");
        public static final long set_marker = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_marker");
        public static final long set_state = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_state");
        public static final long set_condition = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_condition");
        public static final long set_stencil = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_stencil");
        public static final long set_scissor = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_scissor");
        public static final long set_scissor_cached = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_scissor_cached");
        public static final long set_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transform");
        public static final long alloc_transform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_alloc_transform");
        public static final long set_transform_cached = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transform_cached");
        public static final long set_uniform = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_uniform");
        public static final long set_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_index_buffer");
        public static final long set_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_dynamic_index_buffer");
        public static final long set_transient_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transient_index_buffer");
        public static final long set_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_vertex_buffer");
        public static final long set_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_dynamic_vertex_buffer");
        public static final long set_transient_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_transient_vertex_buffer");
        public static final long set_instance_data_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_data_buffer");
        public static final long set_instance_data_from_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_data_from_vertex_buffer");
        public static final long set_instance_data_from_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_instance_data_from_dynamic_vertex_buffer");
        public static final long set_texture = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_texture");
        public static final long touch = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_touch");
        public static final long submit = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_submit");
        public static final long submit_occlusion_query = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_submit_occlusion_query");
        public static final long submit_indirect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_submit_indirect");
        public static final long set_image = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_image");
        public static final long set_compute_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_index_buffer");
        public static final long set_compute_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_vertex_buffer");
        public static final long set_compute_dynamic_index_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_dynamic_index_buffer");
        public static final long set_compute_dynamic_vertex_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_dynamic_vertex_buffer");
        public static final long set_compute_indirect_buffer = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_set_compute_indirect_buffer");
        public static final long dispatch = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dispatch");
        public static final long dispatch_indirect = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_dispatch_indirect");
        public static final long discard = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_discard");
        public static final long blit = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_blit");
        public static final long request_screen_shot = APIUtil.apiGetFunctionAddress(org.lwjgl.bgfx.BGFX.access$000(), "bgfx_request_screen_shot");

        private Functions() {
        }
    }
}

