/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXAllocatorVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXAllocatorInterface
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    BGFXAllocatorInterface(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXAllocatorInterface(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXAllocatorInterface.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public BGFXAllocatorVtbl vtbl() {
        return BGFXAllocatorInterface.nvtbl(this.address());
    }

    public BGFXAllocatorInterface vtbl(BGFXAllocatorVtbl value) {
        BGFXAllocatorInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXAllocatorInterface set(BGFXAllocatorInterface src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXAllocatorInterface malloc() {
        return BGFXAllocatorInterface.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXAllocatorInterface calloc() {
        return BGFXAllocatorInterface.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXAllocatorInterface create() {
        return new BGFXAllocatorInterface(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXAllocatorInterface create(long address) {
        return address == 0L ? null : new BGFXAllocatorInterface(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXAllocatorInterface.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXAllocatorInterface.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXAllocatorInterface mallocStack() {
        return BGFXAllocatorInterface.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXAllocatorInterface callocStack() {
        return BGFXAllocatorInterface.callocStack(MemoryStack.stackGet());
    }

    public static BGFXAllocatorInterface mallocStack(MemoryStack stack) {
        return BGFXAllocatorInterface.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAllocatorInterface callocStack(MemoryStack stack) {
        return BGFXAllocatorInterface.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXAllocatorInterface.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXAllocatorInterface.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorInterface.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorInterface.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static BGFXAllocatorVtbl nvtbl(long struct) {
        return BGFXAllocatorVtbl.create(MemoryUtil.memGetAddress(struct + (long)VTBL));
    }

    public static void nvtbl(long struct, BGFXAllocatorVtbl value) {
        MemoryUtil.memPutAddress(struct + (long)VTBL, value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress(struct + (long)VTBL);
        Checks.check(vtbl);
        BGFXAllocatorVtbl.validate(vtbl);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXAllocatorInterface.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXAllocatorInterface.__struct(BGFXAllocatorInterface.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<BGFXAllocatorInterface, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXAllocatorInterface newInstance(long address) {
            return new BGFXAllocatorInterface(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public BGFXAllocatorVtbl vtbl() {
            return BGFXAllocatorInterface.nvtbl(this.address());
        }

        public Buffer vtbl(BGFXAllocatorVtbl value) {
            BGFXAllocatorInterface.nvtbl(this.address(), value);
            return this;
        }
    }
}

