/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXCallbackVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXCallbackInterface
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    BGFXCallbackInterface(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXCallbackInterface(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCallbackInterface.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public BGFXCallbackVtbl vtbl() {
        return BGFXCallbackInterface.nvtbl(this.address());
    }

    public BGFXCallbackInterface vtbl(BGFXCallbackVtbl value) {
        BGFXCallbackInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXCallbackInterface set(BGFXCallbackInterface src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXCallbackInterface malloc() {
        return BGFXCallbackInterface.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXCallbackInterface calloc() {
        return BGFXCallbackInterface.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXCallbackInterface create() {
        return new BGFXCallbackInterface(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXCallbackInterface create(long address) {
        return address == 0L ? null : new BGFXCallbackInterface(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXCallbackInterface.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXCallbackInterface.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXCallbackInterface mallocStack() {
        return BGFXCallbackInterface.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackInterface callocStack() {
        return BGFXCallbackInterface.callocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackInterface mallocStack(MemoryStack stack) {
        return BGFXCallbackInterface.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXCallbackInterface callocStack(MemoryStack stack) {
        return BGFXCallbackInterface.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXCallbackInterface.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXCallbackInterface.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXCallbackInterface.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXCallbackInterface.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static BGFXCallbackVtbl nvtbl(long struct) {
        return BGFXCallbackVtbl.create(MemoryUtil.memGetAddress(struct + (long)VTBL));
    }

    public static void nvtbl(long struct, BGFXCallbackVtbl value) {
        MemoryUtil.memPutAddress(struct + (long)VTBL, value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress(struct + (long)VTBL);
        Checks.check(vtbl);
        BGFXCallbackVtbl.validate(vtbl);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXCallbackInterface.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXCallbackInterface.__struct(BGFXCallbackInterface.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<BGFXCallbackInterface, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXCallbackInterface newInstance(long address) {
            return new BGFXCallbackInterface(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public BGFXCallbackVtbl vtbl() {
            return BGFXCallbackInterface.nvtbl(this.address());
        }

        public Buffer vtbl(BGFXCallbackVtbl value) {
            BGFXCallbackInterface.nvtbl(this.address(), value);
            return this;
        }
    }
}

