/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXCacheReadCallback;
import org.lwjgl.bgfx.BGFXCacheReadCallbackI;
import org.lwjgl.bgfx.BGFXCacheReadSizeCallback;
import org.lwjgl.bgfx.BGFXCacheReadSizeCallbackI;
import org.lwjgl.bgfx.BGFXCacheWriteCallback;
import org.lwjgl.bgfx.BGFXCacheWriteCallbackI;
import org.lwjgl.bgfx.BGFXCaptureBeginCallback;
import org.lwjgl.bgfx.BGFXCaptureBeginCallbackI;
import org.lwjgl.bgfx.BGFXCaptureEndCallback;
import org.lwjgl.bgfx.BGFXCaptureEndCallbackI;
import org.lwjgl.bgfx.BGFXCaptureFrameCallback;
import org.lwjgl.bgfx.BGFXCaptureFrameCallbackI;
import org.lwjgl.bgfx.BGFXFatalCallback;
import org.lwjgl.bgfx.BGFXFatalCallbackI;
import org.lwjgl.bgfx.BGFXScreenShotCallback;
import org.lwjgl.bgfx.BGFXScreenShotCallbackI;
import org.lwjgl.bgfx.BGFXTraceVarArgsCallback;
import org.lwjgl.bgfx.BGFXTraceVarArgsCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXCallbackVtbl
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FATAL;
    public static final int TRACE_VARGS;
    public static final int CACHE_READ_SIZE;
    public static final int CACHE_READ;
    public static final int CACHE_WRITE;
    public static final int SCREEN_SHOT;
    public static final int CAPTURE_BEGIN;
    public static final int CAPTURE_END;
    public static final int CAPTURE_FRAME;

    BGFXCallbackVtbl(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXCallbackVtbl(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCallbackVtbl.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public BGFXFatalCallback fatal() {
        return BGFXCallbackVtbl.nfatal(this.address());
    }

    public BGFXTraceVarArgsCallback trace_vargs() {
        return BGFXCallbackVtbl.ntrace_vargs(this.address());
    }

    public BGFXCacheReadSizeCallback cache_read_size() {
        return BGFXCallbackVtbl.ncache_read_size(this.address());
    }

    public BGFXCacheReadCallback cache_read() {
        return BGFXCallbackVtbl.ncache_read(this.address());
    }

    public BGFXCacheWriteCallback cache_write() {
        return BGFXCallbackVtbl.ncache_write(this.address());
    }

    public BGFXScreenShotCallback screen_shot() {
        return BGFXCallbackVtbl.nscreen_shot(this.address());
    }

    public BGFXCaptureBeginCallback capture_begin() {
        return BGFXCallbackVtbl.ncapture_begin(this.address());
    }

    public BGFXCaptureEndCallback capture_end() {
        return BGFXCallbackVtbl.ncapture_end(this.address());
    }

    public BGFXCaptureFrameCallback capture_frame() {
        return BGFXCallbackVtbl.ncapture_frame(this.address());
    }

    public BGFXCallbackVtbl fatal(BGFXFatalCallbackI value) {
        BGFXCallbackVtbl.nfatal(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl trace_vargs(BGFXTraceVarArgsCallbackI value) {
        BGFXCallbackVtbl.ntrace_vargs(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl cache_read_size(BGFXCacheReadSizeCallbackI value) {
        BGFXCallbackVtbl.ncache_read_size(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl cache_read(BGFXCacheReadCallbackI value) {
        BGFXCallbackVtbl.ncache_read(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl cache_write(BGFXCacheWriteCallbackI value) {
        BGFXCallbackVtbl.ncache_write(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl screen_shot(BGFXScreenShotCallbackI value) {
        BGFXCallbackVtbl.nscreen_shot(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl capture_begin(BGFXCaptureBeginCallbackI value) {
        BGFXCallbackVtbl.ncapture_begin(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl capture_end(BGFXCaptureEndCallbackI value) {
        BGFXCallbackVtbl.ncapture_end(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl capture_frame(BGFXCaptureFrameCallbackI value) {
        BGFXCallbackVtbl.ncapture_frame(this.address(), value);
        return this;
    }

    public BGFXCallbackVtbl set(BGFXFatalCallbackI fatal, BGFXTraceVarArgsCallbackI trace_vargs, BGFXCacheReadSizeCallbackI cache_read_size, BGFXCacheReadCallbackI cache_read, BGFXCacheWriteCallbackI cache_write, BGFXScreenShotCallbackI screen_shot, BGFXCaptureBeginCallbackI capture_begin, BGFXCaptureEndCallbackI capture_end, BGFXCaptureFrameCallbackI capture_frame) {
        this.fatal(fatal);
        this.trace_vargs(trace_vargs);
        this.cache_read_size(cache_read_size);
        this.cache_read(cache_read);
        this.cache_write(cache_write);
        this.screen_shot(screen_shot);
        this.capture_begin(capture_begin);
        this.capture_end(capture_end);
        this.capture_frame(capture_frame);
        return this;
    }

    public BGFXCallbackVtbl set(BGFXCallbackVtbl src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXCallbackVtbl malloc() {
        return BGFXCallbackVtbl.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXCallbackVtbl calloc() {
        return BGFXCallbackVtbl.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXCallbackVtbl create() {
        return new BGFXCallbackVtbl(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXCallbackVtbl create(long address) {
        return address == 0L ? null : new BGFXCallbackVtbl(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXCallbackVtbl.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXCallbackVtbl.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXCallbackVtbl mallocStack() {
        return BGFXCallbackVtbl.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackVtbl callocStack() {
        return BGFXCallbackVtbl.callocStack(MemoryStack.stackGet());
    }

    public static BGFXCallbackVtbl mallocStack(MemoryStack stack) {
        return BGFXCallbackVtbl.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXCallbackVtbl callocStack(MemoryStack stack) {
        return BGFXCallbackVtbl.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXCallbackVtbl.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXCallbackVtbl.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXCallbackVtbl.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXCallbackVtbl.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static BGFXFatalCallback nfatal(long struct) {
        return BGFXFatalCallback.create(MemoryUtil.memGetAddress(struct + (long)FATAL));
    }

    public static BGFXTraceVarArgsCallback ntrace_vargs(long struct) {
        return BGFXTraceVarArgsCallback.create(MemoryUtil.memGetAddress(struct + (long)TRACE_VARGS));
    }

    public static BGFXCacheReadSizeCallback ncache_read_size(long struct) {
        return BGFXCacheReadSizeCallback.create(MemoryUtil.memGetAddress(struct + (long)CACHE_READ_SIZE));
    }

    public static BGFXCacheReadCallback ncache_read(long struct) {
        return BGFXCacheReadCallback.create(MemoryUtil.memGetAddress(struct + (long)CACHE_READ));
    }

    public static BGFXCacheWriteCallback ncache_write(long struct) {
        return BGFXCacheWriteCallback.create(MemoryUtil.memGetAddress(struct + (long)CACHE_WRITE));
    }

    public static BGFXScreenShotCallback nscreen_shot(long struct) {
        return BGFXScreenShotCallback.create(MemoryUtil.memGetAddress(struct + (long)SCREEN_SHOT));
    }

    public static BGFXCaptureBeginCallback ncapture_begin(long struct) {
        return BGFXCaptureBeginCallback.create(MemoryUtil.memGetAddress(struct + (long)CAPTURE_BEGIN));
    }

    public static BGFXCaptureEndCallback ncapture_end(long struct) {
        return BGFXCaptureEndCallback.create(MemoryUtil.memGetAddress(struct + (long)CAPTURE_END));
    }

    public static BGFXCaptureFrameCallback ncapture_frame(long struct) {
        return BGFXCaptureFrameCallback.create(MemoryUtil.memGetAddress(struct + (long)CAPTURE_FRAME));
    }

    public static void nfatal(long struct, BGFXFatalCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)FATAL, value.address());
    }

    public static void ntrace_vargs(long struct, BGFXTraceVarArgsCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)TRACE_VARGS, value.address());
    }

    public static void ncache_read_size(long struct, BGFXCacheReadSizeCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CACHE_READ_SIZE, value.address());
    }

    public static void ncache_read(long struct, BGFXCacheReadCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CACHE_READ, value.address());
    }

    public static void ncache_write(long struct, BGFXCacheWriteCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CACHE_WRITE, value.address());
    }

    public static void nscreen_shot(long struct, BGFXScreenShotCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)SCREEN_SHOT, value.address());
    }

    public static void ncapture_begin(long struct, BGFXCaptureBeginCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CAPTURE_BEGIN, value.address());
    }

    public static void ncapture_end(long struct, BGFXCaptureEndCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CAPTURE_END, value.address());
    }

    public static void ncapture_frame(long struct, BGFXCaptureFrameCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CAPTURE_FRAME, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FATAL));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)TRACE_VARGS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CACHE_READ_SIZE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CACHE_READ));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CACHE_WRITE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SCREEN_SHOT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CAPTURE_BEGIN));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CAPTURE_END));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CAPTURE_FRAME));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXCallbackVtbl.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXCallbackVtbl.__struct(BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE), BGFXCallbackVtbl.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FATAL = layout.offsetof(0);
        TRACE_VARGS = layout.offsetof(1);
        CACHE_READ_SIZE = layout.offsetof(2);
        CACHE_READ = layout.offsetof(3);
        CACHE_WRITE = layout.offsetof(4);
        SCREEN_SHOT = layout.offsetof(5);
        CAPTURE_BEGIN = layout.offsetof(6);
        CAPTURE_END = layout.offsetof(7);
        CAPTURE_FRAME = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<BGFXCallbackVtbl, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXCallbackVtbl newInstance(long address) {
            return new BGFXCallbackVtbl(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public BGFXFatalCallback fatal() {
            return BGFXCallbackVtbl.nfatal(this.address());
        }

        public BGFXTraceVarArgsCallback trace_vargs() {
            return BGFXCallbackVtbl.ntrace_vargs(this.address());
        }

        public BGFXCacheReadSizeCallback cache_read_size() {
            return BGFXCallbackVtbl.ncache_read_size(this.address());
        }

        public BGFXCacheReadCallback cache_read() {
            return BGFXCallbackVtbl.ncache_read(this.address());
        }

        public BGFXCacheWriteCallback cache_write() {
            return BGFXCallbackVtbl.ncache_write(this.address());
        }

        public BGFXScreenShotCallback screen_shot() {
            return BGFXCallbackVtbl.nscreen_shot(this.address());
        }

        public BGFXCaptureBeginCallback capture_begin() {
            return BGFXCallbackVtbl.ncapture_begin(this.address());
        }

        public BGFXCaptureEndCallback capture_end() {
            return BGFXCallbackVtbl.ncapture_end(this.address());
        }

        public BGFXCaptureFrameCallback capture_frame() {
            return BGFXCallbackVtbl.ncapture_frame(this.address());
        }

        public Buffer fatal(BGFXFatalCallbackI value) {
            BGFXCallbackVtbl.nfatal(this.address(), value);
            return this;
        }

        public Buffer trace_vargs(BGFXTraceVarArgsCallbackI value) {
            BGFXCallbackVtbl.ntrace_vargs(this.address(), value);
            return this;
        }

        public Buffer cache_read_size(BGFXCacheReadSizeCallbackI value) {
            BGFXCallbackVtbl.ncache_read_size(this.address(), value);
            return this;
        }

        public Buffer cache_read(BGFXCacheReadCallbackI value) {
            BGFXCallbackVtbl.ncache_read(this.address(), value);
            return this;
        }

        public Buffer cache_write(BGFXCacheWriteCallbackI value) {
            BGFXCallbackVtbl.ncache_write(this.address(), value);
            return this;
        }

        public Buffer screen_shot(BGFXScreenShotCallbackI value) {
            BGFXCallbackVtbl.nscreen_shot(this.address(), value);
            return this;
        }

        public Buffer capture_begin(BGFXCaptureBeginCallbackI value) {
            BGFXCallbackVtbl.ncapture_begin(this.address(), value);
            return this;
        }

        public Buffer capture_end(BGFXCaptureEndCallbackI value) {
            BGFXCallbackVtbl.ncapture_end(this.address(), value);
            return this;
        }

        public Buffer capture_frame(BGFXCaptureFrameCallbackI value) {
            BGFXCallbackVtbl.ncapture_frame(this.address(), value);
            return this;
        }
    }
}

