/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.bgfx.BGFXCapsGPU;
import org.lwjgl.bgfx.BGFXCapsLimits;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXCaps
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RENDERERTYPE;
    public static final int SUPPORTED;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int HOMOGENEOUSDEPTH;
    public static final int ORIGINBOTTOMLEFT;
    public static final int NUMGPUS;
    public static final int GPU;
    public static final int LIMITS;
    public static final int FORMATS;

    BGFXCaps(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXCaps(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCaps.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int rendererType() {
        return BGFXCaps.nrendererType(this.address());
    }

    public long supported() {
        return BGFXCaps.nsupported(this.address());
    }

    public short vendorId() {
        return BGFXCaps.nvendorId(this.address());
    }

    public short deviceId() {
        return BGFXCaps.ndeviceId(this.address());
    }

    public boolean homogeneousDepth() {
        return BGFXCaps.nhomogeneousDepth(this.address());
    }

    public boolean originBottomLeft() {
        return BGFXCaps.noriginBottomLeft(this.address());
    }

    public byte numGPUs() {
        return BGFXCaps.nnumGPUs(this.address());
    }

    public BGFXCapsGPU.Buffer gpu() {
        return BGFXCaps.ngpu(this.address());
    }

    public BGFXCapsGPU gpu(int index) {
        return BGFXCaps.ngpu(this.address(), index);
    }

    public BGFXCapsLimits limits() {
        return BGFXCaps.nlimits(this.address());
    }

    public ShortBuffer formats() {
        return BGFXCaps.nformats(this.address());
    }

    public short formats(int index) {
        return BGFXCaps.nformats(this.address(), index);
    }

    public static BGFXCaps create(long address) {
        return address == 0L ? null : new BGFXCaps(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nrendererType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RENDERERTYPE);
    }

    public static long nsupported(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SUPPORTED);
    }

    public static short nvendorId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)VENDORID);
    }

    public static short ndeviceId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DEVICEID);
    }

    public static boolean nhomogeneousDepth(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HOMOGENEOUSDEPTH) != 0;
    }

    public static boolean noriginBottomLeft(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ORIGINBOTTOMLEFT) != 0;
    }

    public static byte nnumGPUs(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUMGPUS);
    }

    public static BGFXCapsGPU.Buffer ngpu(long struct) {
        return BGFXCapsGPU.create(struct + (long)GPU, Byte.toUnsignedInt(BGFXCaps.nnumGPUs(struct)));
    }

    public static BGFXCapsGPU ngpu(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return BGFXCapsGPU.create(struct + (long)GPU + (long)(index * BGFXCapsGPU.SIZEOF));
    }

    public static BGFXCapsLimits nlimits(long struct) {
        return BGFXCapsLimits.create(struct + (long)LIMITS);
    }

    public static ShortBuffer nformats(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)FORMATS, 76);
    }

    public static short nformats(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 76);
        }
        return MemoryUtil.memGetShort(struct + (long)FORMATS + (long)(index * 2));
    }

    static {
        Struct.Layout layout = BGFXCaps.__struct(BGFXCaps.__member(4), BGFXCaps.__member(8), BGFXCaps.__member(2), BGFXCaps.__member(2), BGFXCaps.__member(1), BGFXCaps.__member(1), BGFXCaps.__member(1), BGFXCaps.__array(BGFXCapsGPU.SIZEOF, BGFXCapsGPU.ALIGNOF, 4), BGFXCaps.__member(BGFXCapsLimits.SIZEOF, BGFXCapsLimits.ALIGNOF), BGFXCaps.__array(2, 76));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RENDERERTYPE = layout.offsetof(0);
        SUPPORTED = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        HOMOGENEOUSDEPTH = layout.offsetof(4);
        ORIGINBOTTOMLEFT = layout.offsetof(5);
        NUMGPUS = layout.offsetof(6);
        GPU = layout.offsetof(7);
        LIMITS = layout.offsetof(8);
        FORMATS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<BGFXCaps, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXCaps newInstance(long address) {
            return new BGFXCaps(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int rendererType() {
            return BGFXCaps.nrendererType(this.address());
        }

        public long supported() {
            return BGFXCaps.nsupported(this.address());
        }

        public short vendorId() {
            return BGFXCaps.nvendorId(this.address());
        }

        public short deviceId() {
            return BGFXCaps.ndeviceId(this.address());
        }

        public boolean homogeneousDepth() {
            return BGFXCaps.nhomogeneousDepth(this.address());
        }

        public boolean originBottomLeft() {
            return BGFXCaps.noriginBottomLeft(this.address());
        }

        public byte numGPUs() {
            return BGFXCaps.nnumGPUs(this.address());
        }

        public BGFXCapsGPU.Buffer gpu() {
            return BGFXCaps.ngpu(this.address());
        }

        public BGFXCapsGPU gpu(int index) {
            return BGFXCaps.ngpu(this.address(), index);
        }

        public BGFXCapsLimits limits() {
            return BGFXCaps.nlimits(this.address());
        }

        public ShortBuffer formats() {
            return BGFXCaps.nformats(this.address());
        }

        public short formats(int index) {
            return BGFXCaps.nformats(this.address(), index);
        }
    }
}

