/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXCapsLimits
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXDRAWCALLS;
    public static final int MAXBLITS;
    public static final int MAXTEXTURESIZE;
    public static final int MAXVIEWS;
    public static final int MAXFRAMEBUFFERS;
    public static final int MAXFBATTACHMENTS;
    public static final int MAXPROGRAMS;
    public static final int MAXSHADERS;
    public static final int MAXTEXTURES;
    public static final int MAXTEXTURESAMPLERS;
    public static final int MAXVERTEXDECLS;
    public static final int MAXVERTEXSTREAMS;
    public static final int MAXINDEXBUFFERS;
    public static final int MAXVERTEXBUFFERS;
    public static final int MAXDYNAMICINDEXBUFFERS;
    public static final int MAXDYNAMICVERTEXBUFFERS;
    public static final int MAXUNIFORMS;
    public static final int MAXOCCLUSIONQUERIES;

    BGFXCapsLimits(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXCapsLimits(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXCapsLimits.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int maxDrawCalls() {
        return BGFXCapsLimits.nmaxDrawCalls(this.address());
    }

    public int maxBlits() {
        return BGFXCapsLimits.nmaxBlits(this.address());
    }

    public int maxTextureSize() {
        return BGFXCapsLimits.nmaxTextureSize(this.address());
    }

    public int maxViews() {
        return BGFXCapsLimits.nmaxViews(this.address());
    }

    public int maxFrameBuffers() {
        return BGFXCapsLimits.nmaxFrameBuffers(this.address());
    }

    public int maxFBAttachments() {
        return BGFXCapsLimits.nmaxFBAttachments(this.address());
    }

    public int maxPrograms() {
        return BGFXCapsLimits.nmaxPrograms(this.address());
    }

    public int maxShaders() {
        return BGFXCapsLimits.nmaxShaders(this.address());
    }

    public int maxTextures() {
        return BGFXCapsLimits.nmaxTextures(this.address());
    }

    public int maxTextureSamplers() {
        return BGFXCapsLimits.nmaxTextureSamplers(this.address());
    }

    public int maxVertexDecls() {
        return BGFXCapsLimits.nmaxVertexDecls(this.address());
    }

    public int maxVertexStreams() {
        return BGFXCapsLimits.nmaxVertexStreams(this.address());
    }

    public int maxIndexBuffers() {
        return BGFXCapsLimits.nmaxIndexBuffers(this.address());
    }

    public int maxVertexBuffers() {
        return BGFXCapsLimits.nmaxVertexBuffers(this.address());
    }

    public int maxDynamicIndexBuffers() {
        return BGFXCapsLimits.nmaxDynamicIndexBuffers(this.address());
    }

    public int maxDynamicVertexBuffers() {
        return BGFXCapsLimits.nmaxDynamicVertexBuffers(this.address());
    }

    public int maxUniforms() {
        return BGFXCapsLimits.nmaxUniforms(this.address());
    }

    public int maxOcclusionQueries() {
        return BGFXCapsLimits.nmaxOcclusionQueries(this.address());
    }

    public static BGFXCapsLimits create(long address) {
        return address == 0L ? null : new BGFXCapsLimits(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nmaxDrawCalls(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDRAWCALLS);
    }

    public static int nmaxBlits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXBLITS);
    }

    public static int nmaxTextureSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTEXTURESIZE);
    }

    public static int nmaxViews(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVIEWS);
    }

    public static int nmaxFrameBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFRAMEBUFFERS);
    }

    public static int nmaxFBAttachments(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXFBATTACHMENTS);
    }

    public static int nmaxPrograms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXPROGRAMS);
    }

    public static int nmaxShaders(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSHADERS);
    }

    public static int nmaxTextures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTEXTURES);
    }

    public static int nmaxTextureSamplers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXTEXTURESAMPLERS);
    }

    public static int nmaxVertexDecls(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXDECLS);
    }

    public static int nmaxVertexStreams(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXSTREAMS);
    }

    public static int nmaxIndexBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXINDEXBUFFERS);
    }

    public static int nmaxVertexBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXVERTEXBUFFERS);
    }

    public static int nmaxDynamicIndexBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDYNAMICINDEXBUFFERS);
    }

    public static int nmaxDynamicVertexBuffers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXDYNAMICVERTEXBUFFERS);
    }

    public static int nmaxUniforms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXUNIFORMS);
    }

    public static int nmaxOcclusionQueries(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXOCCLUSIONQUERIES);
    }

    static {
        Struct.Layout layout = BGFXCapsLimits.__struct(BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4), BGFXCapsLimits.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXDRAWCALLS = layout.offsetof(0);
        MAXBLITS = layout.offsetof(1);
        MAXTEXTURESIZE = layout.offsetof(2);
        MAXVIEWS = layout.offsetof(3);
        MAXFRAMEBUFFERS = layout.offsetof(4);
        MAXFBATTACHMENTS = layout.offsetof(5);
        MAXPROGRAMS = layout.offsetof(6);
        MAXSHADERS = layout.offsetof(7);
        MAXTEXTURES = layout.offsetof(8);
        MAXTEXTURESAMPLERS = layout.offsetof(9);
        MAXVERTEXDECLS = layout.offsetof(10);
        MAXVERTEXSTREAMS = layout.offsetof(11);
        MAXINDEXBUFFERS = layout.offsetof(12);
        MAXVERTEXBUFFERS = layout.offsetof(13);
        MAXDYNAMICINDEXBUFFERS = layout.offsetof(14);
        MAXDYNAMICVERTEXBUFFERS = layout.offsetof(15);
        MAXUNIFORMS = layout.offsetof(16);
        MAXOCCLUSIONQUERIES = layout.offsetof(17);
    }

    public static class Buffer
    extends StructBuffer<BGFXCapsLimits, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXCapsLimits newInstance(long address) {
            return new BGFXCapsLimits(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int maxDrawCalls() {
            return BGFXCapsLimits.nmaxDrawCalls(this.address());
        }

        public int maxBlits() {
            return BGFXCapsLimits.nmaxBlits(this.address());
        }

        public int maxTextureSize() {
            return BGFXCapsLimits.nmaxTextureSize(this.address());
        }

        public int maxViews() {
            return BGFXCapsLimits.nmaxViews(this.address());
        }

        public int maxFrameBuffers() {
            return BGFXCapsLimits.nmaxFrameBuffers(this.address());
        }

        public int maxFBAttachments() {
            return BGFXCapsLimits.nmaxFBAttachments(this.address());
        }

        public int maxPrograms() {
            return BGFXCapsLimits.nmaxPrograms(this.address());
        }

        public int maxShaders() {
            return BGFXCapsLimits.nmaxShaders(this.address());
        }

        public int maxTextures() {
            return BGFXCapsLimits.nmaxTextures(this.address());
        }

        public int maxTextureSamplers() {
            return BGFXCapsLimits.nmaxTextureSamplers(this.address());
        }

        public int maxVertexDecls() {
            return BGFXCapsLimits.nmaxVertexDecls(this.address());
        }

        public int maxVertexStreams() {
            return BGFXCapsLimits.nmaxVertexStreams(this.address());
        }

        public int maxIndexBuffers() {
            return BGFXCapsLimits.nmaxIndexBuffers(this.address());
        }

        public int maxVertexBuffers() {
            return BGFXCapsLimits.nmaxVertexBuffers(this.address());
        }

        public int maxDynamicIndexBuffers() {
            return BGFXCapsLimits.nmaxDynamicIndexBuffers(this.address());
        }

        public int maxDynamicVertexBuffers() {
            return BGFXCapsLimits.nmaxDynamicVertexBuffers(this.address());
        }

        public int maxUniforms() {
            return BGFXCapsLimits.nmaxUniforms(this.address());
        }

        public int maxOcclusionQueries() {
            return BGFXCapsLimits.nmaxOcclusionQueries(this.address());
        }
    }
}

