/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.bgfx.BGFXHmdEye;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXHmd
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EYE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEVICEWIDTH;
    public static final int DEVICEHEIGHT;
    public static final int FLAGS;

    BGFXHmd(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXHmd(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXHmd.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public BGFXHmdEye.Buffer eye() {
        return BGFXHmd.neye(this.address());
    }

    public BGFXHmdEye eye(int index) {
        return BGFXHmd.neye(this.address(), index);
    }

    public short width() {
        return BGFXHmd.nwidth(this.address());
    }

    public short height() {
        return BGFXHmd.nheight(this.address());
    }

    public int deviceWidth() {
        return BGFXHmd.ndeviceWidth(this.address());
    }

    public int deviceHeight() {
        return BGFXHmd.ndeviceHeight(this.address());
    }

    public byte flags() {
        return BGFXHmd.nflags(this.address());
    }

    public static BGFXHmd create(long address) {
        return address == 0L ? null : new BGFXHmd(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXHmdEye.Buffer neye(long struct) {
        return BGFXHmdEye.create(struct + (long)EYE, 2);
    }

    public static BGFXHmdEye neye(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return BGFXHmdEye.create(struct + (long)EYE + (long)(index * BGFXHmdEye.SIZEOF));
    }

    public static short nwidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)WIDTH);
    }

    public static short nheight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HEIGHT);
    }

    public static int ndeviceWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEWIDTH);
    }

    public static int ndeviceHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEHEIGHT);
    }

    public static byte nflags(long struct) {
        return MemoryUtil.memGetByte(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = BGFXHmd.__struct(BGFXHmd.__array(BGFXHmdEye.SIZEOF, BGFXHmdEye.ALIGNOF, 2), BGFXHmd.__member(2), BGFXHmd.__member(2), BGFXHmd.__member(4), BGFXHmd.__member(4), BGFXHmd.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EYE = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        DEVICEWIDTH = layout.offsetof(3);
        DEVICEHEIGHT = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXHmd, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXHmd newInstance(long address) {
            return new BGFXHmd(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public BGFXHmdEye.Buffer eye() {
            return BGFXHmd.neye(this.address());
        }

        public BGFXHmdEye eye(int index) {
            return BGFXHmd.neye(this.address(), index);
        }

        public short width() {
            return BGFXHmd.nwidth(this.address());
        }

        public short height() {
            return BGFXHmd.nheight(this.address());
        }

        public int deviceWidth() {
            return BGFXHmd.ndeviceWidth(this.address());
        }

        public int deviceHeight() {
            return BGFXHmd.ndeviceHeight(this.address());
        }

        public byte flags() {
            return BGFXHmd.nflags(this.address());
        }
    }
}

