/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXHmdEye
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ROTATION;
    public static final int TRANSLATION;
    public static final int FOV;
    public static final int VIEWOFFSET;
    public static final int PROJECTION;
    public static final int PIXELSPERTANANGLE;

    BGFXHmdEye(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXHmdEye(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXHmdEye.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer rotation() {
        return BGFXHmdEye.nrotation(this.address());
    }

    public float rotation(int index) {
        return BGFXHmdEye.nrotation(this.address(), index);
    }

    public FloatBuffer translation() {
        return BGFXHmdEye.ntranslation(this.address());
    }

    public float translation(int index) {
        return BGFXHmdEye.ntranslation(this.address(), index);
    }

    public FloatBuffer fov() {
        return BGFXHmdEye.nfov(this.address());
    }

    public float fov(int index) {
        return BGFXHmdEye.nfov(this.address(), index);
    }

    public FloatBuffer viewOffset() {
        return BGFXHmdEye.nviewOffset(this.address());
    }

    public float viewOffset(int index) {
        return BGFXHmdEye.nviewOffset(this.address(), index);
    }

    public FloatBuffer projection() {
        return BGFXHmdEye.nprojection(this.address());
    }

    public float projection(int index) {
        return BGFXHmdEye.nprojection(this.address(), index);
    }

    public FloatBuffer pixelsPerTanAngle() {
        return BGFXHmdEye.npixelsPerTanAngle(this.address());
    }

    public float pixelsPerTanAngle(int index) {
        return BGFXHmdEye.npixelsPerTanAngle(this.address(), index);
    }

    public static BGFXHmdEye create(long address) {
        return address == 0L ? null : new BGFXHmdEye(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static FloatBuffer nrotation(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)ROTATION, 4);
    }

    public static float nrotation(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetFloat(struct + (long)ROTATION + (long)(index * 4));
    }

    public static FloatBuffer ntranslation(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)TRANSLATION, 3);
    }

    public static float ntranslation(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 3);
        }
        return MemoryUtil.memGetFloat(struct + (long)TRANSLATION + (long)(index * 4));
    }

    public static FloatBuffer nfov(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)FOV, 4);
    }

    public static float nfov(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetFloat(struct + (long)FOV + (long)(index * 4));
    }

    public static FloatBuffer nviewOffset(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)VIEWOFFSET, 3);
    }

    public static float nviewOffset(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 3);
        }
        return MemoryUtil.memGetFloat(struct + (long)VIEWOFFSET + (long)(index * 4));
    }

    public static FloatBuffer nprojection(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)PROJECTION, 16);
    }

    public static float nprojection(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetFloat(struct + (long)PROJECTION + (long)(index * 4));
    }

    public static FloatBuffer npixelsPerTanAngle(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)PIXELSPERTANANGLE, 2);
    }

    public static float npixelsPerTanAngle(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)PIXELSPERTANANGLE + (long)(index * 4));
    }

    static {
        Struct.Layout layout = BGFXHmdEye.__struct(BGFXHmdEye.__array(4, 4), BGFXHmdEye.__array(4, 3), BGFXHmdEye.__array(4, 4), BGFXHmdEye.__array(4, 3), BGFXHmdEye.__array(4, 16), BGFXHmdEye.__array(4, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ROTATION = layout.offsetof(0);
        TRANSLATION = layout.offsetof(1);
        FOV = layout.offsetof(2);
        VIEWOFFSET = layout.offsetof(3);
        PROJECTION = layout.offsetof(4);
        PIXELSPERTANANGLE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXHmdEye, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXHmdEye newInstance(long address) {
            return new BGFXHmdEye(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer rotation() {
            return BGFXHmdEye.nrotation(this.address());
        }

        public float rotation(int index) {
            return BGFXHmdEye.nrotation(this.address(), index);
        }

        public FloatBuffer translation() {
            return BGFXHmdEye.ntranslation(this.address());
        }

        public float translation(int index) {
            return BGFXHmdEye.ntranslation(this.address(), index);
        }

        public FloatBuffer fov() {
            return BGFXHmdEye.nfov(this.address());
        }

        public float fov(int index) {
            return BGFXHmdEye.nfov(this.address(), index);
        }

        public FloatBuffer viewOffset() {
            return BGFXHmdEye.nviewOffset(this.address());
        }

        public float viewOffset(int index) {
            return BGFXHmdEye.nviewOffset(this.address(), index);
        }

        public FloatBuffer projection() {
            return BGFXHmdEye.nprojection(this.address());
        }

        public float projection(int index) {
            return BGFXHmdEye.nprojection(this.address(), index);
        }

        public FloatBuffer pixelsPerTanAngle() {
            return BGFXHmdEye.npixelsPerTanAngle(this.address());
        }

        public float pixelsPerTanAngle(int index) {
            return BGFXHmdEye.npixelsPerTanAngle(this.address(), index);
        }
    }
}

