/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.bgfx.BGFXCaps;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXInternalData
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CAPS;

    BGFXInternalData(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXInternalData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXInternalData.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public BGFXCaps caps() {
        return BGFXInternalData.ncaps(this.address());
    }

    public static BGFXInternalData create(long address) {
        return address == 0L ? null : new BGFXInternalData(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXCaps ncaps(long struct) {
        return BGFXCaps.create(MemoryUtil.memGetAddress(struct + (long)CAPS));
    }

    static {
        Struct.Layout layout = BGFXInternalData.__struct(BGFXInternalData.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CAPS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<BGFXInternalData, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXInternalData newInstance(long address) {
            return new BGFXInternalData(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public BGFXCaps caps() {
            return BGFXInternalData.ncaps(this.address());
        }
    }
}

