/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXMemory
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;

    BGFXMemory(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXMemory(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXMemory.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer data() {
        return BGFXMemory.ndata(this.address());
    }

    public int size() {
        return BGFXMemory.nsize(this.address());
    }

    public BGFXMemory data(ByteBuffer value) {
        BGFXMemory.ndata(this.address(), value);
        return this;
    }

    public BGFXMemory set(BGFXMemory src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXMemory malloc() {
        return BGFXMemory.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXMemory calloc() {
        return BGFXMemory.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXMemory create() {
        return new BGFXMemory(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXMemory create(long address) {
        return address == 0L ? null : new BGFXMemory(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXMemory.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXMemory.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXMemory mallocStack() {
        return BGFXMemory.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXMemory callocStack() {
        return BGFXMemory.callocStack(MemoryStack.stackGet());
    }

    public static BGFXMemory mallocStack(MemoryStack stack) {
        return BGFXMemory.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXMemory callocStack(MemoryStack stack) {
        return BGFXMemory.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXMemory.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXMemory.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXMemory.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXMemory.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXMemory.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXMemory.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXMemory.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXMemory.__struct(BGFXMemory.__member(POINTER_SIZE), BGFXMemory.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXMemory, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXMemory newInstance(long address) {
            return new BGFXMemory(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer data() {
            return BGFXMemory.ndata(this.address());
        }

        public int size() {
            return BGFXMemory.nsize(this.address());
        }

        public Buffer data(ByteBuffer value) {
            BGFXMemory.ndata(this.address(), value);
            return this;
        }
    }
}

