/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXPlatformData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NDT;
    public static final int NWH;
    public static final int CONTEXT;
    public static final int BACKBUFFER;
    public static final int BACKBUFFERDS;
    public static final int SESSION;

    BGFXPlatformData(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXPlatformData(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXPlatformData.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long ndt() {
        return BGFXPlatformData.nndt(this.address());
    }

    public long nwh() {
        return BGFXPlatformData.nnwh(this.address());
    }

    public long context() {
        return BGFXPlatformData.ncontext(this.address());
    }

    public long backBuffer() {
        return BGFXPlatformData.nbackBuffer(this.address());
    }

    public long backBufferDS() {
        return BGFXPlatformData.nbackBufferDS(this.address());
    }

    public long session() {
        return BGFXPlatformData.nsession(this.address());
    }

    public BGFXPlatformData ndt(long value) {
        BGFXPlatformData.nndt(this.address(), value);
        return this;
    }

    public BGFXPlatformData nwh(long value) {
        BGFXPlatformData.nnwh(this.address(), value);
        return this;
    }

    public BGFXPlatformData context(long value) {
        BGFXPlatformData.ncontext(this.address(), value);
        return this;
    }

    public BGFXPlatformData backBuffer(long value) {
        BGFXPlatformData.nbackBuffer(this.address(), value);
        return this;
    }

    public BGFXPlatformData backBufferDS(long value) {
        BGFXPlatformData.nbackBufferDS(this.address(), value);
        return this;
    }

    public BGFXPlatformData session(long value) {
        BGFXPlatformData.nsession(this.address(), value);
        return this;
    }

    public BGFXPlatformData set(long ndt, long nwh, long context, long backBuffer, long backBufferDS, long session) {
        this.ndt(ndt);
        this.nwh(nwh);
        this.context(context);
        this.backBuffer(backBuffer);
        this.backBufferDS(backBufferDS);
        this.session(session);
        return this;
    }

    public BGFXPlatformData set(BGFXPlatformData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXPlatformData malloc() {
        return BGFXPlatformData.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXPlatformData calloc() {
        return BGFXPlatformData.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXPlatformData create() {
        return new BGFXPlatformData(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXPlatformData create(long address) {
        return address == 0L ? null : new BGFXPlatformData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXPlatformData.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXPlatformData.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXPlatformData mallocStack() {
        return BGFXPlatformData.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXPlatformData callocStack() {
        return BGFXPlatformData.callocStack(MemoryStack.stackGet());
    }

    public static BGFXPlatformData mallocStack(MemoryStack stack) {
        return BGFXPlatformData.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXPlatformData callocStack(MemoryStack stack) {
        return BGFXPlatformData.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXPlatformData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXPlatformData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXPlatformData.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXPlatformData.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nndt(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NDT);
    }

    public static long nnwh(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NWH);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTEXT);
    }

    public static long nbackBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BACKBUFFER);
    }

    public static long nbackBufferDS(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BACKBUFFERDS);
    }

    public static long nsession(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SESSION);
    }

    public static void nndt(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NDT, value);
    }

    public static void nnwh(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NWH, value);
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CONTEXT, value);
    }

    public static void nbackBuffer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BACKBUFFER, value);
    }

    public static void nbackBufferDS(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BACKBUFFERDS, value);
    }

    public static void nsession(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SESSION, value);
    }

    static {
        Struct.Layout layout = BGFXPlatformData.__struct(BGFXPlatformData.__member(POINTER_SIZE), BGFXPlatformData.__member(POINTER_SIZE), BGFXPlatformData.__member(POINTER_SIZE), BGFXPlatformData.__member(POINTER_SIZE), BGFXPlatformData.__member(POINTER_SIZE), BGFXPlatformData.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NDT = layout.offsetof(0);
        NWH = layout.offsetof(1);
        CONTEXT = layout.offsetof(2);
        BACKBUFFER = layout.offsetof(3);
        BACKBUFFERDS = layout.offsetof(4);
        SESSION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXPlatformData, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXPlatformData newInstance(long address) {
            return new BGFXPlatformData(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long ndt() {
            return BGFXPlatformData.nndt(this.address());
        }

        public long nwh() {
            return BGFXPlatformData.nnwh(this.address());
        }

        public long context() {
            return BGFXPlatformData.ncontext(this.address());
        }

        public long backBuffer() {
            return BGFXPlatformData.nbackBuffer(this.address());
        }

        public long backBufferDS() {
            return BGFXPlatformData.nbackBufferDS(this.address());
        }

        public long session() {
            return BGFXPlatformData.nsession(this.address());
        }

        public Buffer ndt(long value) {
            BGFXPlatformData.nndt(this.address(), value);
            return this;
        }

        public Buffer nwh(long value) {
            BGFXPlatformData.nnwh(this.address(), value);
            return this;
        }

        public Buffer context(long value) {
            BGFXPlatformData.ncontext(this.address(), value);
            return this;
        }

        public Buffer backBuffer(long value) {
            BGFXPlatformData.nbackBuffer(this.address(), value);
            return this;
        }

        public Buffer backBufferDS(long value) {
            BGFXPlatformData.nbackBufferDS(this.address(), value);
            return this;
        }

        public Buffer session(long value) {
            BGFXPlatformData.nsession(this.address(), value);
            return this;
        }
    }
}

