/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXStats
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CPUTIMEBEGIN;
    public static final int CPUTIMEEND;
    public static final int CPUTIMERFREQ;
    public static final int GPUTIMEBEGIN;
    public static final int GPUTIMEEND;
    public static final int GPUTIMERFREQ;
    public static final int WAITRENDER;
    public static final int WAITSUBMIT;
    public static final int NUMDRAW;
    public static final int NUMCOMPUTE;
    public static final int MAXGPULATENCY;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int TEXTWIDTH;
    public static final int TEXTHEIGHT;

    BGFXStats(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXStats(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXStats.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long cpuTimeBegin() {
        return BGFXStats.ncpuTimeBegin(this.address());
    }

    public long cpuTimeEnd() {
        return BGFXStats.ncpuTimeEnd(this.address());
    }

    public long cpuTimerFreq() {
        return BGFXStats.ncpuTimerFreq(this.address());
    }

    public long gpuTimeBegin() {
        return BGFXStats.ngpuTimeBegin(this.address());
    }

    public long gpuTimeEnd() {
        return BGFXStats.ngpuTimeEnd(this.address());
    }

    public long gpuTimerFreq() {
        return BGFXStats.ngpuTimerFreq(this.address());
    }

    public long waitRender() {
        return BGFXStats.nwaitRender(this.address());
    }

    public long waitSubmit() {
        return BGFXStats.nwaitSubmit(this.address());
    }

    public int numDraw() {
        return BGFXStats.nnumDraw(this.address());
    }

    public int numCompute() {
        return BGFXStats.nnumCompute(this.address());
    }

    public int maxGpuLatency() {
        return BGFXStats.nmaxGpuLatency(this.address());
    }

    public short width() {
        return BGFXStats.nwidth(this.address());
    }

    public short height() {
        return BGFXStats.nheight(this.address());
    }

    public short textWidth() {
        return BGFXStats.ntextWidth(this.address());
    }

    public short textHeight() {
        return BGFXStats.ntextHeight(this.address());
    }

    public static BGFXStats create(long address) {
        return address == 0L ? null : new BGFXStats(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static long ncpuTimeBegin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMEBEGIN);
    }

    public static long ncpuTimeEnd(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMEEND);
    }

    public static long ncpuTimerFreq(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CPUTIMERFREQ);
    }

    public static long ngpuTimeBegin(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUTIMEBEGIN);
    }

    public static long ngpuTimeEnd(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUTIMEEND);
    }

    public static long ngpuTimerFreq(long struct) {
        return MemoryUtil.memGetLong(struct + (long)GPUTIMERFREQ);
    }

    public static long nwaitRender(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WAITRENDER);
    }

    public static long nwaitSubmit(long struct) {
        return MemoryUtil.memGetLong(struct + (long)WAITSUBMIT);
    }

    public static int nnumDraw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMDRAW);
    }

    public static int nnumCompute(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMCOMPUTE);
    }

    public static int nmaxGpuLatency(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXGPULATENCY);
    }

    public static short nwidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)WIDTH);
    }

    public static short nheight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HEIGHT);
    }

    public static short ntextWidth(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TEXTWIDTH);
    }

    public static short ntextHeight(long struct) {
        return MemoryUtil.memGetShort(struct + (long)TEXTHEIGHT);
    }

    static {
        Struct.Layout layout = BGFXStats.__struct(BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(8), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__member(4), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2), BGFXStats.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CPUTIMEBEGIN = layout.offsetof(0);
        CPUTIMEEND = layout.offsetof(1);
        CPUTIMERFREQ = layout.offsetof(2);
        GPUTIMEBEGIN = layout.offsetof(3);
        GPUTIMEEND = layout.offsetof(4);
        GPUTIMERFREQ = layout.offsetof(5);
        WAITRENDER = layout.offsetof(6);
        WAITSUBMIT = layout.offsetof(7);
        NUMDRAW = layout.offsetof(8);
        NUMCOMPUTE = layout.offsetof(9);
        MAXGPULATENCY = layout.offsetof(10);
        WIDTH = layout.offsetof(11);
        HEIGHT = layout.offsetof(12);
        TEXTWIDTH = layout.offsetof(13);
        TEXTHEIGHT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<BGFXStats, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXStats newInstance(long address) {
            return new BGFXStats(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long cpuTimeBegin() {
            return BGFXStats.ncpuTimeBegin(this.address());
        }

        public long cpuTimeEnd() {
            return BGFXStats.ncpuTimeEnd(this.address());
        }

        public long cpuTimerFreq() {
            return BGFXStats.ncpuTimerFreq(this.address());
        }

        public long gpuTimeBegin() {
            return BGFXStats.ngpuTimeBegin(this.address());
        }

        public long gpuTimeEnd() {
            return BGFXStats.ngpuTimeEnd(this.address());
        }

        public long gpuTimerFreq() {
            return BGFXStats.ngpuTimerFreq(this.address());
        }

        public long waitRender() {
            return BGFXStats.nwaitRender(this.address());
        }

        public long waitSubmit() {
            return BGFXStats.nwaitSubmit(this.address());
        }

        public int numDraw() {
            return BGFXStats.nnumDraw(this.address());
        }

        public int numCompute() {
            return BGFXStats.nnumCompute(this.address());
        }

        public int maxGpuLatency() {
            return BGFXStats.nmaxGpuLatency(this.address());
        }

        public short width() {
            return BGFXStats.nwidth(this.address());
        }

        public short height() {
            return BGFXStats.nheight(this.address());
        }

        public short textWidth() {
            return BGFXStats.ntextWidth(this.address());
        }

        public short textHeight() {
            return BGFXStats.ntextHeight(this.address());
        }
    }
}

