/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXTransientIndexBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int HANDLE;
    public static final int STARTINDEX;

    BGFXTransientIndexBuffer(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXTransientIndexBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXTransientIndexBuffer.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer data() {
        return BGFXTransientIndexBuffer.ndata(this.address());
    }

    public int size() {
        return BGFXTransientIndexBuffer.nsize(this.address());
    }

    public short handle() {
        return BGFXTransientIndexBuffer.nhandle(this.address());
    }

    public int startIndex() {
        return BGFXTransientIndexBuffer.nstartIndex(this.address());
    }

    public BGFXTransientIndexBuffer data(ByteBuffer value) {
        BGFXTransientIndexBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer handle(short value) {
        BGFXTransientIndexBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer startIndex(int value) {
        BGFXTransientIndexBuffer.nstartIndex(this.address(), value);
        return this;
    }

    public BGFXTransientIndexBuffer set(ByteBuffer data, short handle, int startIndex) {
        this.data(data);
        this.handle(handle);
        this.startIndex(startIndex);
        return this;
    }

    public BGFXTransientIndexBuffer set(BGFXTransientIndexBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXTransientIndexBuffer malloc() {
        return BGFXTransientIndexBuffer.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXTransientIndexBuffer calloc() {
        return BGFXTransientIndexBuffer.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXTransientIndexBuffer create() {
        return new BGFXTransientIndexBuffer(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXTransientIndexBuffer create(long address) {
        return address == 0L ? null : new BGFXTransientIndexBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXTransientIndexBuffer.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXTransientIndexBuffer.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXTransientIndexBuffer mallocStack() {
        return BGFXTransientIndexBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXTransientIndexBuffer callocStack() {
        return BGFXTransientIndexBuffer.callocStack(MemoryStack.stackGet());
    }

    public static BGFXTransientIndexBuffer mallocStack(MemoryStack stack) {
        return BGFXTransientIndexBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTransientIndexBuffer callocStack(MemoryStack stack) {
        return BGFXTransientIndexBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXTransientIndexBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXTransientIndexBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransientIndexBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransientIndexBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXTransientIndexBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static short nhandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HANDLE);
    }

    public static int nstartIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STARTINDEX);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXTransientIndexBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void nhandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HANDLE, value);
    }

    public static void nstartIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STARTINDEX, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXTransientIndexBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXTransientIndexBuffer.__struct(BGFXTransientIndexBuffer.__member(POINTER_SIZE), BGFXTransientIndexBuffer.__member(4), BGFXTransientIndexBuffer.__member(2), BGFXTransientIndexBuffer.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        HANDLE = layout.offsetof(2);
        STARTINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransientIndexBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXTransientIndexBuffer newInstance(long address) {
            return new BGFXTransientIndexBuffer(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer data() {
            return BGFXTransientIndexBuffer.ndata(this.address());
        }

        public int size() {
            return BGFXTransientIndexBuffer.nsize(this.address());
        }

        public short handle() {
            return BGFXTransientIndexBuffer.nhandle(this.address());
        }

        public int startIndex() {
            return BGFXTransientIndexBuffer.nstartIndex(this.address());
        }

        public Buffer data(ByteBuffer value) {
            BGFXTransientIndexBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer handle(short value) {
            BGFXTransientIndexBuffer.nhandle(this.address(), value);
            return this;
        }

        public Buffer startIndex(int value) {
            BGFXTransientIndexBuffer.nstartIndex(this.address(), value);
            return this;
        }
    }
}

