/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXTransientVertexBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int STARTVERTEX;
    public static final int STRIDE;
    public static final int HANDLE;
    public static final int DECL;

    BGFXTransientVertexBuffer(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXTransientVertexBuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXTransientVertexBuffer.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer data() {
        return BGFXTransientVertexBuffer.ndata(this.address());
    }

    public int size() {
        return BGFXTransientVertexBuffer.nsize(this.address());
    }

    public int startVertex() {
        return BGFXTransientVertexBuffer.nstartVertex(this.address());
    }

    public short stride() {
        return BGFXTransientVertexBuffer.nstride(this.address());
    }

    public short handle() {
        return BGFXTransientVertexBuffer.nhandle(this.address());
    }

    public short decl() {
        return BGFXTransientVertexBuffer.ndecl(this.address());
    }

    public BGFXTransientVertexBuffer data(ByteBuffer value) {
        BGFXTransientVertexBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer startVertex(int value) {
        BGFXTransientVertexBuffer.nstartVertex(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer stride(short value) {
        BGFXTransientVertexBuffer.nstride(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer handle(short value) {
        BGFXTransientVertexBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer decl(short value) {
        BGFXTransientVertexBuffer.ndecl(this.address(), value);
        return this;
    }

    public BGFXTransientVertexBuffer set(ByteBuffer data, int startVertex, short stride, short handle, short decl) {
        this.data(data);
        this.startVertex(startVertex);
        this.stride(stride);
        this.handle(handle);
        this.decl(decl);
        return this;
    }

    public BGFXTransientVertexBuffer set(BGFXTransientVertexBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXTransientVertexBuffer malloc() {
        return BGFXTransientVertexBuffer.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXTransientVertexBuffer calloc() {
        return BGFXTransientVertexBuffer.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXTransientVertexBuffer create() {
        return new BGFXTransientVertexBuffer(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXTransientVertexBuffer create(long address) {
        return address == 0L ? null : new BGFXTransientVertexBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXTransientVertexBuffer.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXTransientVertexBuffer.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXTransientVertexBuffer mallocStack() {
        return BGFXTransientVertexBuffer.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXTransientVertexBuffer callocStack() {
        return BGFXTransientVertexBuffer.callocStack(MemoryStack.stackGet());
    }

    public static BGFXTransientVertexBuffer mallocStack(MemoryStack stack) {
        return BGFXTransientVertexBuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTransientVertexBuffer callocStack(MemoryStack stack) {
        return BGFXTransientVertexBuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXTransientVertexBuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXTransientVertexBuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransientVertexBuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransientVertexBuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXTransientVertexBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static int nstartVertex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STARTVERTEX);
    }

    public static short nstride(long struct) {
        return MemoryUtil.memGetShort(struct + (long)STRIDE);
    }

    public static short nhandle(long struct) {
        return MemoryUtil.memGetShort(struct + (long)HANDLE);
    }

    public static short ndecl(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DECL);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXTransientVertexBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    public static void nstartVertex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STARTVERTEX, value);
    }

    public static void nstride(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)STRIDE, value);
    }

    public static void nhandle(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)HANDLE, value);
    }

    public static void ndecl(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)DECL, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXTransientVertexBuffer.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = BGFXTransientVertexBuffer.__struct(BGFXTransientVertexBuffer.__member(POINTER_SIZE), BGFXTransientVertexBuffer.__member(4), BGFXTransientVertexBuffer.__member(4), BGFXTransientVertexBuffer.__member(2), BGFXTransientVertexBuffer.__member(2), BGFXTransientVertexBuffer.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        STARTVERTEX = layout.offsetof(2);
        STRIDE = layout.offsetof(3);
        HANDLE = layout.offsetof(4);
        DECL = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransientVertexBuffer, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXTransientVertexBuffer newInstance(long address) {
            return new BGFXTransientVertexBuffer(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer data() {
            return BGFXTransientVertexBuffer.ndata(this.address());
        }

        public int size() {
            return BGFXTransientVertexBuffer.nsize(this.address());
        }

        public int startVertex() {
            return BGFXTransientVertexBuffer.nstartVertex(this.address());
        }

        public short stride() {
            return BGFXTransientVertexBuffer.nstride(this.address());
        }

        public short handle() {
            return BGFXTransientVertexBuffer.nhandle(this.address());
        }

        public short decl() {
            return BGFXTransientVertexBuffer.ndecl(this.address());
        }

        public Buffer data(ByteBuffer value) {
            BGFXTransientVertexBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer startVertex(int value) {
            BGFXTransientVertexBuffer.nstartVertex(this.address(), value);
            return this;
        }

        public Buffer stride(short value) {
            BGFXTransientVertexBuffer.nstride(this.address(), value);
            return this;
        }

        public Buffer handle(short value) {
            BGFXTransientVertexBuffer.nhandle(this.address(), value);
            return this;
        }

        public Buffer decl(short value) {
            BGFXTransientVertexBuffer.ndecl(this.address(), value);
            return this;
        }
    }
}

