/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXUniformInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPE;
    public static final int NUM;

    BGFXUniformInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXUniformInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXUniformInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return BGFXUniformInfo.nname(this.address());
    }

    public String nameString() {
        return BGFXUniformInfo.nnameString(this.address());
    }

    public int type() {
        return BGFXUniformInfo.ntype(this.address());
    }

    public short num() {
        return BGFXUniformInfo.nnum(this.address());
    }

    public BGFXUniformInfo name(ByteBuffer value) {
        BGFXUniformInfo.nname(this.address(), value);
        return this;
    }

    public BGFXUniformInfo type(int value) {
        BGFXUniformInfo.ntype(this.address(), value);
        return this;
    }

    public BGFXUniformInfo num(short value) {
        BGFXUniformInfo.nnum(this.address(), value);
        return this;
    }

    public BGFXUniformInfo set(ByteBuffer name, int type, short num) {
        this.name(name);
        this.type(type);
        this.num(num);
        return this;
    }

    public BGFXUniformInfo set(BGFXUniformInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXUniformInfo malloc() {
        return BGFXUniformInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXUniformInfo calloc() {
        return BGFXUniformInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXUniformInfo create() {
        return new BGFXUniformInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXUniformInfo create(long address) {
        return address == 0L ? null : new BGFXUniformInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXUniformInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXUniformInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXUniformInfo mallocStack() {
        return BGFXUniformInfo.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXUniformInfo callocStack() {
        return BGFXUniformInfo.callocStack(MemoryStack.stackGet());
    }

    public static BGFXUniformInfo mallocStack(MemoryStack stack) {
        return BGFXUniformInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXUniformInfo callocStack(MemoryStack stack) {
        return BGFXUniformInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXUniformInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXUniformInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXUniformInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static short nnum(long struct) {
        return MemoryUtil.memGetShort(struct + (long)NUM);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
            Checks.checkGT(value, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)NAME, value.remaining());
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nnum(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)NUM, value);
    }

    static {
        Struct.Layout layout = BGFXUniformInfo.__struct(BGFXUniformInfo.__array(1, 256), BGFXUniformInfo.__member(4), BGFXUniformInfo.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        NUM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<BGFXUniformInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXUniformInfo newInstance(long address) {
            return new BGFXUniformInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer name() {
            return BGFXUniformInfo.nname(this.address());
        }

        public String nameString() {
            return BGFXUniformInfo.nnameString(this.address());
        }

        public int type() {
            return BGFXUniformInfo.ntype(this.address());
        }

        public short num() {
            return BGFXUniformInfo.nnum(this.address());
        }

        public Buffer name(ByteBuffer value) {
            BGFXUniformInfo.nname(this.address(), value);
            return this;
        }

        public Buffer type(int value) {
            BGFXUniformInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer num(short value) {
            BGFXUniformInfo.nnum(this.address(), value);
            return this;
        }
    }
}

