/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class BGFXVertexDecl
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASH;
    public static final int STRIDE;
    public static final int OFFSET;
    public static final int ATTRIBUTES;

    BGFXVertexDecl(long address, ByteBuffer container) {
        super(address, container);
    }

    public BGFXVertexDecl(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), BGFXVertexDecl.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int hash() {
        return BGFXVertexDecl.nhash(this.address());
    }

    public short stride() {
        return BGFXVertexDecl.nstride(this.address());
    }

    public ShortBuffer offset() {
        return BGFXVertexDecl.noffset(this.address());
    }

    public short offset(int index) {
        return BGFXVertexDecl.noffset(this.address(), index);
    }

    public ShortBuffer attributes() {
        return BGFXVertexDecl.nattributes(this.address());
    }

    public short attributes(int index) {
        return BGFXVertexDecl.nattributes(this.address(), index);
    }

    public BGFXVertexDecl hash(int value) {
        BGFXVertexDecl.nhash(this.address(), value);
        return this;
    }

    public BGFXVertexDecl stride(short value) {
        BGFXVertexDecl.nstride(this.address(), value);
        return this;
    }

    public BGFXVertexDecl offset(ShortBuffer value) {
        BGFXVertexDecl.noffset(this.address(), value);
        return this;
    }

    public BGFXVertexDecl offset(int index, short value) {
        BGFXVertexDecl.noffset(this.address(), index, value);
        return this;
    }

    public BGFXVertexDecl attributes(ShortBuffer value) {
        BGFXVertexDecl.nattributes(this.address(), value);
        return this;
    }

    public BGFXVertexDecl attributes(int index, short value) {
        BGFXVertexDecl.nattributes(this.address(), index, value);
        return this;
    }

    public BGFXVertexDecl set(int hash, short stride, ShortBuffer offset, ShortBuffer attributes) {
        this.hash(hash);
        this.stride(stride);
        this.offset(offset);
        this.attributes(attributes);
        return this;
    }

    public BGFXVertexDecl set(BGFXVertexDecl src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXVertexDecl malloc() {
        return BGFXVertexDecl.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static BGFXVertexDecl calloc() {
        return BGFXVertexDecl.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static BGFXVertexDecl create() {
        return new BGFXVertexDecl(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static BGFXVertexDecl create(long address) {
        return address == 0L ? null : new BGFXVertexDecl(address, null);
    }

    public static Buffer malloc(int capacity) {
        return BGFXVertexDecl.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXVertexDecl.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static BGFXVertexDecl mallocStack() {
        return BGFXVertexDecl.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXVertexDecl callocStack() {
        return BGFXVertexDecl.callocStack(MemoryStack.stackGet());
    }

    public static BGFXVertexDecl mallocStack(MemoryStack stack) {
        return BGFXVertexDecl.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXVertexDecl callocStack(MemoryStack stack) {
        return BGFXVertexDecl.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXVertexDecl.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXVertexDecl.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXVertexDecl.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXVertexDecl.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nhash(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HASH);
    }

    public static short nstride(long struct) {
        return MemoryUtil.memGetShort(struct + (long)STRIDE);
    }

    public static ShortBuffer noffset(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)OFFSET, 16);
    }

    public static short noffset(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetShort(struct + (long)OFFSET + (long)(index * 2));
    }

    public static ShortBuffer nattributes(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)ATTRIBUTES, 16);
    }

    public static short nattributes(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetShort(struct + (long)ATTRIBUTES + (long)(index * 2));
    }

    public static void nhash(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HASH, value);
    }

    public static void nstride(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)STRIDE, value);
    }

    public static void noffset(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)OFFSET, value.remaining() * 2);
    }

    public static void noffset(long struct, int index, short value) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        MemoryUtil.memPutShort(struct + (long)OFFSET + (long)(index * 2), value);
    }

    public static void nattributes(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ATTRIBUTES, value.remaining() * 2);
    }

    public static void nattributes(long struct, int index, short value) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        MemoryUtil.memPutShort(struct + (long)ATTRIBUTES + (long)(index * 2), value);
    }

    static {
        Struct.Layout layout = BGFXVertexDecl.__struct(BGFXVertexDecl.__member(4), BGFXVertexDecl.__member(2), BGFXVertexDecl.__array(2, 16), BGFXVertexDecl.__array(2, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASH = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        ATTRIBUTES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXVertexDecl, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected BGFXVertexDecl newInstance(long address) {
            return new BGFXVertexDecl(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int hash() {
            return BGFXVertexDecl.nhash(this.address());
        }

        public short stride() {
            return BGFXVertexDecl.nstride(this.address());
        }

        public ShortBuffer offset() {
            return BGFXVertexDecl.noffset(this.address());
        }

        public short offset(int index) {
            return BGFXVertexDecl.noffset(this.address(), index);
        }

        public ShortBuffer attributes() {
            return BGFXVertexDecl.nattributes(this.address());
        }

        public short attributes(int index) {
            return BGFXVertexDecl.nattributes(this.address(), index);
        }

        public Buffer hash(int value) {
            BGFXVertexDecl.nhash(this.address(), value);
            return this;
        }

        public Buffer stride(short value) {
            BGFXVertexDecl.nstride(this.address(), value);
            return this;
        }

        public Buffer offset(ShortBuffer value) {
            BGFXVertexDecl.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(int index, short value) {
            BGFXVertexDecl.noffset(this.address(), index, value);
            return this;
        }

        public Buffer attributes(ShortBuffer value) {
            BGFXVertexDecl.nattributes(this.address(), value);
            return this;
        }

        public Buffer attributes(int index, short value) {
            BGFXVertexDecl.nattributes(this.address(), index, value);
            return this;
        }
    }
}

