/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EGLClientPixmapHI
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PDATA;
    public static final int IWIDTH;
    public static final int IHEIGHT;
    public static final int ISTRIDE;

    EGLClientPixmapHI(long address, ByteBuffer container) {
        super(address, container);
    }

    public EGLClientPixmapHI(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), EGLClientPixmapHI.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer pData(int capacity) {
        return EGLClientPixmapHI.npData(this.address(), capacity);
    }

    public int iWidth() {
        return EGLClientPixmapHI.niWidth(this.address());
    }

    public int iHeight() {
        return EGLClientPixmapHI.niHeight(this.address());
    }

    public int iStride() {
        return EGLClientPixmapHI.niStride(this.address());
    }

    public EGLClientPixmapHI pData(ByteBuffer value) {
        EGLClientPixmapHI.npData(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iWidth(int value) {
        EGLClientPixmapHI.niWidth(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iHeight(int value) {
        EGLClientPixmapHI.niHeight(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iStride(int value) {
        EGLClientPixmapHI.niStride(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI set(ByteBuffer pData, int iWidth, int iHeight, int iStride) {
        this.pData(pData);
        this.iWidth(iWidth);
        this.iHeight(iHeight);
        this.iStride(iStride);
        return this;
    }

    public EGLClientPixmapHI set(EGLClientPixmapHI src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static EGLClientPixmapHI malloc() {
        return EGLClientPixmapHI.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static EGLClientPixmapHI calloc() {
        return EGLClientPixmapHI.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static EGLClientPixmapHI create() {
        return new EGLClientPixmapHI(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static EGLClientPixmapHI create(long address) {
        return address == 0L ? null : new EGLClientPixmapHI(address, null);
    }

    public static Buffer malloc(int capacity) {
        return EGLClientPixmapHI.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return EGLClientPixmapHI.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static EGLClientPixmapHI mallocStack() {
        return EGLClientPixmapHI.mallocStack(MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI callocStack() {
        return EGLClientPixmapHI.callocStack(MemoryStack.stackGet());
    }

    public static EGLClientPixmapHI mallocStack(MemoryStack stack) {
        return EGLClientPixmapHI.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static EGLClientPixmapHI callocStack(MemoryStack stack) {
        return EGLClientPixmapHI.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return EGLClientPixmapHI.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return EGLClientPixmapHI.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return EGLClientPixmapHI.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PDATA), capacity);
    }

    public static int niWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IWIDTH);
    }

    public static int niHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IHEIGHT);
    }

    public static int niStride(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISTRIDE);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddress(value));
    }

    public static void niWidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IWIDTH, value);
    }

    public static void niHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IHEIGHT, value);
    }

    public static void niStride(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISTRIDE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            EGLClientPixmapHI.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = EGLClientPixmapHI.__struct(EGLClientPixmapHI.__member(POINTER_SIZE), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PDATA = layout.offsetof(0);
        IWIDTH = layout.offsetof(1);
        IHEIGHT = layout.offsetof(2);
        ISTRIDE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<EGLClientPixmapHI, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected EGLClientPixmapHI newInstance(long address) {
            return new EGLClientPixmapHI(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer pData(int capacity) {
            return EGLClientPixmapHI.npData(this.address(), capacity);
        }

        public int iWidth() {
            return EGLClientPixmapHI.niWidth(this.address());
        }

        public int iHeight() {
            return EGLClientPixmapHI.niHeight(this.address());
        }

        public int iStride() {
            return EGLClientPixmapHI.niStride(this.address());
        }

        public Buffer pData(ByteBuffer value) {
            EGLClientPixmapHI.npData(this.address(), value);
            return this;
        }

        public Buffer iWidth(int value) {
            EGLClientPixmapHI.niWidth(this.address(), value);
            return this;
        }

        public Buffer iHeight(int value) {
            EGLClientPixmapHI.niHeight(this.address(), value);
            return this;
        }

        public Buffer iStride(int value) {
            EGLClientPixmapHI.niStride(this.address(), value);
            return this;
        }
    }
}

