/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDeviceEnumeration {
    protected EXTDeviceEnumeration() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryDevicesEXT);
    }

    public static int neglQueryDevicesEXT(int max_devices, long devices, long num_devices) {
        long __functionAddress = EGL.getCapabilities().eglQueryDevicesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(__functionAddress, max_devices, devices, num_devices);
    }

    public static boolean eglQueryDevicesEXT(PointerBuffer devices, IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)num_devices, 1);
        }
        return EXTDeviceEnumeration.neglQueryDevicesEXT(Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddress(num_devices)) != 0;
    }

    public static boolean eglQueryDevicesEXT(PointerBuffer devices, int[] num_devices) {
        long __functionAddress = EGL.getCapabilities().eglQueryDevicesEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(num_devices, 1);
        }
        return JNI.callPPI(__functionAddress, Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), num_devices) != 0;
    }
}

