/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRImage {
    public static final int EGL_NATIVE_PIXMAP_KHR = 12464;
    public static final long EGL_NO_IMAGE_KHR = 0L;

    protected KHRImage() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateImageKHR, caps.eglDestroyImageKHR);
    }

    public static long neglCreateImageKHR(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(ctx);
            Checks.check(buffer);
        }
        return JNI.callPPPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return KHRImage.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroyImageKHR(long dpy, long image) {
        long __functionAddress = EGL.getCapabilities().eglDestroyImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(image);
        }
        return JNI.callPPI(__functionAddress, dpy, image) != 0;
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(ctx);
            Checks.check(buffer);
            Checks.checkNTSafe(attrib_list, 12344);
        }
        return JNI.callPPPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }
}

