/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStreamAttrib {
    protected KHRStreamAttrib() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateStreamAttribKHR, caps.eglSetStreamAttribKHR, caps.eglQueryStreamAttribKHR, caps.eglStreamConsumerAcquireAttribKHR, caps.eglStreamConsumerReleaseAttribKHR);
    }

    public static long neglCreateStreamAttribKHR(long dpy, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, attrib_list);
    }

    public static long eglCreateStreamAttribKHR(long dpy, PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRStreamAttrib.neglCreateStreamAttribKHR(dpy, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglSetStreamAttribKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglSetStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attribute, value) != 0;
    }

    public static int neglQueryStreamAttribKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attribute, value);
    }

    public static boolean eglQueryStreamAttribKHR(long dpy, long stream, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.check(value, 1);
        }
        return KHRStreamAttrib.neglQueryStreamAttribKHR(dpy, stream, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static int neglStreamConsumerAcquireAttribKHR(long dpy, long stream, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamConsumerAcquireAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attrib_list);
    }

    public static boolean eglStreamConsumerAcquireAttribKHR(long dpy, long stream, PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRStreamAttrib.neglStreamConsumerAcquireAttribKHR(dpy, stream, MemoryUtil.memAddressSafe(attrib_list)) != 0;
    }

    public static int neglStreamConsumerReleaseAttribKHR(long dpy, long stream, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglStreamConsumerReleaseAttribKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attrib_list);
    }

    public static boolean eglStreamConsumerReleaseAttribKHR(long dpy, long stream, PointerBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(attrib_list, 12344L);
        }
        return KHRStreamAttrib.neglStreamConsumerReleaseAttribKHR(dpy, stream, MemoryUtil.memAddressSafe(attrib_list)) != 0;
    }
}

