/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStreamFIFO {
    public static final int EGL_STREAM_FIFO_LENGTH_KHR = 12796;
    public static final int EGL_STREAM_TIME_NOW_KHR = 12797;
    public static final int EGL_STREAM_TIME_CONSUMER_KHR = 12798;
    public static final int EGL_STREAM_TIME_PRODUCER_KHR = 12799;

    protected KHRStreamFIFO() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryStreamTimeKHR);
    }

    public static int neglQueryStreamTimeKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attribute, value);
    }

    public static boolean eglQueryStreamTimeKHR(long dpy, long stream, int attribute, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, 1);
        }
        return KHRStreamFIFO.neglQueryStreamTimeKHR(dpy, stream, attribute, MemoryUtil.memAddress(value)) != 0;
    }

    public static boolean eglQueryStreamTimeKHR(long dpy, long stream, int attribute, long[] value) {
        long __functionAddress = EGL.getCapabilities().eglQueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(stream);
            Checks.check(value, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, stream, attribute, value) != 0;
    }
}

