/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class MESAImageDMABufExport {
    protected MESAImageDMABufExport() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglExportDMABUFImageQueryMESA, caps.eglExportDMABUFImageMESA);
    }

    public static int neglExportDMABUFImageQueryMESA(long dpy, long image, long fourcc, long num_planes, long modifiers) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageQueryMESA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(image);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fourcc, num_planes, modifiers);
    }

    public static boolean eglExportDMABUFImageQueryMESA(long dpy, long image, IntBuffer fourcc, IntBuffer num_planes, LongBuffer modifiers) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)fourcc, 1);
            Checks.checkSafe((Buffer)num_planes, 1);
            Checks.checkSafe((Buffer)modifiers, 1);
        }
        return MESAImageDMABufExport.neglExportDMABUFImageQueryMESA(dpy, image, MemoryUtil.memAddressSafe(fourcc), MemoryUtil.memAddressSafe(num_planes), MemoryUtil.memAddressSafe(modifiers)) != 0;
    }

    public static int neglExportDMABUFImageMESA(long dpy, long image, long fds, long strides, long offsets) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageMESA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(image);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fds, strides, offsets);
    }

    public static boolean eglExportDMABUFImageMESA(long dpy, long image, IntBuffer fds, IntBuffer strides, IntBuffer offsets) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)fds, 1);
            Checks.checkSafe((Buffer)strides, 1);
            Checks.checkSafe((Buffer)offsets, 1);
        }
        return MESAImageDMABufExport.neglExportDMABUFImageMESA(dpy, image, MemoryUtil.memAddressSafe(fds), MemoryUtil.memAddressSafe(strides), MemoryUtil.memAddressSafe(offsets)) != 0;
    }

    public static boolean eglExportDMABUFImageQueryMESA(long dpy, long image, int[] fourcc, int[] num_planes, long[] modifiers) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageQueryMESA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(image);
            Checks.checkSafe(fourcc, 1);
            Checks.checkSafe(num_planes, 1);
            Checks.checkSafe(modifiers, 1);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fourcc, num_planes, modifiers) != 0;
    }

    public static boolean eglExportDMABUFImageMESA(long dpy, long image, int[] fds, int[] strides, int[] offsets) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageMESA;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(dpy);
            Checks.check(image);
            Checks.checkSafe(fds, 1);
            Checks.checkSafe(strides, 1);
            Checks.checkSafe(offsets, 1);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fds, strides, offsets) != 0;
    }
}

