/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.system.Callback;

public abstract class GLFWKeyCallback
extends Callback
implements GLFWKeyCallbackI {
    public static GLFWKeyCallback create(long functionPointer) {
        if (functionPointer == 0L) {
            return null;
        }
        GLFWKeyCallbackI instance = (GLFWKeyCallbackI)Callback.get(functionPointer);
        return instance instanceof GLFWKeyCallback ? (GLFWKeyCallback)instance : new Container(functionPointer, instance);
    }

    public static GLFWKeyCallback create(GLFWKeyCallbackI instance) {
        return instance instanceof GLFWKeyCallback ? (GLFWKeyCallback)instance : new Container(instance.address(), instance);
    }

    protected GLFWKeyCallback() {
        super("(piiii)v");
    }

    private GLFWKeyCallback(long functionPointer) {
        super(functionPointer);
    }

    public GLFWKeyCallback set(long window) {
        GLFW.glfwSetKeyCallback(window, this);
        return this;
    }

    private static final class Container
    extends GLFWKeyCallback {
        private final GLFWKeyCallbackI delegate;

        Container(long functionPointer, GLFWKeyCallbackI delegate) {
            super(functionPointer);
            this.delegate = delegate;
        }

        @Override
        public void invoke(long window, int key, int scancode, int action, int mods) {
            this.delegate.invoke(window, key, scancode, action, mods);
        }
    }
}

