/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NVGPaint
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XFORM;
    public static final int EXTENT;
    public static final int RADIUS;
    public static final int FEATHER;
    public static final int INNERCOLOR;
    public static final int OUTERCOLOR;
    public static final int IMAGE;

    NVGPaint(long address, ByteBuffer container) {
        super(address, container);
    }

    public NVGPaint(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NVGPaint.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer xform() {
        return NVGPaint.nxform(this.address());
    }

    public float xform(int index) {
        return NVGPaint.nxform(this.address(), index);
    }

    public FloatBuffer extent() {
        return NVGPaint.nextent(this.address());
    }

    public float extent(int index) {
        return NVGPaint.nextent(this.address(), index);
    }

    public float radius() {
        return NVGPaint.nradius(this.address());
    }

    public float feather() {
        return NVGPaint.nfeather(this.address());
    }

    public NVGColor innerColor() {
        return NVGPaint.ninnerColor(this.address());
    }

    public NVGColor outerColor() {
        return NVGPaint.nouterColor(this.address());
    }

    public int image() {
        return NVGPaint.nimage(this.address());
    }

    public NVGPaint xform(FloatBuffer value) {
        NVGPaint.nxform(this.address(), value);
        return this;
    }

    public NVGPaint xform(int index, float value) {
        NVGPaint.nxform(this.address(), index, value);
        return this;
    }

    public NVGPaint extent(FloatBuffer value) {
        NVGPaint.nextent(this.address(), value);
        return this;
    }

    public NVGPaint extent(int index, float value) {
        NVGPaint.nextent(this.address(), index, value);
        return this;
    }

    public NVGPaint radius(float value) {
        NVGPaint.nradius(this.address(), value);
        return this;
    }

    public NVGPaint feather(float value) {
        NVGPaint.nfeather(this.address(), value);
        return this;
    }

    public NVGPaint innerColor(NVGColor value) {
        NVGPaint.ninnerColor(this.address(), value);
        return this;
    }

    public NVGPaint outerColor(NVGColor value) {
        NVGPaint.nouterColor(this.address(), value);
        return this;
    }

    public NVGPaint image(int value) {
        NVGPaint.nimage(this.address(), value);
        return this;
    }

    public NVGPaint set(FloatBuffer xform, FloatBuffer extent, float radius, float feather, NVGColor innerColor, NVGColor outerColor, int image) {
        this.xform(xform);
        this.extent(extent);
        this.radius(radius);
        this.feather(feather);
        this.innerColor(innerColor);
        this.outerColor(outerColor);
        this.image(image);
        return this;
    }

    public NVGPaint set(NVGPaint src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NVGPaint malloc() {
        return NVGPaint.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NVGPaint calloc() {
        return NVGPaint.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NVGPaint create() {
        return new NVGPaint(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NVGPaint create(long address) {
        return address == 0L ? null : new NVGPaint(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NVGPaint.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NVGPaint.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NVGPaint mallocStack() {
        return NVGPaint.mallocStack(MemoryStack.stackGet());
    }

    public static NVGPaint callocStack() {
        return NVGPaint.callocStack(MemoryStack.stackGet());
    }

    public static NVGPaint mallocStack(MemoryStack stack) {
        return NVGPaint.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGPaint callocStack(MemoryStack stack) {
        return NVGPaint.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGPaint.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGPaint.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NVGPaint.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NVGPaint.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nxform(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)XFORM, 6);
    }

    public static float nxform(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        return MemoryUtil.memGetFloat(struct + (long)XFORM + (long)(index * 4));
    }

    public static FloatBuffer nextent(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)EXTENT, 2);
    }

    public static float nextent(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        return MemoryUtil.memGetFloat(struct + (long)EXTENT + (long)(index * 4));
    }

    public static float nradius(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RADIUS);
    }

    public static float nfeather(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FEATHER);
    }

    public static NVGColor ninnerColor(long struct) {
        return NVGColor.create(struct + (long)INNERCOLOR);
    }

    public static NVGColor nouterColor(long struct) {
        return NVGColor.create(struct + (long)OUTERCOLOR);
    }

    public static int nimage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE);
    }

    public static void nxform(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)XFORM, value.remaining() * 4);
    }

    public static void nxform(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 6);
        }
        MemoryUtil.memPutFloat(struct + (long)XFORM + (long)(index * 4), value);
    }

    public static void nextent(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)EXTENT, value.remaining() * 4);
    }

    public static void nextent(long struct, int index, float value) {
        if (Checks.CHECKS) {
            Checks.check(index, 2);
        }
        MemoryUtil.memPutFloat(struct + (long)EXTENT + (long)(index * 4), value);
    }

    public static void nradius(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RADIUS, value);
    }

    public static void nfeather(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FEATHER, value);
    }

    public static void ninnerColor(long struct, NVGColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INNERCOLOR, NVGColor.SIZEOF);
    }

    public static void nouterColor(long struct, NVGColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OUTERCOLOR, NVGColor.SIZEOF);
    }

    public static void nimage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGE, value);
    }

    static {
        Struct.Layout layout = NVGPaint.__struct(NVGPaint.__array(4, 6), NVGPaint.__array(4, 2), NVGPaint.__member(4), NVGPaint.__member(4), NVGPaint.__member(NVGColor.SIZEOF, NVGColor.ALIGNOF), NVGPaint.__member(NVGColor.SIZEOF, NVGColor.ALIGNOF), NVGPaint.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XFORM = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
        RADIUS = layout.offsetof(2);
        FEATHER = layout.offsetof(3);
        INNERCOLOR = layout.offsetof(4);
        OUTERCOLOR = layout.offsetof(5);
        IMAGE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NVGPaint, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NVGPaint newInstance(long address) {
            return new NVGPaint(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer xform() {
            return NVGPaint.nxform(this.address());
        }

        public float xform(int index) {
            return NVGPaint.nxform(this.address(), index);
        }

        public FloatBuffer extent() {
            return NVGPaint.nextent(this.address());
        }

        public float extent(int index) {
            return NVGPaint.nextent(this.address(), index);
        }

        public float radius() {
            return NVGPaint.nradius(this.address());
        }

        public float feather() {
            return NVGPaint.nfeather(this.address());
        }

        public NVGColor innerColor() {
            return NVGPaint.ninnerColor(this.address());
        }

        public NVGColor outerColor() {
            return NVGPaint.nouterColor(this.address());
        }

        public int image() {
            return NVGPaint.nimage(this.address());
        }

        public Buffer xform(FloatBuffer value) {
            NVGPaint.nxform(this.address(), value);
            return this;
        }

        public Buffer xform(int index, float value) {
            NVGPaint.nxform(this.address(), index, value);
            return this;
        }

        public Buffer extent(FloatBuffer value) {
            NVGPaint.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(int index, float value) {
            NVGPaint.nextent(this.address(), index, value);
            return this;
        }

        public Buffer radius(float value) {
            NVGPaint.nradius(this.address(), value);
            return this;
        }

        public Buffer feather(float value) {
            NVGPaint.nfeather(this.address(), value);
            return this;
        }

        public Buffer innerColor(NVGColor value) {
            NVGPaint.ninnerColor(this.address(), value);
            return this;
        }

        public Buffer outerColor(NVGColor value) {
            NVGPaint.nouterColor(this.address(), value);
            return this;
        }

        public Buffer image(int value) {
            NVGPaint.nimage(this.address(), value);
            return this;
        }
    }
}

