/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkBufferMarker
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIVE;
    public static final int OFFSET;

    NkBufferMarker(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkBufferMarker(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkBufferMarker.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int active() {
        return NkBufferMarker.nactive(this.address());
    }

    public long offset() {
        return NkBufferMarker.noffset(this.address());
    }

    public static NkBufferMarker create(long address) {
        return address == 0L ? null : new NkBufferMarker(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    static {
        Struct.Layout layout = NkBufferMarker.__struct(NkBufferMarker.__member(4), NkBufferMarker.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIVE = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkBufferMarker, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkBufferMarker newInstance(long address) {
            return new NkBufferMarker(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int active() {
            return NkBufferMarker.nactive(this.address());
        }

        public long offset() {
            return NkBufferMarker.noffset(this.address());
        }
    }
}

