/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkChartSlot;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkChart
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SLOT;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;
    public static final int SLOTS;

    NkChart(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkChart(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkChart.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int slot() {
        return NkChart.nslot(this.address());
    }

    public float x() {
        return NkChart.nx(this.address());
    }

    public float y() {
        return NkChart.ny(this.address());
    }

    public float w() {
        return NkChart.nw(this.address());
    }

    public float h() {
        return NkChart.nh(this.address());
    }

    public NkChartSlot.Buffer slots() {
        return NkChart.nslots(this.address());
    }

    public NkChartSlot slots(int index) {
        return NkChart.nslots(this.address(), index);
    }

    public static NkChart create(long address) {
        return address == 0L ? null : new NkChart(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nslot(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SLOT);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)W);
    }

    public static float nh(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)H);
    }

    public static NkChartSlot.Buffer nslots(long struct) {
        return NkChartSlot.create(struct + (long)SLOTS, 4);
    }

    public static NkChartSlot nslots(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return NkChartSlot.create(struct + (long)SLOTS + (long)(index * NkChartSlot.SIZEOF));
    }

    static {
        Struct.Layout layout = NkChart.__struct(NkChart.__member(4), NkChart.__member(4), NkChart.__member(4), NkChart.__member(4), NkChart.__member(4), NkChart.__array(NkChartSlot.SIZEOF, NkChartSlot.ALIGNOF, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SLOT = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        W = layout.offsetof(3);
        H = layout.offsetof(4);
        SLOTS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkChart, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkChart newInstance(long address) {
            return new NkChart(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int slot() {
            return NkChart.nslot(this.address());
        }

        public float x() {
            return NkChart.nx(this.address());
        }

        public float y() {
            return NkChart.ny(this.address());
        }

        public float w() {
            return NkChart.nw(this.address());
        }

        public float h() {
            return NkChart.nh(this.address());
        }

        public NkChartSlot.Buffer slots() {
            return NkChart.nslots(this.address());
        }

        public NkChartSlot slots(int index) {
            return NkChart.nslots(this.address(), index);
        }
    }
}

