/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkPluginCopy;
import org.lwjgl.nuklear.NkPluginCopyI;
import org.lwjgl.nuklear.NkPluginPaste;
import org.lwjgl.nuklear.NkPluginPasteI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkClipboard
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int PASTE;
    public static final int COPY;

    NkClipboard(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkClipboard(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkClipboard.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkHandle userdata() {
        return NkClipboard.nuserdata(this.address());
    }

    public NkPluginPaste paste() {
        return NkClipboard.npaste(this.address());
    }

    public NkPluginCopy copy() {
        return NkClipboard.ncopy(this.address());
    }

    public NkClipboard userdata(NkHandle value) {
        NkClipboard.nuserdata(this.address(), value);
        return this;
    }

    public NkClipboard paste(NkPluginPasteI value) {
        NkClipboard.npaste(this.address(), value);
        return this;
    }

    public NkClipboard copy(NkPluginCopyI value) {
        NkClipboard.ncopy(this.address(), value);
        return this;
    }

    public NkClipboard set(NkHandle userdata, NkPluginPasteI paste, NkPluginCopyI copy) {
        this.userdata(userdata);
        this.paste(paste);
        this.copy(copy);
        return this;
    }

    public NkClipboard set(NkClipboard src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkClipboard malloc() {
        return NkClipboard.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkClipboard calloc() {
        return NkClipboard.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkClipboard create() {
        return new NkClipboard(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkClipboard create(long address) {
        return address == 0L ? null : new NkClipboard(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkClipboard.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkClipboard.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkClipboard mallocStack() {
        return NkClipboard.mallocStack(MemoryStack.stackGet());
    }

    public static NkClipboard callocStack() {
        return NkClipboard.callocStack(MemoryStack.stackGet());
    }

    public static NkClipboard mallocStack(MemoryStack stack) {
        return NkClipboard.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkClipboard callocStack(MemoryStack stack) {
        return NkClipboard.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkClipboard.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkClipboard.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkClipboard.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkClipboard.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkPluginPaste npaste(long struct) {
        return NkPluginPaste.create(MemoryUtil.memGetAddress(struct + (long)PASTE));
    }

    public static NkPluginCopy ncopy(long struct) {
        return NkPluginCopy.create(MemoryUtil.memGetAddress(struct + (long)COPY));
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)USERDATA, NkHandle.SIZEOF);
    }

    public static void npaste(long struct, NkPluginPasteI value) {
        MemoryUtil.memPutAddress(struct + (long)PASTE, NkClipboard.addressSafe(value));
    }

    public static void ncopy(long struct, NkPluginCopyI value) {
        MemoryUtil.memPutAddress(struct + (long)COPY, NkClipboard.addressSafe(value));
    }

    static {
        Struct.Layout layout = NkClipboard.__struct(NkClipboard.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkClipboard.__member(POINTER_SIZE), NkClipboard.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        PASTE = layout.offsetof(1);
        COPY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkClipboard, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkClipboard newInstance(long address) {
            return new NkClipboard(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkHandle userdata() {
            return NkClipboard.nuserdata(this.address());
        }

        public NkPluginPaste paste() {
            return NkClipboard.npaste(this.address());
        }

        public NkPluginCopy copy() {
            return NkClipboard.ncopy(this.address());
        }

        public Buffer userdata(NkHandle value) {
            NkClipboard.nuserdata(this.address(), value);
            return this;
        }

        public Buffer paste(NkPluginPasteI value) {
            NkClipboard.npaste(this.address(), value);
            return this;
        }

        public Buffer copy(NkPluginCopyI value) {
            NkClipboard.ncopy(this.address(), value);
            return this;
        }
    }
}

