/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkCommand
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int USERDATA;

    NkCommand(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkCommand(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkCommand.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return NkCommand.ntype(this.address());
    }

    public long next() {
        return NkCommand.nnext(this.address());
    }

    public NkHandle userdata() {
        return NkCommand.nuserdata(this.address());
    }

    public static NkCommand create(long address) {
        return address == 0L ? null : new NkCommand(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    static {
        Struct.Layout layout = NkCommand.__struct(NkCommand.__member(4), NkCommand.__member(POINTER_SIZE), NkCommand.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        USERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkCommand, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkCommand newInstance(long address) {
            return new NkCommand(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int type() {
            return NkCommand.ntype(this.address());
        }

        public long next() {
            return NkCommand.nnext(this.address());
        }

        public NkHandle userdata() {
            return NkCommand.nuserdata(this.address());
        }
    }
}

