/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkConfigStackColorElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackColor
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int ELEMENTS;

    NkConfigStackColor(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackColor(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackColor.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int head() {
        return NkConfigStackColor.nhead(this.address());
    }

    public NkConfigStackColorElement.Buffer elements() {
        return NkConfigStackColor.nelements(this.address());
    }

    public NkConfigStackColorElement elements(int index) {
        return NkConfigStackColor.nelements(this.address(), index);
    }

    public static NkConfigStackColor create(long address) {
        return address == 0L ? null : new NkConfigStackColor(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nhead(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAD);
    }

    public static NkConfigStackColorElement.Buffer nelements(long struct) {
        return NkConfigStackColorElement.create(struct + (long)ELEMENTS, 32);
    }

    public static NkConfigStackColorElement nelements(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 32);
        }
        return NkConfigStackColorElement.create(struct + (long)ELEMENTS + (long)(index * NkConfigStackColorElement.SIZEOF));
    }

    static {
        Struct.Layout layout = NkConfigStackColor.__struct(NkConfigStackColor.__member(4), NkConfigStackColor.__array(NkConfigStackColorElement.SIZEOF, NkConfigStackColorElement.ALIGNOF, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEAD = layout.offsetof(0);
        ELEMENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackColor, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackColor newInstance(long address) {
            return new NkConfigStackColor(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int head() {
            return NkConfigStackColor.nhead(this.address());
        }

        public NkConfigStackColorElement.Buffer elements() {
            return NkConfigStackColor.nelements(this.address());
        }

        public NkConfigStackColorElement elements(int index) {
            return NkConfigStackColor.nelements(this.address(), index);
        }
    }
}

