/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackColorElement
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVALUES;
    public static final int OLD_VALUE;

    NkConfigStackColorElement(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackColorElement(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackColorElement.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkColor pValues() {
        return NkConfigStackColorElement.npValues(this.address());
    }

    public NkColor old_value() {
        return NkConfigStackColorElement.nold_value(this.address());
    }

    public static NkConfigStackColorElement create(long address) {
        return address == 0L ? null : new NkConfigStackColorElement(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkColor npValues(long struct) {
        return NkColor.create(MemoryUtil.memGetAddress(struct + (long)PVALUES));
    }

    public static NkColor nold_value(long struct) {
        return NkColor.create(struct + (long)OLD_VALUE);
    }

    static {
        Struct.Layout layout = NkConfigStackColorElement.__struct(NkConfigStackColorElement.__member(POINTER_SIZE), NkConfigStackColorElement.__member(NkColor.SIZEOF, NkColor.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVALUES = layout.offsetof(0);
        OLD_VALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackColorElement, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackColorElement newInstance(long address) {
            return new NkConfigStackColorElement(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkColor pValues() {
            return NkConfigStackColorElement.npValues(this.address());
        }

        public NkColor old_value() {
            return NkConfigStackColorElement.nold_value(this.address());
        }
    }
}

