/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkConfigStackFlagsElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackFlags
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int ELEMENTS;

    NkConfigStackFlags(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackFlags(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackFlags.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int head() {
        return NkConfigStackFlags.nhead(this.address());
    }

    public NkConfigStackFlagsElement.Buffer elements() {
        return NkConfigStackFlags.nelements(this.address());
    }

    public NkConfigStackFlagsElement elements(int index) {
        return NkConfigStackFlags.nelements(this.address(), index);
    }

    public static NkConfigStackFlags create(long address) {
        return address == 0L ? null : new NkConfigStackFlags(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nhead(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAD);
    }

    public static NkConfigStackFlagsElement.Buffer nelements(long struct) {
        return NkConfigStackFlagsElement.create(struct + (long)ELEMENTS, 32);
    }

    public static NkConfigStackFlagsElement nelements(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 32);
        }
        return NkConfigStackFlagsElement.create(struct + (long)ELEMENTS + (long)(index * NkConfigStackFlagsElement.SIZEOF));
    }

    static {
        Struct.Layout layout = NkConfigStackFlags.__struct(NkConfigStackFlags.__member(4), NkConfigStackFlags.__array(NkConfigStackFlagsElement.SIZEOF, NkConfigStackFlagsElement.ALIGNOF, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEAD = layout.offsetof(0);
        ELEMENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackFlags, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackFlags newInstance(long address) {
            return new NkConfigStackFlags(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int head() {
            return NkConfigStackFlags.nhead(this.address());
        }

        public NkConfigStackFlagsElement.Buffer elements() {
            return NkConfigStackFlags.nelements(this.address());
        }

        public NkConfigStackFlagsElement elements(int index) {
            return NkConfigStackFlags.nelements(this.address(), index);
        }
    }
}

