/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackFlagsElement
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVALUES;
    public static final int OLD_VALUE;

    NkConfigStackFlagsElement(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackFlagsElement(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackFlagsElement.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public IntBuffer pValues(int capacity) {
        return NkConfigStackFlagsElement.npValues(this.address(), capacity);
    }

    public int old_value() {
        return NkConfigStackFlagsElement.nold_value(this.address());
    }

    public static NkConfigStackFlagsElement create(long address) {
        return address == 0L ? null : new NkConfigStackFlagsElement(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static IntBuffer npValues(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PVALUES), capacity);
    }

    public static int nold_value(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLD_VALUE);
    }

    static {
        Struct.Layout layout = NkConfigStackFlagsElement.__struct(NkConfigStackFlagsElement.__member(POINTER_SIZE), NkConfigStackFlagsElement.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVALUES = layout.offsetof(0);
        OLD_VALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackFlagsElement, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackFlagsElement newInstance(long address) {
            return new NkConfigStackFlagsElement(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public IntBuffer pValues(int capacity) {
            return NkConfigStackFlagsElement.npValues(this.address(), capacity);
        }

        public int old_value() {
            return NkConfigStackFlagsElement.nold_value(this.address());
        }
    }
}

