/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkConfigStackFloatElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackFloat
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int ELEMENTS;

    NkConfigStackFloat(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackFloat(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackFloat.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int head() {
        return NkConfigStackFloat.nhead(this.address());
    }

    public NkConfigStackFloatElement.Buffer elements() {
        return NkConfigStackFloat.nelements(this.address());
    }

    public NkConfigStackFloatElement elements(int index) {
        return NkConfigStackFloat.nelements(this.address(), index);
    }

    public static NkConfigStackFloat create(long address) {
        return address == 0L ? null : new NkConfigStackFloat(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nhead(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAD);
    }

    public static NkConfigStackFloatElement.Buffer nelements(long struct) {
        return NkConfigStackFloatElement.create(struct + (long)ELEMENTS, 32);
    }

    public static NkConfigStackFloatElement nelements(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 32);
        }
        return NkConfigStackFloatElement.create(struct + (long)ELEMENTS + (long)(index * NkConfigStackFloatElement.SIZEOF));
    }

    static {
        Struct.Layout layout = NkConfigStackFloat.__struct(NkConfigStackFloat.__member(4), NkConfigStackFloat.__array(NkConfigStackFloatElement.SIZEOF, NkConfigStackFloatElement.ALIGNOF, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEAD = layout.offsetof(0);
        ELEMENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackFloat, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackFloat newInstance(long address) {
            return new NkConfigStackFloat(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int head() {
            return NkConfigStackFloat.nhead(this.address());
        }

        public NkConfigStackFloatElement.Buffer elements() {
            return NkConfigStackFloat.nelements(this.address());
        }

        public NkConfigStackFloatElement elements(int index) {
            return NkConfigStackFloat.nelements(this.address(), index);
        }
    }
}

