/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackStyleItemElement
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVALUES;
    public static final int OLD_VALUE;

    NkConfigStackStyleItemElement(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackStyleItemElement(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackStyleItemElement.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkStyleItem pValues() {
        return NkConfigStackStyleItemElement.npValues(this.address());
    }

    public NkStyleItem old_value() {
        return NkConfigStackStyleItemElement.nold_value(this.address());
    }

    public static NkConfigStackStyleItemElement create(long address) {
        return address == 0L ? null : new NkConfigStackStyleItemElement(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkStyleItem npValues(long struct) {
        return NkStyleItem.create(MemoryUtil.memGetAddress(struct + (long)PVALUES));
    }

    public static NkStyleItem nold_value(long struct) {
        return NkStyleItem.create(struct + (long)OLD_VALUE);
    }

    static {
        Struct.Layout layout = NkConfigStackStyleItemElement.__struct(NkConfigStackStyleItemElement.__member(POINTER_SIZE), NkConfigStackStyleItemElement.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVALUES = layout.offsetof(0);
        OLD_VALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackStyleItemElement, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackStyleItemElement newInstance(long address) {
            return new NkConfigStackStyleItemElement(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkStyleItem pValues() {
            return NkConfigStackStyleItemElement.npValues(this.address());
        }

        public NkStyleItem old_value() {
            return NkConfigStackStyleItemElement.nold_value(this.address());
        }
    }
}

