/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkConfigStackVec2Element;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackVec2
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int ELEMENTS;

    NkConfigStackVec2(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackVec2(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackVec2.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int head() {
        return NkConfigStackVec2.nhead(this.address());
    }

    public NkConfigStackVec2Element.Buffer elements() {
        return NkConfigStackVec2.nelements(this.address());
    }

    public NkConfigStackVec2Element elements(int index) {
        return NkConfigStackVec2.nelements(this.address(), index);
    }

    public static NkConfigStackVec2 create(long address) {
        return address == 0L ? null : new NkConfigStackVec2(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nhead(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAD);
    }

    public static NkConfigStackVec2Element.Buffer nelements(long struct) {
        return NkConfigStackVec2Element.create(struct + (long)ELEMENTS, 16);
    }

    public static NkConfigStackVec2Element nelements(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return NkConfigStackVec2Element.create(struct + (long)ELEMENTS + (long)(index * NkConfigStackVec2Element.SIZEOF));
    }

    static {
        Struct.Layout layout = NkConfigStackVec2.__struct(NkConfigStackVec2.__member(4), NkConfigStackVec2.__array(NkConfigStackVec2Element.SIZEOF, NkConfigStackVec2Element.ALIGNOF, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEAD = layout.offsetof(0);
        ELEMENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackVec2, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackVec2 newInstance(long address) {
            return new NkConfigStackVec2(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int head() {
            return NkConfigStackVec2.nhead(this.address());
        }

        public NkConfigStackVec2Element.Buffer elements() {
            return NkConfigStackVec2.nelements(this.address());
        }

        public NkConfigStackVec2Element elements(int index) {
            return NkConfigStackVec2.nelements(this.address(), index);
        }
    }
}

