/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigStackVec2Element
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PVALUES;
    public static final int OLD_VALUE;

    NkConfigStackVec2Element(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigStackVec2Element(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigStackVec2Element.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkVec2 pValues() {
        return NkConfigStackVec2Element.npValues(this.address());
    }

    public NkVec2 old_value() {
        return NkConfigStackVec2Element.nold_value(this.address());
    }

    public static NkConfigStackVec2Element create(long address) {
        return address == 0L ? null : new NkConfigStackVec2Element(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkVec2 npValues(long struct) {
        return NkVec2.create(MemoryUtil.memGetAddress(struct + (long)PVALUES));
    }

    public static NkVec2 nold_value(long struct) {
        return NkVec2.create(struct + (long)OLD_VALUE);
    }

    static {
        Struct.Layout layout = NkConfigStackVec2Element.__struct(NkConfigStackVec2Element.__member(POINTER_SIZE), NkConfigStackVec2Element.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PVALUES = layout.offsetof(0);
        OLD_VALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackVec2Element, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigStackVec2Element newInstance(long address) {
            return new NkConfigStackVec2Element(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkVec2 pValues() {
            return NkConfigStackVec2Element.npValues(this.address());
        }

        public NkVec2 old_value() {
            return NkConfigStackVec2Element.nold_value(this.address());
        }
    }
}

