/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkConfigStackButtonBehavior;
import org.lwjgl.nuklear.NkConfigStackColor;
import org.lwjgl.nuklear.NkConfigStackFlags;
import org.lwjgl.nuklear.NkConfigStackFloat;
import org.lwjgl.nuklear.NkConfigStackStyleItem;
import org.lwjgl.nuklear.NkConfigStackUserFont;
import org.lwjgl.nuklear.NkConfigStackVec2;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

class NkConfigurationStacks
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYLE_ITEMS;
    public static final int FLOATS;
    public static final int VECTORS;
    public static final int FLAGS;
    public static final int COLORS;
    public static final int FONTS;
    public static final int BUTTON_BEHAVIORS;

    NkConfigurationStacks(long address, ByteBuffer container) {
        super(address, container);
    }

    NkConfigurationStacks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConfigurationStacks.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkConfigStackStyleItem style_items() {
        return NkConfigurationStacks.nstyle_items(this.address());
    }

    public NkConfigStackFloat floats() {
        return NkConfigurationStacks.nfloats(this.address());
    }

    public NkConfigStackVec2 vectors() {
        return NkConfigurationStacks.nvectors(this.address());
    }

    public NkConfigStackFlags flags() {
        return NkConfigurationStacks.nflags(this.address());
    }

    public NkConfigStackColor colors() {
        return NkConfigurationStacks.ncolors(this.address());
    }

    public NkConfigStackUserFont fonts() {
        return NkConfigurationStacks.nfonts(this.address());
    }

    public NkConfigStackButtonBehavior button_behaviors() {
        return NkConfigurationStacks.nbutton_behaviors(this.address());
    }

    public static NkConfigurationStacks create(long address) {
        return address == 0L ? null : new NkConfigurationStacks(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkConfigStackStyleItem nstyle_items(long struct) {
        return NkConfigStackStyleItem.create(struct + (long)STYLE_ITEMS);
    }

    public static NkConfigStackFloat nfloats(long struct) {
        return NkConfigStackFloat.create(struct + (long)FLOATS);
    }

    public static NkConfigStackVec2 nvectors(long struct) {
        return NkConfigStackVec2.create(struct + (long)VECTORS);
    }

    public static NkConfigStackFlags nflags(long struct) {
        return NkConfigStackFlags.create(struct + (long)FLAGS);
    }

    public static NkConfigStackColor ncolors(long struct) {
        return NkConfigStackColor.create(struct + (long)COLORS);
    }

    public static NkConfigStackUserFont nfonts(long struct) {
        return NkConfigStackUserFont.create(struct + (long)FONTS);
    }

    public static NkConfigStackButtonBehavior nbutton_behaviors(long struct) {
        return NkConfigStackButtonBehavior.create(struct + (long)BUTTON_BEHAVIORS);
    }

    static {
        Struct.Layout layout = NkConfigurationStacks.__struct(NkConfigurationStacks.__member(NkConfigStackStyleItem.SIZEOF, NkConfigStackStyleItem.ALIGNOF), NkConfigurationStacks.__member(NkConfigStackFloat.SIZEOF, NkConfigStackFloat.ALIGNOF), NkConfigurationStacks.__member(NkConfigStackVec2.SIZEOF, NkConfigStackVec2.ALIGNOF), NkConfigurationStacks.__member(NkConfigStackFlags.SIZEOF, NkConfigStackFlags.ALIGNOF), NkConfigurationStacks.__member(NkConfigStackColor.SIZEOF, NkConfigStackColor.ALIGNOF), NkConfigurationStacks.__member(NkConfigStackUserFont.SIZEOF, NkConfigStackUserFont.ALIGNOF), NkConfigurationStacks.__member(NkConfigStackButtonBehavior.SIZEOF, NkConfigStackButtonBehavior.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYLE_ITEMS = layout.offsetof(0);
        FLOATS = layout.offsetof(1);
        VECTORS = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        COLORS = layout.offsetof(4);
        FONTS = layout.offsetof(5);
        BUTTON_BEHAVIORS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkConfigurationStacks, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConfigurationStacks newInstance(long address) {
            return new NkConfigurationStacks(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkConfigStackStyleItem style_items() {
            return NkConfigurationStacks.nstyle_items(this.address());
        }

        public NkConfigStackFloat floats() {
            return NkConfigurationStacks.nfloats(this.address());
        }

        public NkConfigStackVec2 vectors() {
            return NkConfigurationStacks.nvectors(this.address());
        }

        public NkConfigStackFlags flags() {
            return NkConfigurationStacks.nflags(this.address());
        }

        public NkConfigStackColor colors() {
            return NkConfigurationStacks.ncolors(this.address());
        }

        public NkConfigStackUserFont fonts() {
            return NkConfigurationStacks.nfonts(this.address());
        }

        public NkConfigStackButtonBehavior button_behaviors() {
            return NkConfigurationStacks.nbutton_behaviors(this.address());
        }
    }
}

