/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkDrawNullTexture;
import org.lwjgl.nuklear.NkDrawVertexLayoutElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkConvertConfig
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GLOBAL_ALPHA;
    public static final int LINE_AA;
    public static final int SHAPE_AA;
    public static final int CIRCLE_SEGMENT_COUNT;
    public static final int ARC_SEGMENT_COUNT;
    public static final int CURVE_SEGMENT_COUNT;
    public static final int NULL_TEXTURE;
    public static final int VERTEX_LAYOUT;
    public static final int VERTEX_SIZE;
    public static final int VERTEX_ALIGNMENT;

    NkConvertConfig(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkConvertConfig(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkConvertConfig.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float global_alpha() {
        return NkConvertConfig.nglobal_alpha(this.address());
    }

    public int line_AA() {
        return NkConvertConfig.nline_AA(this.address());
    }

    public int shape_AA() {
        return NkConvertConfig.nshape_AA(this.address());
    }

    public int circle_segment_count() {
        return NkConvertConfig.ncircle_segment_count(this.address());
    }

    public int arc_segment_count() {
        return NkConvertConfig.narc_segment_count(this.address());
    }

    public int curve_segment_count() {
        return NkConvertConfig.ncurve_segment_count(this.address());
    }

    public NkDrawNullTexture null_texture() {
        return NkConvertConfig.nnull_texture(this.address());
    }

    public NkDrawVertexLayoutElement.Buffer vertex_layout(int capacity) {
        return NkConvertConfig.nvertex_layout(this.address(), capacity);
    }

    public long vertex_size() {
        return NkConvertConfig.nvertex_size(this.address());
    }

    public long vertex_alignment() {
        return NkConvertConfig.nvertex_alignment(this.address());
    }

    public NkConvertConfig global_alpha(float value) {
        NkConvertConfig.nglobal_alpha(this.address(), value);
        return this;
    }

    public NkConvertConfig line_AA(int value) {
        NkConvertConfig.nline_AA(this.address(), value);
        return this;
    }

    public NkConvertConfig shape_AA(int value) {
        NkConvertConfig.nshape_AA(this.address(), value);
        return this;
    }

    public NkConvertConfig circle_segment_count(int value) {
        NkConvertConfig.ncircle_segment_count(this.address(), value);
        return this;
    }

    public NkConvertConfig arc_segment_count(int value) {
        NkConvertConfig.narc_segment_count(this.address(), value);
        return this;
    }

    public NkConvertConfig curve_segment_count(int value) {
        NkConvertConfig.ncurve_segment_count(this.address(), value);
        return this;
    }

    public NkConvertConfig null_texture(NkDrawNullTexture value) {
        NkConvertConfig.nnull_texture(this.address(), value);
        return this;
    }

    public NkConvertConfig vertex_layout(NkDrawVertexLayoutElement.Buffer value) {
        NkConvertConfig.nvertex_layout(this.address(), value);
        return this;
    }

    public NkConvertConfig vertex_size(long value) {
        NkConvertConfig.nvertex_size(this.address(), value);
        return this;
    }

    public NkConvertConfig vertex_alignment(long value) {
        NkConvertConfig.nvertex_alignment(this.address(), value);
        return this;
    }

    public NkConvertConfig set(float global_alpha, int line_AA, int shape_AA, int circle_segment_count, int arc_segment_count, int curve_segment_count, NkDrawNullTexture null_texture, NkDrawVertexLayoutElement.Buffer vertex_layout, long vertex_size, long vertex_alignment) {
        this.global_alpha(global_alpha);
        this.line_AA(line_AA);
        this.shape_AA(shape_AA);
        this.circle_segment_count(circle_segment_count);
        this.arc_segment_count(arc_segment_count);
        this.curve_segment_count(curve_segment_count);
        this.null_texture(null_texture);
        this.vertex_layout(vertex_layout);
        this.vertex_size(vertex_size);
        this.vertex_alignment(vertex_alignment);
        return this;
    }

    public NkConvertConfig set(NkConvertConfig src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkConvertConfig malloc() {
        return NkConvertConfig.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkConvertConfig calloc() {
        return NkConvertConfig.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkConvertConfig create() {
        return new NkConvertConfig(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkConvertConfig create(long address) {
        return address == 0L ? null : new NkConvertConfig(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkConvertConfig.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkConvertConfig.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkConvertConfig mallocStack() {
        return NkConvertConfig.mallocStack(MemoryStack.stackGet());
    }

    public static NkConvertConfig callocStack() {
        return NkConvertConfig.callocStack(MemoryStack.stackGet());
    }

    public static NkConvertConfig mallocStack(MemoryStack stack) {
        return NkConvertConfig.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkConvertConfig callocStack(MemoryStack stack) {
        return NkConvertConfig.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkConvertConfig.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkConvertConfig.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkConvertConfig.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkConvertConfig.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nglobal_alpha(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)GLOBAL_ALPHA);
    }

    public static int nline_AA(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LINE_AA);
    }

    public static int nshape_AA(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHAPE_AA);
    }

    public static int ncircle_segment_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CIRCLE_SEGMENT_COUNT);
    }

    public static int narc_segment_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ARC_SEGMENT_COUNT);
    }

    public static int ncurve_segment_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURVE_SEGMENT_COUNT);
    }

    public static NkDrawNullTexture nnull_texture(long struct) {
        return NkDrawNullTexture.create(struct + (long)NULL_TEXTURE);
    }

    public static NkDrawVertexLayoutElement.Buffer nvertex_layout(long struct, int capacity) {
        return NkDrawVertexLayoutElement.create(MemoryUtil.memGetAddress(struct + (long)VERTEX_LAYOUT), capacity);
    }

    public static long nvertex_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VERTEX_SIZE);
    }

    public static long nvertex_alignment(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VERTEX_ALIGNMENT);
    }

    public static void nglobal_alpha(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)GLOBAL_ALPHA, value);
    }

    public static void nline_AA(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LINE_AA, value);
    }

    public static void nshape_AA(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHAPE_AA, value);
    }

    public static void ncircle_segment_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CIRCLE_SEGMENT_COUNT, value);
    }

    public static void narc_segment_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ARC_SEGMENT_COUNT, value);
    }

    public static void ncurve_segment_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CURVE_SEGMENT_COUNT, value);
    }

    public static void nnull_texture(long struct, NkDrawNullTexture value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NULL_TEXTURE, NkDrawNullTexture.SIZEOF);
    }

    public static void nvertex_layout(long struct, NkDrawVertexLayoutElement.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_LAYOUT, value.address());
    }

    public static void nvertex_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_SIZE, value);
    }

    public static void nvertex_alignment(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEX_ALIGNMENT, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEX_LAYOUT));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            NkConvertConfig.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = NkConvertConfig.__struct(NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(4), NkConvertConfig.__member(NkDrawNullTexture.SIZEOF, NkDrawNullTexture.ALIGNOF), NkConvertConfig.__member(POINTER_SIZE), NkConvertConfig.__member(POINTER_SIZE), NkConvertConfig.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GLOBAL_ALPHA = layout.offsetof(0);
        LINE_AA = layout.offsetof(1);
        SHAPE_AA = layout.offsetof(2);
        CIRCLE_SEGMENT_COUNT = layout.offsetof(3);
        ARC_SEGMENT_COUNT = layout.offsetof(4);
        CURVE_SEGMENT_COUNT = layout.offsetof(5);
        NULL_TEXTURE = layout.offsetof(6);
        VERTEX_LAYOUT = layout.offsetof(7);
        VERTEX_SIZE = layout.offsetof(8);
        VERTEX_ALIGNMENT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<NkConvertConfig, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkConvertConfig newInstance(long address) {
            return new NkConvertConfig(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float global_alpha() {
            return NkConvertConfig.nglobal_alpha(this.address());
        }

        public int line_AA() {
            return NkConvertConfig.nline_AA(this.address());
        }

        public int shape_AA() {
            return NkConvertConfig.nshape_AA(this.address());
        }

        public int circle_segment_count() {
            return NkConvertConfig.ncircle_segment_count(this.address());
        }

        public int arc_segment_count() {
            return NkConvertConfig.narc_segment_count(this.address());
        }

        public int curve_segment_count() {
            return NkConvertConfig.ncurve_segment_count(this.address());
        }

        public NkDrawNullTexture null_texture() {
            return NkConvertConfig.nnull_texture(this.address());
        }

        public NkDrawVertexLayoutElement.Buffer vertex_layout(int capacity) {
            return NkConvertConfig.nvertex_layout(this.address(), capacity);
        }

        public long vertex_size() {
            return NkConvertConfig.nvertex_size(this.address());
        }

        public long vertex_alignment() {
            return NkConvertConfig.nvertex_alignment(this.address());
        }

        public Buffer global_alpha(float value) {
            NkConvertConfig.nglobal_alpha(this.address(), value);
            return this;
        }

        public Buffer line_AA(int value) {
            NkConvertConfig.nline_AA(this.address(), value);
            return this;
        }

        public Buffer shape_AA(int value) {
            NkConvertConfig.nshape_AA(this.address(), value);
            return this;
        }

        public Buffer circle_segment_count(int value) {
            NkConvertConfig.ncircle_segment_count(this.address(), value);
            return this;
        }

        public Buffer arc_segment_count(int value) {
            NkConvertConfig.narc_segment_count(this.address(), value);
            return this;
        }

        public Buffer curve_segment_count(int value) {
            NkConvertConfig.ncurve_segment_count(this.address(), value);
            return this;
        }

        public Buffer null_texture(NkDrawNullTexture value) {
            NkConvertConfig.nnull_texture(this.address(), value);
            return this;
        }

        public Buffer vertex_layout(NkDrawVertexLayoutElement.Buffer value) {
            NkConvertConfig.nvertex_layout(this.address(), value);
            return this;
        }

        public Buffer vertex_size(long value) {
            NkConvertConfig.nvertex_size(this.address(), value);
            return this;
        }

        public Buffer vertex_alignment(long value) {
            NkConvertConfig.nvertex_alignment(this.address(), value);
            return this;
        }
    }
}

