/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkCursor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMG;
    public static final int SIZE;
    public static final int OFFSET;

    NkCursor(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkCursor(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkCursor.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkImage img() {
        return NkCursor.nimg(this.address());
    }

    public NkVec2 size() {
        return NkCursor.nsize(this.address());
    }

    public NkVec2 offset() {
        return NkCursor.noffset(this.address());
    }

    public NkCursor img(NkImage value) {
        NkCursor.nimg(this.address(), value);
        return this;
    }

    public NkCursor size(NkVec2 value) {
        NkCursor.nsize(this.address(), value);
        return this;
    }

    public NkCursor offset(NkVec2 value) {
        NkCursor.noffset(this.address(), value);
        return this;
    }

    public NkCursor set(NkImage img, NkVec2 size, NkVec2 offset) {
        this.img(img);
        this.size(size);
        this.offset(offset);
        return this;
    }

    public NkCursor set(NkCursor src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkCursor malloc() {
        return NkCursor.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkCursor calloc() {
        return NkCursor.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkCursor create() {
        return new NkCursor(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkCursor create(long address) {
        return address == 0L ? null : new NkCursor(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkCursor.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkCursor.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkCursor mallocStack() {
        return NkCursor.mallocStack(MemoryStack.stackGet());
    }

    public static NkCursor callocStack() {
        return NkCursor.callocStack(MemoryStack.stackGet());
    }

    public static NkCursor mallocStack(MemoryStack stack) {
        return NkCursor.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkCursor callocStack(MemoryStack stack) {
        return NkCursor.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkCursor.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkCursor.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkCursor.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkCursor.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkImage nimg(long struct) {
        return NkImage.create(struct + (long)IMG);
    }

    public static NkVec2 nsize(long struct) {
        return NkVec2.create(struct + (long)SIZE);
    }

    public static NkVec2 noffset(long struct) {
        return NkVec2.create(struct + (long)OFFSET);
    }

    public static void nimg(long struct, NkImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMG, NkImage.SIZEOF);
    }

    public static void nsize(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SIZE, NkVec2.SIZEOF);
    }

    public static void noffset(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, NkVec2.SIZEOF);
    }

    static {
        Struct.Layout layout = NkCursor.__struct(NkCursor.__member(NkImage.SIZEOF, NkImage.ALIGNOF), NkCursor.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkCursor.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMG = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkCursor, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkCursor newInstance(long address) {
            return new NkCursor(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkImage img() {
            return NkCursor.nimg(this.address());
        }

        public NkVec2 size() {
            return NkCursor.nsize(this.address());
        }

        public NkVec2 offset() {
            return NkCursor.noffset(this.address());
        }

        public Buffer img(NkImage value) {
            NkCursor.nimg(this.address(), value);
            return this;
        }

        public Buffer size(NkVec2 value) {
            NkCursor.nsize(this.address(), value);
            return this;
        }

        public Buffer offset(NkVec2 value) {
            NkCursor.noffset(this.address(), value);
            return this;
        }
    }
}

