/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.nuklear.NkConvertConfig;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkRect;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkDrawList
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLIP_RECT;
    public static final int CIRCLE_VTX;
    public static final int CONFIG;
    public static final int BUFFER;
    public static final int VERTICES;
    public static final int ELEMENTS;
    public static final int ELEMENT_COUNT;
    public static final int VERTEX_COUNT;
    public static final int CMD_COUNT;
    public static final int CMD_OFFSET;
    public static final int PATH_COUNT;
    public static final int PATH_OFFSET;
    public static final int USERDATA;

    NkDrawList(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkDrawList(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkDrawList.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkRect clip_rect() {
        return NkDrawList.nclip_rect(this.address());
    }

    public NkVec2.Buffer circle_vtx() {
        return NkDrawList.ncircle_vtx(this.address());
    }

    public NkVec2 circle_vtx(int index) {
        return NkDrawList.ncircle_vtx(this.address(), index);
    }

    public NkConvertConfig config() {
        return NkDrawList.nconfig(this.address());
    }

    public NkBuffer buffer() {
        return NkDrawList.nbuffer(this.address());
    }

    public NkBuffer vertices() {
        return NkDrawList.nvertices(this.address());
    }

    public NkBuffer elements() {
        return NkDrawList.nelements(this.address());
    }

    public int element_count() {
        return NkDrawList.nelement_count(this.address());
    }

    public int vertex_count() {
        return NkDrawList.nvertex_count(this.address());
    }

    public int cmd_count() {
        return NkDrawList.ncmd_count(this.address());
    }

    public long cmd_offset() {
        return NkDrawList.ncmd_offset(this.address());
    }

    public int path_count() {
        return NkDrawList.npath_count(this.address());
    }

    public int path_offset() {
        return NkDrawList.npath_offset(this.address());
    }

    public NkHandle userdata() {
        return NkDrawList.nuserdata(this.address());
    }

    public static NkDrawList malloc() {
        return NkDrawList.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkDrawList calloc() {
        return NkDrawList.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkDrawList create() {
        return new NkDrawList(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkDrawList create(long address) {
        return address == 0L ? null : new NkDrawList(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkDrawList.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkDrawList.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkDrawList mallocStack() {
        return NkDrawList.mallocStack(MemoryStack.stackGet());
    }

    public static NkDrawList callocStack() {
        return NkDrawList.callocStack(MemoryStack.stackGet());
    }

    public static NkDrawList mallocStack(MemoryStack stack) {
        return NkDrawList.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkDrawList callocStack(MemoryStack stack) {
        return NkDrawList.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkDrawList.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkDrawList.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkDrawList.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkDrawList.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkRect nclip_rect(long struct) {
        return NkRect.create(struct + (long)CLIP_RECT);
    }

    public static NkVec2.Buffer ncircle_vtx(long struct) {
        return NkVec2.create(struct + (long)CIRCLE_VTX, 12);
    }

    public static NkVec2 ncircle_vtx(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 12);
        }
        return NkVec2.create(struct + (long)CIRCLE_VTX + (long)(index * NkVec2.SIZEOF));
    }

    public static NkConvertConfig nconfig(long struct) {
        return NkConvertConfig.create(struct + (long)CONFIG);
    }

    public static NkBuffer nbuffer(long struct) {
        return NkBuffer.create(MemoryUtil.memGetAddress(struct + (long)BUFFER));
    }

    public static NkBuffer nvertices(long struct) {
        return NkBuffer.create(MemoryUtil.memGetAddress(struct + (long)VERTICES));
    }

    public static NkBuffer nelements(long struct) {
        return NkBuffer.create(MemoryUtil.memGetAddress(struct + (long)ELEMENTS));
    }

    public static int nelement_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ELEMENT_COUNT);
    }

    public static int nvertex_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEX_COUNT);
    }

    public static int ncmd_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CMD_COUNT);
    }

    public static long ncmd_offset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CMD_OFFSET);
    }

    public static int npath_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PATH_COUNT);
    }

    public static int npath_offset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PATH_OFFSET);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    static {
        Struct.Layout layout = NkDrawList.__struct(NkDrawList.__member(NkRect.SIZEOF, NkRect.ALIGNOF), NkDrawList.__array(NkVec2.SIZEOF, NkVec2.ALIGNOF, 12), NkDrawList.__member(NkConvertConfig.SIZEOF, NkConvertConfig.ALIGNOF), NkDrawList.__member(POINTER_SIZE), NkDrawList.__member(POINTER_SIZE), NkDrawList.__member(POINTER_SIZE), NkDrawList.__member(4), NkDrawList.__member(4), NkDrawList.__member(4), NkDrawList.__member(POINTER_SIZE), NkDrawList.__member(4), NkDrawList.__member(4), NkDrawList.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CLIP_RECT = layout.offsetof(0);
        CIRCLE_VTX = layout.offsetof(1);
        CONFIG = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        VERTICES = layout.offsetof(4);
        ELEMENTS = layout.offsetof(5);
        ELEMENT_COUNT = layout.offsetof(6);
        VERTEX_COUNT = layout.offsetof(7);
        CMD_COUNT = layout.offsetof(8);
        CMD_OFFSET = layout.offsetof(9);
        PATH_COUNT = layout.offsetof(10);
        PATH_OFFSET = layout.offsetof(11);
        USERDATA = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<NkDrawList, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkDrawList newInstance(long address) {
            return new NkDrawList(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkRect clip_rect() {
            return NkDrawList.nclip_rect(this.address());
        }

        public NkVec2.Buffer circle_vtx() {
            return NkDrawList.ncircle_vtx(this.address());
        }

        public NkVec2 circle_vtx(int index) {
            return NkDrawList.ncircle_vtx(this.address(), index);
        }

        public NkConvertConfig config() {
            return NkDrawList.nconfig(this.address());
        }

        public NkBuffer buffer() {
            return NkDrawList.nbuffer(this.address());
        }

        public NkBuffer vertices() {
            return NkDrawList.nvertices(this.address());
        }

        public NkBuffer elements() {
            return NkDrawList.nelements(this.address());
        }

        public int element_count() {
            return NkDrawList.nelement_count(this.address());
        }

        public int vertex_count() {
            return NkDrawList.nvertex_count(this.address());
        }

        public int cmd_count() {
            return NkDrawList.ncmd_count(this.address());
        }

        public long cmd_offset() {
            return NkDrawList.ncmd_offset(this.address());
        }

        public int path_count() {
            return NkDrawList.npath_count(this.address());
        }

        public int path_offset() {
            return NkDrawList.npath_offset(this.address());
        }

        public NkHandle userdata() {
            return NkDrawList.nuserdata(this.address());
        }
    }
}

