/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkDrawVertexLayoutElement
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTRIBUTE;
    public static final int FORMAT;
    public static final int OFFSET;

    NkDrawVertexLayoutElement(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkDrawVertexLayoutElement(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkDrawVertexLayoutElement.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int attribute() {
        return NkDrawVertexLayoutElement.nattribute(this.address());
    }

    public int format() {
        return NkDrawVertexLayoutElement.nformat(this.address());
    }

    public long offset() {
        return NkDrawVertexLayoutElement.noffset(this.address());
    }

    public NkDrawVertexLayoutElement attribute(int value) {
        NkDrawVertexLayoutElement.nattribute(this.address(), value);
        return this;
    }

    public NkDrawVertexLayoutElement format(int value) {
        NkDrawVertexLayoutElement.nformat(this.address(), value);
        return this;
    }

    public NkDrawVertexLayoutElement offset(long value) {
        NkDrawVertexLayoutElement.noffset(this.address(), value);
        return this;
    }

    public NkDrawVertexLayoutElement set(int attribute, int format, long offset) {
        this.attribute(attribute);
        this.format(format);
        this.offset(offset);
        return this;
    }

    public NkDrawVertexLayoutElement set(NkDrawVertexLayoutElement src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkDrawVertexLayoutElement malloc() {
        return NkDrawVertexLayoutElement.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkDrawVertexLayoutElement calloc() {
        return NkDrawVertexLayoutElement.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkDrawVertexLayoutElement create() {
        return new NkDrawVertexLayoutElement(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkDrawVertexLayoutElement create(long address) {
        return address == 0L ? null : new NkDrawVertexLayoutElement(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkDrawVertexLayoutElement.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkDrawVertexLayoutElement.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkDrawVertexLayoutElement mallocStack() {
        return NkDrawVertexLayoutElement.mallocStack(MemoryStack.stackGet());
    }

    public static NkDrawVertexLayoutElement callocStack() {
        return NkDrawVertexLayoutElement.callocStack(MemoryStack.stackGet());
    }

    public static NkDrawVertexLayoutElement mallocStack(MemoryStack stack) {
        return NkDrawVertexLayoutElement.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkDrawVertexLayoutElement callocStack(MemoryStack stack) {
        return NkDrawVertexLayoutElement.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkDrawVertexLayoutElement.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkDrawVertexLayoutElement.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkDrawVertexLayoutElement.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkDrawVertexLayoutElement.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nattribute(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTRIBUTE);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    public static void nattribute(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTRIBUTE, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = NkDrawVertexLayoutElement.__struct(NkDrawVertexLayoutElement.__member(4), NkDrawVertexLayoutElement.__member(4), NkDrawVertexLayoutElement.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTRIBUTE = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkDrawVertexLayoutElement, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkDrawVertexLayoutElement newInstance(long address) {
            return new NkDrawVertexLayoutElement(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int attribute() {
            return NkDrawVertexLayoutElement.nattribute(this.address());
        }

        public int format() {
            return NkDrawVertexLayoutElement.nformat(this.address());
        }

        public long offset() {
            return NkDrawVertexLayoutElement.noffset(this.address());
        }

        public Buffer attribute(int value) {
            NkDrawVertexLayoutElement.nattribute(this.address(), value);
            return this;
        }

        public Buffer format(int value) {
            NkDrawVertexLayoutElement.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(long value) {
            NkDrawVertexLayoutElement.noffset(this.address(), value);
            return this;
        }
    }
}

