/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkScroll;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkEditState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SEQ;
    public static final int OLD;
    public static final int ACTIVE;
    public static final int PREV;
    public static final int CURSOR;
    public static final int SEL_START;
    public static final int SEL_END;
    public static final int SCROLLBAR;
    public static final int MODE;
    public static final int SINGLE_LINE;

    NkEditState(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkEditState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkEditState.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int name() {
        return NkEditState.nname(this.address());
    }

    public int seq() {
        return NkEditState.nseq(this.address());
    }

    public int old() {
        return NkEditState.nold(this.address());
    }

    public int active() {
        return NkEditState.nactive(this.address());
    }

    public int prev() {
        return NkEditState.nprev(this.address());
    }

    public int cursor() {
        return NkEditState.ncursor(this.address());
    }

    public int sel_start() {
        return NkEditState.nsel_start(this.address());
    }

    public int sel_end() {
        return NkEditState.nsel_end(this.address());
    }

    public NkScroll scrollbar() {
        return NkEditState.nscrollbar(this.address());
    }

    public byte mode() {
        return NkEditState.nmode(this.address());
    }

    public boolean single_line() {
        return NkEditState.nsingle_line(this.address());
    }

    public static NkEditState create(long address) {
        return address == 0L ? null : new NkEditState(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int nname(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NAME);
    }

    public static int nseq(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEQ);
    }

    public static int nold(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLD);
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACTIVE);
    }

    public static int nprev(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PREV);
    }

    public static int ncursor(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURSOR);
    }

    public static int nsel_start(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEL_START);
    }

    public static int nsel_end(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SEL_END);
    }

    public static NkScroll nscrollbar(long struct) {
        return NkScroll.create(struct + (long)SCROLLBAR);
    }

    public static byte nmode(long struct) {
        return MemoryUtil.memGetByte(struct + (long)MODE);
    }

    public static boolean nsingle_line(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SINGLE_LINE) != 0;
    }

    static {
        Struct.Layout layout = NkEditState.__struct(NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(4), NkEditState.__member(NkScroll.SIZEOF, NkScroll.ALIGNOF), NkEditState.__member(1), NkEditState.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SEQ = layout.offsetof(1);
        OLD = layout.offsetof(2);
        ACTIVE = layout.offsetof(3);
        PREV = layout.offsetof(4);
        CURSOR = layout.offsetof(5);
        SEL_START = layout.offsetof(6);
        SEL_END = layout.offsetof(7);
        SCROLLBAR = layout.offsetof(8);
        MODE = layout.offsetof(9);
        SINGLE_LINE = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<NkEditState, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkEditState newInstance(long address) {
            return new NkEditState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int name() {
            return NkEditState.nname(this.address());
        }

        public int seq() {
            return NkEditState.nseq(this.address());
        }

        public int old() {
            return NkEditState.nold(this.address());
        }

        public int active() {
            return NkEditState.nactive(this.address());
        }

        public int prev() {
            return NkEditState.nprev(this.address());
        }

        public int cursor() {
            return NkEditState.ncursor(this.address());
        }

        public int sel_start() {
            return NkEditState.nsel_start(this.address());
        }

        public int sel_end() {
            return NkEditState.nsel_end(this.address());
        }

        public NkScroll scrollbar() {
            return NkEditState.nscrollbar(this.address());
        }

        public byte mode() {
            return NkEditState.nmode(this.address());
        }

        public boolean single_line() {
            return NkEditState.nsingle_line(this.address());
        }
    }
}

