/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkHandle
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int ID;

    NkHandle(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkHandle(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkHandle.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long ptr() {
        return NkHandle.nptr(this.address());
    }

    public int id() {
        return NkHandle.nid(this.address());
    }

    public NkHandle ptr(long value) {
        NkHandle.nptr(this.address(), value);
        return this;
    }

    public NkHandle id(int value) {
        NkHandle.nid(this.address(), value);
        return this;
    }

    public NkHandle set(NkHandle src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkHandle malloc() {
        return NkHandle.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkHandle calloc() {
        return NkHandle.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkHandle create() {
        return new NkHandle(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkHandle create(long address) {
        return address == 0L ? null : new NkHandle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkHandle.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkHandle.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkHandle mallocStack() {
        return NkHandle.mallocStack(MemoryStack.stackGet());
    }

    public static NkHandle callocStack() {
        return NkHandle.callocStack(MemoryStack.stackGet());
    }

    public static NkHandle mallocStack(MemoryStack stack) {
        return NkHandle.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkHandle callocStack(MemoryStack stack) {
        return NkHandle.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkHandle.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkHandle.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkHandle.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkHandle.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nptr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PTR);
    }

    public static int nid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ID);
    }

    public static void nptr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PTR, value);
    }

    public static void nid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ID, value);
    }

    static {
        Struct.Layout layout = NkHandle.__union(NkHandle.__member(POINTER_SIZE), NkHandle.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR = layout.offsetof(0);
        ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkHandle, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkHandle newInstance(long address) {
            return new NkHandle(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long ptr() {
            return NkHandle.nptr(this.address());
        }

        public int id() {
            return NkHandle.nid(this.address());
        }

        public Buffer ptr(long value) {
            NkHandle.nptr(this.address(), value);
            return this;
        }

        public Buffer id(int value) {
            NkHandle.nid(this.address(), value);
            return this;
        }
    }
}

