/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int W;
    public static final int H;
    public static final int REGION;

    NkImage(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkImage(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkImage.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkHandle handle() {
        return NkImage.nhandle(this.address());
    }

    public short w() {
        return NkImage.nw(this.address());
    }

    public short h() {
        return NkImage.nh(this.address());
    }

    public ShortBuffer region() {
        return NkImage.nregion(this.address());
    }

    public short region(int index) {
        return NkImage.nregion(this.address(), index);
    }

    public NkImage handle(NkHandle value) {
        NkImage.nhandle(this.address(), value);
        return this;
    }

    public NkImage w(short value) {
        NkImage.nw(this.address(), value);
        return this;
    }

    public NkImage h(short value) {
        NkImage.nh(this.address(), value);
        return this;
    }

    public NkImage region(ShortBuffer value) {
        NkImage.nregion(this.address(), value);
        return this;
    }

    public NkImage region(int index, short value) {
        NkImage.nregion(this.address(), index, value);
        return this;
    }

    public NkImage set(NkHandle handle, short w, short h, ShortBuffer region) {
        this.handle(handle);
        this.w(w);
        this.h(h);
        this.region(region);
        return this;
    }

    public NkImage set(NkImage src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkImage malloc() {
        return NkImage.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkImage calloc() {
        return NkImage.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkImage create() {
        return new NkImage(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkImage create(long address) {
        return address == 0L ? null : new NkImage(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkImage.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkImage.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkImage mallocStack() {
        return NkImage.mallocStack(MemoryStack.stackGet());
    }

    public static NkImage callocStack() {
        return NkImage.callocStack(MemoryStack.stackGet());
    }

    public static NkImage mallocStack(MemoryStack stack) {
        return NkImage.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkImage callocStack(MemoryStack stack) {
        return NkImage.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkImage.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkImage.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkImage.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkImage.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkHandle nhandle(long struct) {
        return NkHandle.create(struct + (long)HANDLE);
    }

    public static short nw(long struct) {
        return MemoryUtil.memGetShort(struct + (long)W);
    }

    public static short nh(long struct) {
        return MemoryUtil.memGetShort(struct + (long)H);
    }

    public static ShortBuffer nregion(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)REGION, 4);
    }

    public static short nregion(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return MemoryUtil.memGetShort(struct + (long)REGION + (long)(index * 2));
    }

    public static void nhandle(long struct, NkHandle value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HANDLE, NkHandle.SIZEOF);
    }

    public static void nw(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)W, value);
    }

    public static void nh(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)H, value);
    }

    public static void nregion(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)REGION, value.remaining() * 2);
    }

    public static void nregion(long struct, int index, short value) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        MemoryUtil.memPutShort(struct + (long)REGION + (long)(index * 2), value);
    }

    static {
        Struct.Layout layout = NkImage.__struct(NkImage.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkImage.__member(2), NkImage.__member(2), NkImage.__array(2, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        W = layout.offsetof(1);
        H = layout.offsetof(2);
        REGION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkImage, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkImage newInstance(long address) {
            return new NkImage(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkHandle handle() {
            return NkImage.nhandle(this.address());
        }

        public short w() {
            return NkImage.nw(this.address());
        }

        public short h() {
            return NkImage.nh(this.address());
        }

        public ShortBuffer region() {
            return NkImage.nregion(this.address());
        }

        public short region(int index) {
            return NkImage.nregion(this.address(), index);
        }

        public Buffer handle(NkHandle value) {
            NkImage.nhandle(this.address(), value);
            return this;
        }

        public Buffer w(short value) {
            NkImage.nw(this.address(), value);
            return this;
        }

        public Buffer h(short value) {
            NkImage.nh(this.address(), value);
            return this;
        }

        public Buffer region(ShortBuffer value) {
            NkImage.nregion(this.address(), value);
            return this;
        }

        public Buffer region(int index, short value) {
            NkImage.nregion(this.address(), index, value);
            return this;
        }
    }
}

