/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkKey
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DOWN;
    public static final int CLICKED;

    NkKey(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkKey(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkKey.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int down() {
        return NkKey.ndown(this.address());
    }

    public int clicked() {
        return NkKey.nclicked(this.address());
    }

    public static NkKey create(long address) {
        return address == 0L ? null : new NkKey(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static int ndown(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DOWN);
    }

    public static int nclicked(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLICKED);
    }

    static {
        Struct.Layout layout = NkKey.__struct(NkKey.__member(4), NkKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DOWN = layout.offsetof(0);
        CLICKED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkKey, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkKey newInstance(long address) {
            return new NkKey(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int down() {
            return NkKey.ndown(this.address());
        }

        public int clicked() {
            return NkKey.nclicked(this.address());
        }
    }
}

