/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkKey;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkKeyboard
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYS;
    public static final int TEXT;
    public static final int TEXT_LEN;

    NkKeyboard(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkKeyboard(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkKeyboard.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkKey.Buffer keys() {
        return NkKeyboard.nkeys(this.address());
    }

    public NkKey keys(int index) {
        return NkKeyboard.nkeys(this.address(), index);
    }

    public ByteBuffer text() {
        return NkKeyboard.ntext(this.address());
    }

    public byte text(int index) {
        return NkKeyboard.ntext(this.address(), index);
    }

    public int text_len() {
        return NkKeyboard.ntext_len(this.address());
    }

    public static NkKeyboard create(long address) {
        return address == 0L ? null : new NkKeyboard(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkKey.Buffer nkeys(long struct) {
        return NkKey.create(struct + (long)KEYS, 30);
    }

    public static NkKey nkeys(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 30);
        }
        return NkKey.create(struct + (long)KEYS + (long)(index * NkKey.SIZEOF));
    }

    public static ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)TEXT, 16);
    }

    public static byte ntext(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 16);
        }
        return MemoryUtil.memGetByte(struct + (long)TEXT + (long)(index * 1));
    }

    public static int ntext_len(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXT_LEN);
    }

    static {
        Struct.Layout layout = NkKeyboard.__struct(NkKeyboard.__array(NkKey.SIZEOF, NkKey.ALIGNOF, 30), NkKeyboard.__array(1, 16), NkKeyboard.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYS = layout.offsetof(0);
        TEXT = layout.offsetof(1);
        TEXT_LEN = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkKeyboard, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkKeyboard newInstance(long address) {
            return new NkKeyboard(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkKey.Buffer keys() {
            return NkKeyboard.nkeys(this.address());
        }

        public NkKey keys(int index) {
            return NkKeyboard.nkeys(this.address(), index);
        }

        public ByteBuffer text() {
            return NkKeyboard.ntext(this.address());
        }

        public byte text(int index) {
            return NkKeyboard.ntext(this.address(), index);
        }

        public int text_len() {
            return NkKeyboard.ntext_len(this.address());
        }
    }
}

