/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkContext;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkListView
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BEGIN;
    public static final int END;
    public static final int COUNT;
    public static final int TOTAL_HEIGHT;
    public static final int CTX;
    public static final int SCROLL_POINTER;
    public static final int SCROLL_VALUE;

    NkListView(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkListView(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkListView.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int begin() {
        return NkListView.nbegin(this.address());
    }

    public int end() {
        return NkListView.nend(this.address());
    }

    public int count() {
        return NkListView.ncount(this.address());
    }

    public static NkListView malloc() {
        return NkListView.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkListView calloc() {
        return NkListView.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkListView create() {
        return new NkListView(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkListView create(long address) {
        return address == 0L ? null : new NkListView(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkListView.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkListView.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkListView mallocStack() {
        return NkListView.mallocStack(MemoryStack.stackGet());
    }

    public static NkListView callocStack() {
        return NkListView.callocStack(MemoryStack.stackGet());
    }

    public static NkListView mallocStack(MemoryStack stack) {
        return NkListView.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkListView callocStack(MemoryStack stack) {
        return NkListView.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkListView.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkListView.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkListView.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkListView.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbegin(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BEGIN);
    }

    public static int nend(long struct) {
        return MemoryUtil.memGetInt(struct + (long)END);
    }

    public static int ncount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COUNT);
    }

    public static int ntotal_height(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOTAL_HEIGHT);
    }

    public static NkContext nctx(long struct) {
        return NkContext.create(MemoryUtil.memGetAddress(struct + (long)CTX));
    }

    public static IntBuffer nscroll_pointer(long struct, int capacity) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)SCROLL_POINTER), capacity);
    }

    public static int nscroll_value(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCROLL_VALUE);
    }

    static {
        Struct.Layout layout = NkListView.__struct(NkListView.__member(4), NkListView.__member(4), NkListView.__member(4), NkListView.__member(4), NkListView.__member(POINTER_SIZE), NkListView.__member(POINTER_SIZE), NkListView.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BEGIN = layout.offsetof(0);
        END = layout.offsetof(1);
        COUNT = layout.offsetof(2);
        TOTAL_HEIGHT = layout.offsetof(3);
        CTX = layout.offsetof(4);
        SCROLL_POINTER = layout.offsetof(5);
        SCROLL_VALUE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<NkListView, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkListView newInstance(long address) {
            return new NkListView(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int begin() {
            return NkListView.nbegin(this.address());
        }

        public int end() {
            return NkListView.nend(this.address());
        }

        public int count() {
            return NkListView.ncount(this.address());
        }
    }
}

