/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkMemory
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR;
    public static final int SIZE;

    NkMemory(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkMemory(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkMemory.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer ptr() {
        return NkMemory.nptr(this.address());
    }

    public long size() {
        return NkMemory.nsize(this.address());
    }

    public static NkMemory create(long address) {
        return address == 0L ? null : new NkMemory(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static ByteBuffer nptr(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PTR), (int)NkMemory.nsize(struct));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    static {
        Struct.Layout layout = NkMemory.__struct(NkMemory.__member(POINTER_SIZE), NkMemory.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkMemory, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkMemory newInstance(long address) {
            return new NkMemory(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer ptr() {
            return NkMemory.nptr(this.address());
        }

        public long size() {
            return NkMemory.nsize(this.address());
        }
    }
}

