/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkMemoryStatus
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORY;
    public static final int TYPE;
    public static final int SIZE;
    public static final int ALLOCATED;
    public static final int NEEDED;
    public static final int CALLS;

    NkMemoryStatus(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkMemoryStatus(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkMemoryStatus.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer memory() {
        return NkMemoryStatus.nmemory(this.address());
    }

    public int type() {
        return NkMemoryStatus.ntype(this.address());
    }

    public long size() {
        return NkMemoryStatus.nsize(this.address());
    }

    public long allocated() {
        return NkMemoryStatus.nallocated(this.address());
    }

    public long needed() {
        return NkMemoryStatus.nneeded(this.address());
    }

    public long calls() {
        return NkMemoryStatus.ncalls(this.address());
    }

    public static NkMemoryStatus malloc() {
        return NkMemoryStatus.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NkMemoryStatus calloc() {
        return NkMemoryStatus.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NkMemoryStatus create() {
        return new NkMemoryStatus(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NkMemoryStatus create(long address) {
        return address == 0L ? null : new NkMemoryStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NkMemoryStatus.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkMemoryStatus.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkMemoryStatus mallocStack() {
        return NkMemoryStatus.mallocStack(MemoryStack.stackGet());
    }

    public static NkMemoryStatus callocStack() {
        return NkMemoryStatus.callocStack(MemoryStack.stackGet());
    }

    public static NkMemoryStatus mallocStack(MemoryStack stack) {
        return NkMemoryStatus.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkMemoryStatus callocStack(MemoryStack stack) {
        return NkMemoryStatus.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkMemoryStatus.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkMemoryStatus.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkMemoryStatus.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkMemoryStatus.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nmemory(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MEMORY), (int)NkMemoryStatus.nsize(struct));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long nallocated(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ALLOCATED);
    }

    public static long nneeded(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEEDED);
    }

    public static long ncalls(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CALLS);
    }

    static {
        Struct.Layout layout = NkMemoryStatus.__struct(NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(4), NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORY = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
        ALLOCATED = layout.offsetof(3);
        NEEDED = layout.offsetof(4);
        CALLS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkMemoryStatus, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkMemoryStatus newInstance(long address) {
            return new NkMemoryStatus(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer memory() {
            return NkMemoryStatus.nmemory(this.address());
        }

        public int type() {
            return NkMemoryStatus.ntype(this.address());
        }

        public long size() {
            return NkMemoryStatus.nsize(this.address());
        }

        public long allocated() {
            return NkMemoryStatus.nallocated(this.address());
        }

        public long needed() {
            return NkMemoryStatus.nneeded(this.address());
        }

        public long calls() {
            return NkMemoryStatus.ncalls(this.address());
        }
    }
}

