/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.lwjgl.nuklear.NkMouseButton;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NkMouse
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUTTONS;
    public static final int POS;
    public static final int PREV;
    public static final int DELTA;
    public static final int SCROLL_DELTA;
    public static final int GRAB;
    public static final int GRABBED;
    public static final int UNGRAB;

    NkMouse(long address, ByteBuffer container) {
        super(address, container);
    }

    public NkMouse(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NkMouse.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public NkMouseButton.Buffer buttons() {
        return NkMouse.nbuttons(this.address());
    }

    public NkMouseButton buttons(int index) {
        return NkMouse.nbuttons(this.address(), index);
    }

    public NkVec2 pos() {
        return NkMouse.npos(this.address());
    }

    public NkVec2 prev() {
        return NkMouse.nprev(this.address());
    }

    public NkVec2 delta() {
        return NkMouse.ndelta(this.address());
    }

    public NkVec2 scroll_delta() {
        return NkMouse.nscroll_delta(this.address());
    }

    public boolean grab() {
        return NkMouse.ngrab(this.address());
    }

    public boolean grabbed() {
        return NkMouse.ngrabbed(this.address());
    }

    public boolean ungrab() {
        return NkMouse.nungrab(this.address());
    }

    public static NkMouse create(long address) {
        return address == 0L ? null : new NkMouse(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NkMouseButton.Buffer nbuttons(long struct) {
        return NkMouseButton.create(struct + (long)BUTTONS, 4);
    }

    public static NkMouseButton nbuttons(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check(index, 4);
        }
        return NkMouseButton.create(struct + (long)BUTTONS + (long)(index * NkMouseButton.SIZEOF));
    }

    public static NkVec2 npos(long struct) {
        return NkVec2.create(struct + (long)POS);
    }

    public static NkVec2 nprev(long struct) {
        return NkVec2.create(struct + (long)PREV);
    }

    public static NkVec2 ndelta(long struct) {
        return NkVec2.create(struct + (long)DELTA);
    }

    public static NkVec2 nscroll_delta(long struct) {
        return NkVec2.create(struct + (long)SCROLL_DELTA);
    }

    public static boolean ngrab(long struct) {
        return MemoryUtil.memGetByte(struct + (long)GRAB) != 0;
    }

    public static boolean ngrabbed(long struct) {
        return MemoryUtil.memGetByte(struct + (long)GRABBED) != 0;
    }

    public static boolean nungrab(long struct) {
        return MemoryUtil.memGetByte(struct + (long)UNGRAB) != 0;
    }

    static {
        Struct.Layout layout = NkMouse.__struct(NkMouse.__array(NkMouseButton.SIZEOF, NkMouseButton.ALIGNOF, 4), NkMouse.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkMouse.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkMouse.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkMouse.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkMouse.__member(1), NkMouse.__member(1), NkMouse.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUTTONS = layout.offsetof(0);
        POS = layout.offsetof(1);
        PREV = layout.offsetof(2);
        DELTA = layout.offsetof(3);
        SCROLL_DELTA = layout.offsetof(4);
        GRAB = layout.offsetof(5);
        GRABBED = layout.offsetof(6);
        UNGRAB = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<NkMouse, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NkMouse newInstance(long address) {
            return new NkMouse(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public NkMouseButton.Buffer buttons() {
            return NkMouse.nbuttons(this.address());
        }

        public NkMouseButton buttons(int index) {
            return NkMouse.nbuttons(this.address(), index);
        }

        public NkVec2 pos() {
            return NkMouse.npos(this.address());
        }

        public NkVec2 prev() {
            return NkMouse.nprev(this.address());
        }

        public NkVec2 delta() {
            return NkMouse.ndelta(this.address());
        }

        public NkVec2 scroll_delta() {
            return NkMouse.nscroll_delta(this.address());
        }

        public boolean grab() {
            return NkMouse.ngrab(this.address());
        }

        public boolean grabbed() {
            return NkMouse.ngrabbed(this.address());
        }

        public boolean ungrab() {
            return NkMouse.nungrab(this.address());
        }
    }
}

